/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class CollectableItem {
    private final UUID id;
    private final UUID playerId;
    private final ItemStack itemStack;
    private final CollectionType type;
    private final double price;
    private final LocalDateTime addedTime;
    private final LocalDateTime expiryTime;

    public CollectableItem(UUID playerId, ItemStack itemStack, CollectionType type, double price) {
        this.id = UUID.randomUUID();
        this.playerId = playerId;
        this.itemStack = itemStack;
        this.type = type;
        this.price = price;
        this.addedTime = LocalDateTime.now();
        this.expiryTime = this.addedTime.plusDays(30L);
    }

    public CollectableItem(UUID id, UUID playerId, ItemStack itemStack, CollectionType type, double price, LocalDateTime addedTime, LocalDateTime expiryTime) {
        this.id = id;
        this.playerId = playerId;
        this.itemStack = itemStack;
        this.type = type;
        this.price = price;
        this.addedTime = addedTime;
        this.expiryTime = expiryTime;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public CollectionType getType() {
        return this.type;
    }

    public double getPrice() {
        return this.price;
    }

    public LocalDateTime getAddedTime() {
        return this.addedTime;
    }

    public LocalDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public boolean isExpired() {
        return LocalDateTime.now().isAfter(this.expiryTime);
    }

    public String getFormattedTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd HH:mm");
        return this.addedTime.format(formatter);
    }

    public long getDaysUntilExpiry() {
        return Duration.between(LocalDateTime.now(), this.expiryTime).toDays();
    }

    public static enum CollectionType {
        EXPIRED_LISTING,
        SOLD_ITEM,
        AUCTION_WON,
        OUTBID_RETURN,
        CANCELLED_LISTING,
        SHOP_RETURN,
        SHOP_REMOVED;

    }
}

