/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import MPP.marketPlacePlus.utils.ItemUtils;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class TradeHistory {
    private final String id;
    private final UUID sellerId;
    private final String sellerName;
    private final UUID buyerId;
    private final String buyerName;
    private final ItemStack item;
    private final String serializedItem;
    private final double price;
    private final int quantity;
    private final LocalDateTime tradeTime;
    private final TradeType type;

    public TradeHistory(String id, UUID sellerId, String sellerName, UUID buyerId, String buyerName, ItemStack item, String serializedItem, double price, int quantity, LocalDateTime tradeTime, TradeType type) {
        this.id = id;
        this.sellerId = sellerId;
        this.sellerName = sellerName;
        this.buyerId = buyerId;
        this.buyerName = buyerName;
        this.item = item;
        this.serializedItem = serializedItem;
        this.price = price;
        this.quantity = quantity;
        this.tradeTime = tradeTime;
        this.type = type;
    }

    public double getPricePerItem() {
        return this.price / (double)this.quantity;
    }

    public String getId() {
        return this.id;
    }

    public UUID getSellerId() {
        return this.sellerId;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public UUID getBuyerId() {
        return this.buyerId;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public String getSerializedItem() {
        return this.serializedItem;
    }

    public double getPrice() {
        return this.price;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public LocalDateTime getTradeTime() {
        return this.tradeTime;
    }

    public TradeType getType() {
        return this.type;
    }

    public String getFormattedMessage() {
        String itemName = ItemUtils.getItemName(this.item);
        String typeStr = this.type.name().replace("_", " ");
        long timeAgo = System.currentTimeMillis() - this.tradeTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return String.format("\u00a77%s \u00a7e%s \u00a77x%d to \u00a7e%s \u00a77for \u00a7a$%.2f \u00a77(%s) \u00a78- %s", this.sellerName, itemName, this.quantity, this.buyerName, this.price, typeStr, TimeUtils.formatTime(timeAgo));
    }

    public static enum TradeType {
        AUCTION_HOUSE,
        PLAYER_SHOP,
        DIRECT_TRADE,
        AUCTION;

    }
}

