/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.tasks;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MarketplaceTask
extends BukkitRunnable {
    private final MarketPlacePlus plugin;

    public MarketplaceTask(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    public void run() {
        this.processEndedAuctions();
        this.cleanupExpiredListings();
        this.saveDataPeriodically();
        this.cleanupOfflinePlayers();
        this.updateMetrics();
    }

    private void processEndedAuctions() {
        this.plugin.getAuctionManager().processEndedAuctions();
    }

    private void cleanupExpiredListings() {
        this.plugin.getAuctionManager().cleanupExpiredListings();
    }

    private void saveDataPeriodically() {
        this.plugin.getShopManager().getActiveShops().forEach(shop -> this.plugin.getDatabaseManager().updateShop((PlayerShop)shop));
    }

    private void cleanupOfflinePlayers() {
        BaseGUI.cleanupOfflinePlayers();
    }

    private void updateMetrics() {
        int activeListings = this.plugin.getAuctionManager().getActiveListings().size();
        int activeShops = this.plugin.getShopManager().getActiveShops().size();
    }

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.plugin, 6000L, 6000L);
    }
}

