/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.utils;

import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.utils.ItemUtils;
import MPP.marketPlacePlus.utils.SearchHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;

public class SearchUtils {
    public static SearchFilter createItemSearch() {
        return new SearchFilter();
    }

    public static ShopSearchFilter createShopSearch() {
        return new ShopSearchFilter();
    }

    public static List<String> extractKeywords(String query) {
        return Arrays.stream(query.toLowerCase().split("\\s+")).filter(word -> word.length() > 2).collect(Collectors.toList());
    }

    public static boolean matchesKeywords(String text, List<String> keywords) {
        String lowerText = text.toLowerCase();
        return keywords.stream().allMatch(keyword -> {
            Set<String> expanded = SearchHelper.expandSearchTerms(keyword);
            return expanded.stream().anyMatch(lowerText::contains) || SearchHelper.calculateFuzzyScore(lowerText, keyword) > 0.7;
        });
    }

    public static List<String> getSuggestions(String query) {
        return SearchHelper.suggestCorrections(query);
    }

    public static Map<Material, Double> searchMaterials(String query) {
        HashMap<Material, Double> results = new HashMap<Material, Double>();
        SearchHelper.SmartMatcher matcher = new SearchHelper.SmartMatcher(query, 0.5);
        List<Material> aliased = SearchHelper.getMaterialsFromAlias(query);
        for (Material mat : aliased) {
            results.put(mat, 1.0);
        }
        for (Material material : Material.values()) {
            String name;
            double score;
            if (results.containsKey(material) || !((score = matcher.getScore(name = material.name().toLowerCase().replace("_", " "))) > 0.5) && !SearchHelper.matchesTags(material, query)) continue;
            results.put(material, score);
        }
        return results;
    }

    public static class SearchFilter {
        private String query = "";
        private Material material = null;
        private Double minPrice = null;
        private Double maxPrice = null;
        private String category = null;
        private Map<Enchantment, Integer> requiredEnchants = new HashMap<Enchantment, Integer>();
        private List<String> loreTags = new ArrayList<String>();
        private String sellerName = null;
        private boolean auctionsOnly = false;
        private boolean buyNowOnly = false;
        private SortType sortType = SortType.NEWEST;
        private int maxResults = 100;

        public SearchFilter withQuery(String query) {
            this.query = query.toLowerCase();
            return this;
        }

        public SearchFilter withMaterial(Material material) {
            this.material = material;
            return this;
        }

        public SearchFilter withPriceRange(Double min, Double max) {
            this.minPrice = min;
            this.maxPrice = max;
            return this;
        }

        public SearchFilter withCategory(String category) {
            this.category = category;
            return this;
        }

        public SearchFilter withEnchantment(Enchantment enchant, int minLevel) {
            this.requiredEnchants.put(enchant, minLevel);
            return this;
        }

        public SearchFilter withLoreContaining(String ... tags) {
            this.loreTags.addAll(Arrays.asList(tags));
            return this;
        }

        public SearchFilter withSeller(String sellerName) {
            this.sellerName = sellerName;
            return this;
        }

        public SearchFilter auctionsOnly() {
            this.auctionsOnly = true;
            this.buyNowOnly = false;
            return this;
        }

        public SearchFilter buyNowOnly() {
            this.buyNowOnly = true;
            this.auctionsOnly = false;
            return this;
        }

        public SearchFilter sortBy(SortType sortType) {
            this.sortType = sortType;
            return this;
        }

        public SearchFilter withMaxResults(int max) {
            this.maxResults = max;
            return this;
        }

        public Predicate<MarketItem> buildPredicate() {
            return item -> {
                if (item.isSold() || item.isExpired()) {
                    return false;
                }
                if (!this.query.isEmpty()) {
                    String itemName = ItemUtils.getItemName(item.getItemStack()).toLowerCase();
                    String string = item.getItemStack().getType().name().toLowerCase();
                    SearchHelper.SmartMatcher matcher = new SearchHelper.SmartMatcher(this.query, 0.7);
                    boolean basicMatch = itemName.contains(this.query) || string.contains(this.query);
                    boolean fuzzyMatch = matcher.matches(itemName) || matcher.matches(string);
                    boolean tagMatch = SearchHelper.matchesTags(item.getItemStack().getType(), this.query);
                    List<Material> aliasedMaterials = SearchHelper.getMaterialsFromAlias(this.query);
                    boolean aliasMatch = aliasedMaterials.contains(item.getItemStack().getType());
                    if (!(basicMatch || fuzzyMatch || tagMatch || aliasMatch)) {
                        return false;
                    }
                }
                if (this.material != null && item.getItemStack().getType() != this.material) {
                    return false;
                }
                if (this.minPrice != null && item.getPrice() < this.minPrice) {
                    return false;
                }
                if (this.maxPrice != null && item.getPrice() > this.maxPrice) {
                    return false;
                }
                if (this.category != null && !item.getCategory().equalsIgnoreCase(this.category)) {
                    return false;
                }
                if (this.sellerName != null && !item.getSellerName().equalsIgnoreCase(this.sellerName)) {
                    return false;
                }
                if (this.auctionsOnly && !item.isAuction()) {
                    return false;
                }
                if (this.buyNowOnly && item.isAuction()) {
                    return false;
                }
                if (!this.requiredEnchants.isEmpty()) {
                    for (Map.Entry entry : this.requiredEnchants.entrySet()) {
                        int level = item.getItemStack().getEnchantmentLevel((Enchantment)entry.getKey());
                        if (level >= (Integer)entry.getValue()) continue;
                        return false;
                    }
                }
                if (!this.loreTags.isEmpty()) {
                    ItemMeta meta = item.getItemStack().getItemMeta();
                    if (meta == null || !meta.hasLore()) {
                        return false;
                    }
                    List list = meta.getLore();
                    for (String tag : this.loreTags) {
                        boolean found = false;
                        for (String line : list) {
                            if (!line.toLowerCase().contains(tag.toLowerCase())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return false;
                    }
                }
                return true;
            };
        }

        public Comparator<MarketItem> buildComparator() {
            switch (this.sortType.ordinal()) {
                case 1: {
                    return Comparator.comparing(MarketItem::getListedTime);
                }
                case 2: {
                    return Comparator.comparing(MarketItem::getPrice);
                }
                case 3: {
                    return Comparator.comparing(MarketItem::getPrice).reversed();
                }
                case 4: {
                    return Comparator.comparing(item -> ItemUtils.getItemName(item.getItemStack()));
                }
                case 5: {
                    return Comparator.comparing(item -> ItemUtils.getItemName(item.getItemStack())).reversed();
                }
                case 6: {
                    return Comparator.comparing(MarketItem::getSellerName);
                }
                case 7: {
                    return Comparator.comparing(MarketItem::getExpiryTime);
                }
            }
            return Comparator.comparing(MarketItem::getListedTime).reversed();
        }

        public List<MarketItem> search(List<MarketItem> items) {
            if (!this.query.isEmpty()) {
                SearchHelper.SmartMatcher matcher = new SearchHelper.SmartMatcher(this.query, 0.7);
                return items.stream().filter(this.buildPredicate()).sorted((a, b) -> {
                    double scoreB;
                    if (this.sortType == SortType.NEWEST || this.sortType == SortType.OLDEST) {
                        return this.buildComparator().compare((MarketItem)a, (MarketItem)b);
                    }
                    String aName = ItemUtils.getItemName(a.getItemStack());
                    String bName = ItemUtils.getItemName(b.getItemStack());
                    double scoreA = matcher.getScore(aName);
                    if (Math.abs(scoreA - (scoreB = matcher.getScore(bName))) > 0.01) {
                        return Double.compare(scoreB, scoreA);
                    }
                    return this.buildComparator().compare((MarketItem)a, (MarketItem)b);
                }).limit(this.maxResults).collect(Collectors.toList());
            }
            return items.stream().filter(this.buildPredicate()).sorted(this.buildComparator()).limit(this.maxResults).collect(Collectors.toList());
        }

        public static enum SortType {
            NEWEST,
            OLDEST,
            PRICE_LOW_HIGH,
            PRICE_HIGH_LOW,
            NAME_AZ,
            NAME_ZA,
            SELLER_AZ,
            ENDING_SOON;

        }
    }

    public static class ShopSearchFilter {
        private String query = "";
        private String ownerName = null;
        private World world = null;
        private Location nearLocation = null;
        private double maxDistance = Double.MAX_VALUE;
        private double minRating = 0.0;
        private boolean hasItemsOnly = false;
        private ShopSortType sortType = ShopSortType.NEWEST;
        private int maxResults = 100;

        public ShopSearchFilter withQuery(String query) {
            this.query = query.toLowerCase();
            return this;
        }

        public ShopSearchFilter withOwner(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public ShopSearchFilter inWorld(World world) {
            this.world = world;
            return this;
        }

        public ShopSearchFilter nearLocation(Location location, double maxDistance) {
            this.nearLocation = location;
            this.maxDistance = maxDistance;
            return this;
        }

        public ShopSearchFilter withMinRating(double minRating) {
            this.minRating = minRating;
            return this;
        }

        public ShopSearchFilter withItemsOnly() {
            this.hasItemsOnly = true;
            return this;
        }

        public ShopSearchFilter sortBy(ShopSortType sortType) {
            this.sortType = sortType;
            return this;
        }

        public ShopSearchFilter withMaxResults(int max) {
            this.maxResults = max;
            return this;
        }

        public Predicate<PlayerShop> buildPredicate() {
            return shop -> {
                if (!shop.isActive()) {
                    return false;
                }
                if (!this.query.isEmpty()) {
                    String shopName = shop.getShopName().toLowerCase();
                    String shopDesc = shop.getDescription().toLowerCase();
                    String owner = shop.getOwnerName().toLowerCase();
                    SearchHelper.SmartMatcher matcher = new SearchHelper.SmartMatcher(this.query, 0.7);
                    boolean basicMatch = shopName.contains(this.query) || shopDesc.contains(this.query) || owner.contains(this.query);
                    boolean fuzzyMatch = matcher.matches(shopName) || matcher.matches(shopDesc) || matcher.matches(owner);
                    boolean itemMatch = shop.getItems().values().stream().anyMatch(item -> {
                        String itemName = ItemUtils.getItemName(item.getItem()).toLowerCase();
                        return itemName.contains(this.query) || matcher.matches(itemName) || SearchHelper.matchesTags(item.getItem().getType(), this.query);
                    });
                    if (!(basicMatch || fuzzyMatch || itemMatch)) {
                        return false;
                    }
                }
                if (this.ownerName != null && !shop.getOwnerName().equalsIgnoreCase(this.ownerName)) {
                    return false;
                }
                if (this.world != null && shop.getLocation() != null && !shop.getLocation().getWorld().equals((Object)this.world)) {
                    return false;
                }
                if (this.nearLocation != null && shop.getLocation() != null && (!shop.getLocation().getWorld().equals((Object)this.nearLocation.getWorld()) || shop.getLocation().distance(this.nearLocation) > this.maxDistance)) {
                    return false;
                }
                if (shop.getAverageRating() < this.minRating) {
                    return false;
                }
                return !this.hasItemsOnly || !shop.getItems().isEmpty();
            };
        }

        public Comparator<PlayerShop> buildComparator() {
            switch (this.sortType.ordinal()) {
                case 1: {
                    return Comparator.comparing(PlayerShop::getCreatedTime);
                }
                case 2: {
                    return Comparator.comparing(PlayerShop::getAverageRating).reversed();
                }
                case 3: {
                    return Comparator.comparing(PlayerShop::getAverageRating);
                }
                case 4: {
                    return Comparator.comparing(PlayerShop::getShopName);
                }
                case 5: {
                    return Comparator.comparing(PlayerShop::getShopName).reversed();
                }
                case 6: {
                    return Comparator.comparing(PlayerShop::getVisitCount).reversed();
                }
                case 7: {
                    if (this.nearLocation != null) {
                        return Comparator.comparing(shop -> shop.getLocation() != null ? shop.getLocation().distance(this.nearLocation) : Double.MAX_VALUE);
                    }
                    return Comparator.comparing(PlayerShop::getCreatedTime).reversed();
                }
            }
            return Comparator.comparing(PlayerShop::getCreatedTime).reversed();
        }

        public List<PlayerShop> search(List<PlayerShop> shops) {
            return shops.stream().filter(this.buildPredicate()).sorted(this.buildComparator()).limit(this.maxResults).collect(Collectors.toList());
        }

        public static enum ShopSortType {
            NEWEST,
            OLDEST,
            RATING_HIGH_LOW,
            RATING_LOW_HIGH,
            NAME_AZ,
            NAME_ZA,
            VISITS_HIGH_LOW,
            DISTANCE_NEAR_FAR;

        }
    }
}

