/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus;

import MPP.marketPlacePlus.commands.AdminCommand;
import MPP.marketPlacePlus.commands.MarketCommand;
import MPP.marketPlacePlus.commands.ShopsCommand;
import MPP.marketPlacePlus.config.ConfigManager;
import MPP.marketPlacePlus.database.DatabaseManager;
import MPP.marketPlacePlus.integrations.MarketPlacePlusExpansion;
import MPP.marketPlacePlus.listeners.GUIListener;
import MPP.marketPlacePlus.listeners.PlayerListener;
import MPP.marketPlacePlus.managers.AdminManager;
import MPP.marketPlacePlus.managers.AdvertisementManager;
import MPP.marketPlacePlus.managers.AuctionManager;
import MPP.marketPlacePlus.managers.CacheManager;
import MPP.marketPlacePlus.managers.ChatInputManager;
import MPP.marketPlacePlus.managers.CollectionManager;
import MPP.marketPlacePlus.managers.DiscordWebhookManager;
import MPP.marketPlacePlus.managers.EconomyManager;
import MPP.marketPlacePlus.managers.NotificationManager;
import MPP.marketPlacePlus.managers.PriceManager;
import MPP.marketPlacePlus.managers.ReportManager;
import MPP.marketPlacePlus.managers.ShopManager;
import MPP.marketPlacePlus.managers.TradeHistoryManager;
import MPP.marketPlacePlus.tasks.MarketplaceTask;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MarketPlacePlus
extends JavaPlugin {
    private static MarketPlacePlus instance;
    private ConfigManager configManager;
    private DatabaseManager databaseManager;
    private EconomyManager economyManager;
    private AuctionManager auctionManager;
    private ShopManager shopManager;
    private PriceManager priceManager;
    private TradeHistoryManager tradeHistoryManager;
    private ChatInputManager chatInputManager;
    private AdvertisementManager advertisementManager;
    private DiscordWebhookManager discordWebhookManager;
    private AdminManager adminManager;
    private ReportManager reportManager;
    private CollectionManager collectionManager;
    private NotificationManager notificationManager;
    private CacheManager cacheManager;
    private MarketplaceTask marketplaceTask;
    private GUIListener guiListener;
    private PlayerListener playerListener;
    private MarketPlacePlusExpansion placeholderExpansion;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.databaseManager = new DatabaseManager(this);
        try {
            this.databaseManager.initialize();
        }
        catch (RuntimeException e) {
            this.getLogger().severe("Failed to initialize database! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.economyManager = new EconomyManager(this);
        if (!this.economyManager.isAvailable()) {
            this.getLogger().severe("No economy system found! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.priceManager = new PriceManager(this);
        this.priceManager.loadPriceHistories();
        this.auctionManager = new AuctionManager(this);
        this.auctionManager.loadListings();
        this.shopManager = new ShopManager(this);
        this.shopManager.loadShops();
        this.tradeHistoryManager = new TradeHistoryManager(this);
        this.chatInputManager = new ChatInputManager((Plugin)this);
        this.advertisementManager = new AdvertisementManager(this);
        this.advertisementManager.loadAdvertisements();
        if (this.getConfig().getBoolean("advertisements.enabled", true)) {
            this.advertisementManager.startBroadcastTask();
        }
        this.discordWebhookManager = new DiscordWebhookManager(this);
        this.adminManager = new AdminManager(this);
        this.reportManager = new ReportManager(this);
        this.collectionManager = new CollectionManager(this);
        this.notificationManager = new NotificationManager(this);
        this.cacheManager = new CacheManager(this);
        this.cacheManager.warmupCache();
        if (this.getCommand("market") == null) {
            this.getLogger().severe("Market command not found in plugin.yml! Disabling plugin.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        MarketCommand marketCommand = new MarketCommand(this);
        this.getCommand("market").setExecutor((CommandExecutor)marketCommand);
        this.getCommand("market").setTabCompleter((TabCompleter)marketCommand);
        if (this.getCommand("shops") != null) {
            ShopsCommand shopsCommand = new ShopsCommand(this);
            this.getCommand("shops").setExecutor((CommandExecutor)shopsCommand);
            this.getCommand("shops").setTabCompleter((TabCompleter)shopsCommand);
        }
        if (this.getCommand("mpadmin") != null) {
            AdminCommand adminCommand = new AdminCommand(this);
            this.getCommand("mpadmin").setExecutor((CommandExecutor)adminCommand);
            this.getCommand("mpadmin").setTabCompleter((TabCompleter)adminCommand);
        }
        this.guiListener = new GUIListener();
        this.playerListener = new PlayerListener();
        this.getServer().getPluginManager().registerEvents((Listener)this.guiListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.chatInputManager, (Plugin)this);
        this.marketplaceTask = new MarketplaceTask(this);
        this.marketplaceTask.start();
        AntiScamUtils.scheduleUUIDCleanup((Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderExpansion = new MarketPlacePlusExpansion(this);
            this.placeholderExpansion.register();
            this.getLogger().info("PlaceholderAPI expansion registered!");
        }
        this.getLogger().info("MarketPlacePlus has been enabled!");
    }

    public void onDisable() {
        if (this.placeholderExpansion != null) {
            this.placeholderExpansion.unregister();
        }
        if (this.marketplaceTask != null) {
            this.marketplaceTask.cancel();
        }
        if (this.auctionManager != null) {
            this.auctionManager.saveListings();
        }
        if (this.shopManager != null) {
            this.shopManager.saveShops();
        }
        if (this.priceManager != null) {
            this.priceManager.savePriceHistories();
        }
        if (this.collectionManager != null) {
            this.collectionManager.saveAll();
        }
        if (this.notificationManager != null) {
            this.notificationManager.cleanup();
        }
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        AntiScamUtils.clearUUIDRegistry();
        instance = null;
        this.getLogger().info("MarketPlacePlus has been disabled!");
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public AuctionManager getAuctionManager() {
        return this.auctionManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public PriceManager getPriceManager() {
        return this.priceManager;
    }

    public TradeHistoryManager getTradeHistoryManager() {
        return this.tradeHistoryManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ChatInputManager getChatInputManager() {
        return this.chatInputManager;
    }

    public AdvertisementManager getAdvertisementManager() {
        return this.advertisementManager;
    }

    public DiscordWebhookManager getDiscordWebhookManager() {
        return this.discordWebhookManager;
    }

    public AdminManager getAdminManager() {
        return this.adminManager;
    }

    public ReportManager getReportManager() {
        return this.reportManager;
    }

    public CollectionManager getCollectionManager() {
        return this.collectionManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public static MarketPlacePlus getInstance() {
        return instance;
    }

    public void reload() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        if (this.marketplaceTask != null) {
            this.marketplaceTask.cancel();
        }
        this.priceManager.loadPriceHistories();
        this.auctionManager.loadListings();
        this.shopManager.loadShops();
        this.reportManager.reload();
        this.marketplaceTask = new MarketplaceTask(this);
        this.marketplaceTask.start();
        this.getLogger().info("MarketPlacePlus has been reloaded!");
    }
}

