/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.data;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class DataSerializer {
    public static Map<String, Object> serializeLocation(Location location) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("world", location.getWorld().getName());
        data.put("x", location.getX());
        data.put("y", location.getY());
        data.put("z", location.getZ());
        data.put("yaw", Float.valueOf(location.getYaw()));
        data.put("pitch", Float.valueOf(location.getPitch()));
        return data;
    }

    public static Location deserializeLocation(Map<String, Object> data) {
        World world = Bukkit.getWorld((String)((String)data.get("world")));
        if (world == null) {
            return null;
        }
        return new Location(world, ((Double)data.get("x")).doubleValue(), ((Double)data.get("y")).doubleValue(), ((Double)data.get("z")).doubleValue(), ((Number)data.get("yaw")).floatValue(), ((Number)data.get("pitch")).floatValue());
    }

    public static String locationToString(Location location) {
        return location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getYaw() + "," + location.getPitch();
    }

    public static Location stringToLocation(String str) {
        String[] parts = str.split(",");
        if (parts.length != 6) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        try {
            return new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]), Float.parseFloat(parts[4]), Float.parseFloat(parts[5]));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String sanitizeString(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[^a-zA-Z0-9\\s_-]", "");
    }

    public static boolean isValidPrice(double price) {
        return price > 0.0 && price < Double.MAX_VALUE && !Double.isNaN(price) && !Double.isInfinite(price);
    }
}

