/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.MarketItem;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AuctionBidGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final MarketItem auction;
    private double bidAmount;

    public AuctionBidGUI(Player player, MarketPlacePlus plugin, MarketItem auction) {
        super(player, "Bid on Auction", 5);
        this.plugin = plugin;
        this.auction = auction;
        this.bidAmount = auction.getMinimumBid();
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.PURPLE_STAINED_GLASS_PANE);
        ItemStack displayItem = this.auction.getItemStack().clone();
        ArrayList<Object> lore = new ArrayList<Object>();
        if (displayItem.hasItemMeta() && displayItem.getItemMeta().hasLore()) {
            lore.addAll(displayItem.getItemMeta().getLore());
        }
        lore.add("");
        lore.add("\u00a77Seller: \u00a7e" + this.auction.getSellerName());
        lore.add("\u00a77Current Bid: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.auction.getCurrentBid()));
        lore.add("\u00a77Bidder: \u00a7e" + (this.auction.getHighestBidderName() != null ? this.auction.getHighestBidderName() : "None"));
        lore.add("\u00a77Total Bids: \u00a7b" + this.auction.getTotalBids());
        Duration timeLeft = Duration.between(LocalDateTime.now(), this.auction.getExpiryTime());
        long hours = timeLeft.toHours();
        long minutes = timeLeft.toMinutes() % 60L;
        lore.add("\u00a77Time Left: \u00a7c" + hours + "h " + minutes + "m");
        ItemStack itemWithLore = displayItem.clone();
        ItemMeta meta = itemWithLore.getItemMeta();
        if (meta != null) {
            meta.setLore(lore);
            itemWithLore.setItemMeta(meta);
        }
        this.setItem(13, itemWithLore, null);
        this.updateBidButtons();
        ItemStack infoItem = this.createItem(Material.BOOK, "\u00a76Auction Information", "\u00a77Starting Bid: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.auction.getStartingBid()), "\u00a77Bid Increment: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.auction.getBidIncrement()), "\u00a77Your Balance: \u00a7a" + this.plugin.getEconomyManager().formatMoney(this.plugin.getEconomyManager().getBalance(this.player)), "", "\u00a77Bidding protects your money", "\u00a77until someone outbids you");
        this.setItem(30, infoItem, null);
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aPlace Bid", "\u00a77Amount: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.bidAmount), "", this.auction.getHighestBidderId() != null && this.auction.getHighestBidderId().equals(this.player.getUniqueId()) ? "\u00a7eYou are the highest bidder!" : "\u00a7eClick to place bid");
        this.setItem(32, confirmButton, e -> {
            if (!this.player.hasPermission("marketplaceplus.auction.bid")) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cYou don't have permission to place bids!");
                return;
            }
            if (this.plugin.getAuctionManager().placeBid(this.player, this.auction.getId(), this.bidAmount)) {
                this.playClickSound();
                this.refresh();
            }
        });
        ItemStack cancelButton = this.createItem(Material.BARRIER, "\u00a7cBack", new String[0]);
        this.setItem(33, cancelButton, e -> {
            this.playClickSound();
            new AuctionHouseGUI(this.player, this.plugin).open();
        });
    }

    private void updateBidButtons() {
        double increment = this.auction.getBidIncrement();
        ItemStack decrease10 = this.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7c-" + this.plugin.getEconomyManager().formatMoney(increment * 10.0), new String[0]);
        this.setItem(19, decrease10, e -> {
            if (this.bidAmount - increment * 10.0 >= this.auction.getMinimumBid()) {
                this.playClickSound();
                this.bidAmount -= increment * 10.0;
                this.refresh();
            }
        });
        ItemStack decrease1 = this.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7c-" + this.plugin.getEconomyManager().formatMoney(increment), new String[0]);
        this.setItem(20, decrease1, e -> {
            if (this.bidAmount - increment >= this.auction.getMinimumBid()) {
                this.playClickSound();
                this.bidAmount -= increment;
                this.refresh();
            }
        });
        ItemStack bidDisplay = this.createItem(Material.GOLD_INGOT, "\u00a76Your Bid", "\u00a77Amount: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.bidAmount), "\u00a77Minimum: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.auction.getMinimumBid()), "", "\u00a7eClick to enter custom amount");
        this.setItem(22, bidDisplay, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter bid amount (minimum: " + this.plugin.getEconomyManager().formatMoney(this.auction.getMinimumBid()) + "):");
            this.plugin.getChatInputManager().waitForInput(this.player, input -> {
                try {
                    double amount = Double.parseDouble(input);
                    if (amount >= this.auction.getMinimumBid()) {
                        this.bidAmount = amount;
                        new AuctionBidGUI(this.player, this.plugin, this.auction).open();
                    } else {
                        this.player.sendMessage("\u00a7cBid must be at least " + this.plugin.getEconomyManager().formatMoney(this.auction.getMinimumBid()) + "!");
                    }
                }
                catch (NumberFormatException ex) {
                    this.player.sendMessage("\u00a7cInvalid amount!");
                }
            });
        });
        ItemStack increase1 = this.createItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7a+" + this.plugin.getEconomyManager().formatMoney(increment), new String[0]);
        this.setItem(24, increase1, e -> {
            if (this.plugin.getEconomyManager().hasBalance(this.player, this.bidAmount + increment)) {
                this.playClickSound();
                this.bidAmount += increment;
                this.refresh();
            }
        });
        ItemStack increase10 = this.createItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7a+" + this.plugin.getEconomyManager().formatMoney(increment * 10.0), new String[0]);
        this.setItem(25, increase10, e -> {
            if (this.plugin.getEconomyManager().hasBalance(this.player, this.bidAmount + increment * 10.0)) {
                this.playClickSound();
                this.bidAmount += increment * 10.0;
                this.refresh();
            }
        });
    }
}

