/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.CollectableItem;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CollectionGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final List<CollectableItem> collectableItems;
    private int currentPage = 0;
    private static final int ITEMS_PER_PAGE = 28;
    private final AtomicBoolean isCollecting = new AtomicBoolean(false);

    public CollectionGUI(MarketPlacePlus plugin, Player player) {
        super(player, "\u00a76\u00a7lCollection Box", 6);
        this.plugin = plugin;
        this.collectableItems = plugin.getCollectionManager().getPlayerItems(player.getUniqueId());
    }

    @Override
    public void setupGUI() {
        int i;
        this.inventory.clear();
        ItemStack border = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, border);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, border);
        }
        this.inventory.setItem(9, border);
        this.inventory.setItem(17, border);
        this.inventory.setItem(18, border);
        this.inventory.setItem(26, border);
        this.inventory.setItem(27, border);
        this.inventory.setItem(35, border);
        this.inventory.setItem(36, border);
        this.inventory.setItem(44, border);
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.collectableItems.size());
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i2 = 0; i2 < 28 && startIndex + i2 < this.collectableItems.size(); ++i2) {
            CollectableItem collectableItem = this.collectableItems.get(startIndex + i2);
            ItemStack displayItem = collectableItem.getItemStack().clone();
            ItemMeta meta = displayItem.getItemMeta();
            if (meta != null) {
                List lore = meta.getLore() != null ? meta.getLore() : new ArrayList();
                lore.add("");
                lore.add("\u00a77\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
                switch (collectableItem.getType()) {
                    case EXPIRED_LISTING: {
                        lore.add("\u00a7eExpired Listing");
                        lore.add("\u00a77Listed for: \u00a76$" + String.format("%.2f", collectableItem.getPrice()));
                        break;
                    }
                    case SOLD_ITEM: {
                        lore.add("\u00a7aSold Item - Money Collected");
                        lore.add("\u00a77Sold for: \u00a76$" + String.format("%.2f", collectableItem.getPrice()));
                        break;
                    }
                    case AUCTION_WON: {
                        lore.add("\u00a7aAuction Won");
                        lore.add("\u00a77Won for: \u00a76$" + String.format("%.2f", collectableItem.getPrice()));
                        break;
                    }
                    case OUTBID_RETURN: {
                        lore.add("\u00a7cOutbid - Item Returned");
                        lore.add("\u00a77Your bid: \u00a76$" + String.format("%.2f", collectableItem.getPrice()));
                        break;
                    }
                    case CANCELLED_LISTING: {
                        lore.add("\u00a7cCancelled Listing");
                        break;
                    }
                    case SHOP_RETURN: {
                        lore.add("\u00a7eShop Item Return");
                        lore.add("\u00a77From shop removal");
                    }
                }
                lore.add("\u00a77Added: \u00a7f" + collectableItem.getFormattedTime());
                lore.add("");
                lore.add("\u00a7a\u27a4 Click to collect");
                lore.add("\u00a7c\u27a4 Shift-click to collect all");
                meta.setLore(lore);
                displayItem.setItemMeta(meta);
            }
            this.inventory.setItem(slots[i2], displayItem);
        }
        if (this.currentPage > 0) {
            this.inventory.setItem(48, this.createItem(Material.ARROW, "\u00a7aPrevious Page", new String[0]));
        }
        if (endIndex < this.collectableItems.size()) {
            this.inventory.setItem(50, this.createItem(Material.ARROW, "\u00a7aNext Page", new String[0]));
        }
        ItemStack info = this.createItem(Material.BOOK, "\u00a76\u00a7lCollection Info", "\u00a77Items: \u00a7f" + this.collectableItems.size(), "\u00a77Page: \u00a7f" + (this.currentPage + 1) + "/" + this.getTotalPages(), "", "\u00a7eItems expire after 30 days!", "\u00a7cMake sure to collect them!");
        this.inventory.setItem(4, info);
        ItemStack collectAll = this.createItem(Material.HOPPER, "\u00a7a\u00a7lCollect All", "\u00a77Click to collect all items", "\u00a77that fit in your inventory", "", "\u00a7eWill collect up to " + this.getAvailableSlots() + " items");
        this.inventory.setItem(49, collectAll);
        ItemStack back = this.createItem(Material.BARRIER, "\u00a7cBack to Market", new String[0]);
        this.inventory.setItem(53, back);
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        int slot = event.getSlot();
        boolean isShiftClick = event.isShiftClick();
        if (slot >= 10 && slot <= 43) {
            int actualIndex;
            int index = this.getItemIndex(slot);
            if (index >= 0 && index < 28 && (actualIndex = this.currentPage * 28 + index) < this.collectableItems.size()) {
                if (isShiftClick) {
                    this.collectAllItems();
                } else {
                    this.collectItem(actualIndex);
                }
            }
        } else if (slot == 48 && this.currentPage > 0) {
            --this.currentPage;
            this.setupGUI();
        } else if (slot == 50 && (this.currentPage + 1) * 28 < this.collectableItems.size()) {
            ++this.currentPage;
            this.setupGUI();
        } else if (slot == 49) {
            this.collectAllItems();
        } else if (slot == 53) {
            new AuctionHouseGUI(this.player, this.plugin).open();
        }
    }

    private void collectItem(int index) {
        List<CollectableItem> currentItems = this.plugin.getCollectionManager().getPlayerItems(this.player.getUniqueId());
        if (index >= currentItems.size()) {
            this.player.sendMessage("\u00a7cThis item no longer exists!");
            this.refreshItems();
            this.setupGUI();
            return;
        }
        CollectableItem item = currentItems.get(index);
        if (this.player.getInventory().firstEmpty() == -1) {
            this.player.sendMessage("\u00a7cYour inventory is full!");
            return;
        }
        if (!this.plugin.getCollectionManager().removeItem(this.player.getUniqueId(), item.getId())) {
            this.player.sendMessage("\u00a7cFailed to collect item! Please try again.");
            this.refreshItems();
            this.setupGUI();
            return;
        }
        ItemStack itemToGive = item.getItemStack().clone();
        AntiScamUtils.clearItemUUID(itemToGive, (Plugin)this.plugin);
        this.player.getInventory().addItem(new ItemStack[]{itemToGive});
        this.player.sendMessage("\u00a7aCollected: \u00a7f" + ItemUtils.getItemName(itemToGive));
        this.refreshItems();
        if (this.collectableItems.isEmpty() && this.currentPage > 0) {
            --this.currentPage;
        }
        this.setupGUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectAllItems() {
        if (!this.isCollecting.compareAndSet(false, true)) {
            this.player.sendMessage("\u00a7cPlease wait, already processing collection...");
            return;
        }
        try {
            this.refreshItems();
            int collected = 0;
            int maxCollect = this.getAvailableSlots();
            int failed = 0;
            ArrayList<CollectableItem> currentItems = new ArrayList<CollectableItem>(this.plugin.getCollectionManager().getPlayerItems(this.player.getUniqueId()));
            for (CollectableItem item : currentItems) {
                if (collected >= maxCollect || this.player.getInventory().firstEmpty() == -1) break;
                if (this.plugin.getCollectionManager().removeItem(this.player.getUniqueId(), item.getId())) {
                    ItemStack itemToGive = item.getItemStack().clone();
                    AntiScamUtils.clearItemUUID(itemToGive, (Plugin)this.plugin);
                    this.player.getInventory().addItem(new ItemStack[]{itemToGive});
                    ++collected;
                    continue;
                }
                ++failed;
            }
            this.refreshItems();
            if (collected > 0) {
                this.player.sendMessage("\u00a7aCollected \u00a7f" + collected + " \u00a7aitems!");
                if (failed > 0) {
                    this.player.sendMessage("\u00a7cFailed to collect " + failed + " items. Please try again.");
                }
                if (this.collectableItems.isEmpty() && this.currentPage > 0) {
                    this.currentPage = 0;
                }
                this.setupGUI();
            } else if (failed > 0) {
                this.player.sendMessage("\u00a7cFailed to collect items! Please try again.");
            } else {
                this.player.sendMessage("\u00a7cNo items could be collected! Inventory might be full.");
            }
        }
        finally {
            this.isCollecting.set(false);
        }
    }

    private int getItemIndex(int slot) {
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i = 0; i < slots.length; ++i) {
            if (slots[i] != slot) continue;
            return i;
        }
        return -1;
    }

    private int getAvailableSlots() {
        int count = 0;
        for (ItemStack item : this.player.getInventory().getStorageContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++count;
        }
        return count;
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.collectableItems.size() / 28.0);
    }

    private void refreshItems() {
        this.collectableItems.clear();
        this.collectableItems.addAll(this.plugin.getCollectionManager().getPlayerItems(this.player.getUniqueId()));
    }
}

