/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.PlayerShopGUI;
import MPP.marketPlacePlus.gui.ShopBrowserGUI;
import MPP.marketPlacePlus.gui.ShopSettingsGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MyShopsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy");

    public MyShopsGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76My Shops", 4);
        this.plugin = plugin;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.BROWN_STAINED_GLASS_PANE);
        List<PlayerShop> myShops = this.plugin.getShopManager().getPlayerShops(this.player.getUniqueId());
        int maxShops = this.plugin.getConfig().getInt("player-shops.max-shops-per-player", 1);
        if (myShops.isEmpty()) {
            ItemStack noShops = this.createItem(Material.BARRIER, "\u00a7cNo Shops", "\u00a77You don't have any shops yet!", "", "\u00a7eClick the emerald to create one!");
            this.setItem(13, noShops, null);
        } else {
            int slot = 10;
            for (PlayerShop shop : myShops) {
                if (slot > 16) break;
                ItemStack shopItem = this.createShopItem(shop);
                this.setItem(slot, shopItem, e -> {
                    if (e.isLeftClick()) {
                        this.playClickSound();
                        new PlayerShopGUI(this.player, this.plugin, shop).open();
                    } else if (e.isRightClick()) {
                        this.playClickSound();
                        new ShopSettingsGUI(this.player, this.plugin, shop).open();
                    }
                });
                slot += 2;
            }
        }
        if (myShops.size() < maxShops) {
            double creationCost = this.plugin.getConfig().getDouble("player-shops.shop-creation-cost", 1000.0);
            ItemStack createShop = this.createItem(Material.EMERALD, "\u00a7aCreate New Shop", "\u00a77Cost: \u00a76" + this.plugin.getEconomyManager().formatMoney(creationCost), "", "\u00a77You can create \u00a7e" + (maxShops - myShops.size()) + " \u00a77more shop(s)", "", "\u00a7eClick to create!");
            this.setItem(22, createShop, e -> {
                this.playClickSound();
                this.player.closeInventory();
                this.player.sendMessage("\u00a7ePlease enter a name for your shop:");
                this.plugin.getChatInputManager().waitForInput(this.player, shopName -> {
                    if (shopName.length() > 32) {
                        this.player.sendMessage("\u00a7cShop name too long! Max 32 characters.");
                        return;
                    }
                    this.player.sendMessage("\u00a7ePlease enter a short description (max 128 chars, or 'none' to skip):");
                    this.plugin.getChatInputManager().waitForInput(this.player, description -> {
                        if (description.equalsIgnoreCase("none")) {
                            description = "";
                        } else if (description.length() > 128) {
                            this.player.sendMessage("\u00a7cDescription too long! Max 128 characters.");
                            return;
                        }
                        if (this.plugin.getShopManager().createShop(this.player, (String)shopName, (String)description)) {
                            this.player.sendMessage("\u00a7aShop created successfully!");
                            new MyShopsGUI(this.player, this.plugin).open();
                        } else {
                            this.player.sendMessage("\u00a7cFailed to create shop! Make sure you have enough money.");
                        }
                    });
                });
            });
        }
        ItemStack info = this.createItem(Material.BOOK, "\u00a76Shop Information", "\u00a77Shops owned: \u00a7e" + myShops.size() + "/" + maxShops, "", "\u00a7eLeft Click \u00a77to manage shop", "\u00a7eRight Click \u00a77for shop settings");
        this.setItem(30, info, null);
        ItemStack back = this.createItem(Material.ARROW, "\u00a7cBack", "\u00a77Return to shop browser");
        this.setItem(31, back, e -> {
            this.playClickSound();
            new ShopBrowserGUI(this.player, this.plugin).open();
        });
    }

    private ItemStack createShopItem(PlayerShop shop) {
        Material material = shop.isActive() ? Material.LIME_STAINED_GLASS : Material.RED_STAINED_GLASS;
        String status = shop.isActive() ? "\u00a7aActive" : "\u00a7cInactive";
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Status: " + status);
        lore.add("\u00a77Items: \u00a7e" + shop.getItems().size());
        lore.add("\u00a77Created: \u00a7f" + shop.getCreatedTime().format(DATE_FORMAT));
        lore.add("\u00a77Visits: \u00a7f" + shop.getVisitCount());
        lore.add("\u00a77Total Earnings: \u00a76" + this.plugin.getEconomyManager().formatMoney(shop.getTotalEarnings()));
        lore.add("");
        if (!shop.getDescription().isEmpty()) {
            lore.add("\u00a77Description: \u00a7f" + shop.getDescription());
            lore.add("");
        }
        lore.add("\u00a7eLeft Click \u00a77to manage items");
        lore.add("\u00a7eRight Click \u00a77for settings");
        return this.createItem(material, "\u00a76" + shop.getShopName(), lore.toArray(new String[0]));
    }
}

