/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RateShopGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;

    public RateShopGUI(Player player, MarketPlacePlus plugin, PlayerShop shop) {
        super(player, "Rate " + shop.getShopName(), 3);
        this.plugin = plugin;
        this.shop = shop;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.BLACK_STAINED_GLASS_PANE);
        Integer currentRating = this.plugin.getDatabaseManager().getPlayerRating(this.shop.getId(), this.player.getUniqueId());
        for (int i = 1; i <= 5; ++i) {
            Material starMaterial = currentRating != null && i <= currentRating ? Material.GOLD_BLOCK : Material.IRON_BLOCK;
            String starDisplay = "\u2605".repeat(i) + "\u2606".repeat(5 - i);
            ItemStack star = this.createItem(starMaterial, "\u00a76" + starDisplay + " \u00a77(" + i + "/5)", "\u00a77Click to rate this shop", "", currentRating != null && i == currentRating ? "\u00a7aCurrent rating" : "\u00a7eClick to select");
            int rating = i;
            this.setItem(10 + i, star, e -> {
                if (!this.player.hasPermission("marketplaceplus.shop.rate")) {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cYou don't have permission to rate shops!");
                    return;
                }
                this.playClickSound();
                this.plugin.getDatabaseManager().saveShopRating(this.shop.getId(), this.player.getUniqueId(), rating);
                this.player.sendMessage("\u00a7aYou rated \u00a7e" + this.shop.getShopName() + " \u00a7a" + rating + " stars!");
                if (currentRating == null) {
                    this.plugin.getEconomyManager().depositPlayer(this.player, 100.0);
                    this.player.sendMessage("\u00a7aYou earned \u00a76$100 \u00a7afor rating a shop!");
                }
                this.player.closeInventory();
            });
        }
        ItemStack info = this.createItem(Material.BOOK, "\u00a76Shop Rating Info", "\u00a77Average Rating: \u00a76" + String.format("%.1f", this.shop.getAverageRating()) + " stars", "\u00a77Total Ratings: \u00a7b" + this.shop.getTotalRatings(), "", "\u00a77Rate shops to help other", "\u00a77players find quality stores!");
        this.setItem(22, info, null);
    }
}

