/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.PlayerShopGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class RestockItemGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;
    private final int slot;

    public RestockItemGUI(Player player, MarketPlacePlus plugin, PlayerShop shop, int slot) {
        super(player, "\u00a76Restock Item", 3);
        this.plugin = plugin;
        this.shop = shop;
        this.slot = slot;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        PlayerShop.ShopItem shopItem = this.shop.getItems().get(this.slot);
        if (shopItem == null) {
            this.player.closeInventory();
            return;
        }
        this.setItem(13, shopItem.getItem(), null);
        ItemStack info = this.createItem(Material.PAPER, "\u00a76Current Stock: \u00a7e" + shopItem.getStock(), "\u00a77Click items in your inventory", "\u00a77to add them to stock");
        this.setItem(4, info, null);
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7aBack to Shop", new String[0]);
        this.setItem(22, backButton, e -> {
            this.playClickSound();
            new PlayerShopGUI(this.player, this.plugin, this.shop).open();
        });
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == this.player.getInventory()) {
            ItemStack clicked = event.getCurrentItem();
            if (clicked != null && clicked.getType() != Material.AIR) {
                PlayerShop.ShopItem shopItem = this.shop.getItems().get(this.slot);
                if (shopItem != null && clicked.isSimilar(shopItem.getItem())) {
                    int amount = event.isShiftClick() ? clicked.getAmount() : 1;
                    ItemStack toRemove = clicked.clone();
                    toRemove.setAmount(amount);
                    this.player.getInventory().removeItem(new ItemStack[]{toRemove});
                    this.shop.restockItem(this.slot, amount);
                    this.plugin.getShopManager().saveShop(this.shop);
                    this.playSuccessSound();
                    this.player.sendMessage("\u00a7aAdded " + amount + " items to stock!");
                    this.refresh();
                } else {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cThis item doesn't match the shop item!");
                }
            }
            event.setCancelled(true);
        } else {
            super.handleClick(event);
        }
    }
}

