/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.AuctionHouseGUI;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.CreateAuctionGUI;
import MPP.marketPlacePlus.gui.PriceSelectorGUI;
import MPP.marketPlacePlus.utils.AntiScamUtils;
import MPP.marketPlacePlus.utils.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SellItemGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private ItemStack itemToSell;
    private double price = 0.0;
    private boolean isTransitioning = false;

    public SellItemGUI(Player player, MarketPlacePlus plugin) {
        super(player, "\u00a76Sell Item", 3);
        this.plugin = plugin;
    }

    public SellItemGUI(Player player, MarketPlacePlus plugin, ItemStack item, double price) {
        super(player, "\u00a76Sell Item", 3);
        this.plugin = plugin;
        this.itemToSell = item;
        this.price = price;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.ORANGE_STAINED_GLASS_PANE);
        this.updateDisplay();
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == this.player.getInventory() && this.itemToSell == null && !this.isTransitioning) {
            ItemStack clicked = event.getCurrentItem();
            if (clicked != null && clicked.getType() != Material.AIR) {
                if (this.plugin.getConfig().getBoolean("protection.prevent-renamed-scams") && AntiScamUtils.isItemSuspicious(clicked, (Plugin)this.plugin)) {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cThis item appears to be suspicious and cannot be sold!");
                    event.setCancelled(true);
                    return;
                }
                this.itemToSell = clicked.clone();
                this.player.getInventory().setItem(event.getSlot(), null);
                this.updateDisplay();
                this.playClickSound();
            }
            event.setCancelled(true);
        } else {
            super.handleClick(event);
        }
    }

    private void updateDisplay() {
        this.inventory.clear();
        this.clickHandlers.clear();
        this.fillBorder(Material.ORANGE_STAINED_GLASS_PANE);
        if (this.itemToSell == null) {
            ItemStack placeItem = this.createItem(Material.CHEST, "\u00a7aSelect Item to Sell", "\u00a77Click an item in your inventory", "\u00a77to sell it on the auction house");
            this.setItem(13, placeItem, null);
        } else {
            ItemStack display = this.itemToSell.clone();
            this.setItem(13, display, e -> {
                if (this.itemToSell != null && !this.isTransitioning) {
                    this.player.getInventory().addItem(new ItemStack[]{this.itemToSell});
                    this.itemToSell = null;
                    this.updateDisplay();
                    this.playClickSound();
                }
            });
            ItemStack priceButton = this.createItem(Material.GOLD_INGOT, "\u00a7eSet Price", "\u00a77Current: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.price), "\u00a77Click to set the price");
            this.setItem(11, priceButton, e -> {
                if (this.itemToSell == null || this.isTransitioning) {
                    return;
                }
                this.playClickSound();
                this.isTransitioning = true;
                ItemStack savedItem = this.itemToSell.clone();
                double savedPrice = this.price;
                this.player.closeInventory();
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new PriceSelectorGUI(this.player, this.plugin, savedItem, newPrice -> this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new SellItemGUI(this.player, this.plugin, savedItem, (double)newPrice).open(), 1L)).open(), 1L);
            });
            ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aConfirm Listing", "\u00a77Item: \u00a7f" + ItemUtils.getItemName(this.itemToSell), "\u00a77Amount: \u00a7f" + this.itemToSell.getAmount(), "\u00a77Price: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.price), "\u00a77Fee: \u00a7c" + this.plugin.getEconomyManager().formatMoney(this.price * this.plugin.getConfig().getDouble("auction-house.listing-fee-percentage") / 100.0), "", "\u00a7aClick to list item");
            this.setItem(14, confirmButton, e -> {
                if (this.price <= 0.0) {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cPlease set a valid price!");
                    return;
                }
                if (this.itemToSell == null || this.isTransitioning) {
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cItem not found!");
                    return;
                }
                this.isTransitioning = true;
                if (this.plugin.getAuctionManager().createListing(this.player, this.itemToSell.clone(), this.price)) {
                    this.playSuccessSound();
                    this.player.sendMessage("\u00a7aItem listed successfully for " + this.plugin.getEconomyManager().formatMoney(this.price) + "!");
                    this.itemToSell = null;
                    this.player.closeInventory();
                    this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new AuctionHouseGUI(this.player, this.plugin).open(), 2L);
                } else {
                    this.isTransitioning = false;
                    this.playErrorSound();
                    this.player.sendMessage("\u00a7cFailed to list item! Check your balance and listing limit.");
                }
            });
            ItemStack auctionButton = this.createItem(Material.GOLD_BLOCK, "\u00a76Create Auction", "\u00a77Start an auction for this item", "\u00a77Players can bid on it!", "", "\u00a7eClick to set up auction");
            this.setItem(16, auctionButton, e -> {
                if (this.itemToSell == null || this.isTransitioning) {
                    return;
                }
                this.playClickSound();
                this.isTransitioning = true;
                this.player.closeInventory();
                new CreateAuctionGUI(this.player, this.plugin, this.itemToSell).open();
            });
        }
        ItemStack cancelButton = this.createItem(Material.BARRIER, "\u00a7cCancel", "\u00a77Return to auction house");
        this.setItem(22, cancelButton, e -> {
            this.playClickSound();
            this.isTransitioning = true;
            if (this.itemToSell != null) {
                this.player.getInventory().addItem(new ItemStack[]{this.itemToSell});
                this.itemToSell = null;
            }
            this.player.closeInventory();
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new AuctionHouseGUI(this.player, this.plugin).open(), 1L);
        });
    }

    @Override
    public void handleClose(InventoryCloseEvent event) {
        super.handleClose(event);
        if (!this.isTransitioning && this.itemToSell != null) {
            this.player.getInventory().addItem(new ItemStack[]{this.itemToSell});
            this.itemToSell = null;
        }
    }
}

