/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.PlayerShopGUI;
import MPP.marketPlacePlus.gui.SellItemGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SetPriceGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private double currentPrice = 0.0;
    private final Consumer<Double> onComplete;
    private final PlayerShop shop;
    private final int slot;
    private final ItemStack item;
    private boolean isConfirmed = false;

    public SetPriceGUI(Player player, MarketPlacePlus plugin, Consumer<Double> onComplete) {
        super(player, "\u00a76Set Price", 3);
        this.plugin = plugin;
        this.onComplete = onComplete;
        this.shop = null;
        this.slot = -1;
        this.item = null;
    }

    public SetPriceGUI(Player player, MarketPlacePlus plugin, PlayerShop shop, int slot) {
        super(player, "\u00a76Set Price", 3);
        this.plugin = plugin;
        this.shop = shop;
        this.slot = slot;
        this.item = null;
        this.onComplete = null;
        PlayerShop.ShopItem shopItem = shop.getItems().get(slot);
        if (shopItem != null) {
            this.currentPrice = shopItem.getPrice();
        }
    }

    public SetPriceGUI(Player player, MarketPlacePlus plugin, PlayerShop shop, int slot, ItemStack item) {
        super(player, "\u00a76Set Price", 3);
        this.plugin = plugin;
        this.shop = shop;
        this.slot = slot;
        this.item = item;
        this.onComplete = null;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.YELLOW_STAINED_GLASS_PANE);
        this.updateDisplay();
        this.createNumberButtons();
        ItemStack cancelButton = this.createItem(Material.BARRIER, "\u00a7cCancel", "\u00a77Go back without setting price");
        this.setItem(18, cancelButton, e -> {
            this.playClickSound();
            if (this.item != null) {
                this.player.getInventory().addItem(new ItemStack[]{this.item});
            }
            this.isConfirmed = true;
            if (this.onComplete != null) {
                this.player.closeInventory();
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new SellItemGUI(this.player, this.plugin).open(), 1L);
            } else if (this.shop != null) {
                this.player.closeInventory();
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> new PlayerShopGUI(this.player, this.plugin, this.shop).open(), 1L);
            }
        });
    }

    @Override
    public void handleClose(InventoryCloseEvent event) {
        super.handleClose(event);
        if (!this.isConfirmed && this.item != null) {
            this.player.getInventory().addItem(new ItemStack[]{this.item});
        }
    }

    private void createNumberButtons() {
        double[] increments = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0};
        int[] slots = new int[]{10, 11, 12, 14, 15};
        for (int i = 0; i < increments.length; ++i) {
            double increment = increments[i];
            ItemStack addButton = this.createItem(Material.LIME_DYE, "\u00a7a+" + increment, "\u00a77Add \u00a76" + this.plugin.getEconomyManager().formatMoney(increment));
            this.setItem(slots[i], addButton, e -> {
                this.playClickSound();
                this.currentPrice += increment;
                this.refresh();
            });
            ItemStack subtractButton = this.createItem(Material.RED_DYE, "\u00a7c-" + increment, "\u00a77Subtract \u00a76" + this.plugin.getEconomyManager().formatMoney(increment));
            this.setItem(slots[i] + 9, subtractButton, e -> {
                this.playClickSound();
                this.currentPrice = Math.max(0.0, this.currentPrice - increment);
                this.refresh();
            });
        }
        ItemStack resetButton = this.createItem(Material.BARRIER, "\u00a7cReset", "\u00a77Reset price to 0");
        this.setItem(16, resetButton, e -> {
            this.playClickSound();
            this.currentPrice = 0.0;
            this.refresh();
        });
    }

    private void updateDisplay() {
        PlayerShop.ShopItem shopItem;
        ItemStack display = this.createItem(Material.GOLD_BLOCK, "\u00a76Current Price", "\u00a7e" + this.plugin.getEconomyManager().formatMoney(this.currentPrice));
        this.setItem(4, display, null);
        if (this.item != null) {
            ItemStack itemDisplay = this.item.clone();
            this.setItem(13, itemDisplay, null);
        } else if (this.shop != null && this.slot >= 0 && (shopItem = this.shop.getItems().get(this.slot)) != null) {
            ItemStack itemDisplay = shopItem.getItem().clone();
            this.setItem(13, itemDisplay, null);
        }
        ItemStack confirmButton = this.createItem(Material.EMERALD_BLOCK, "\u00a7aConfirm", "\u00a77Set price to \u00a76" + this.plugin.getEconomyManager().formatMoney(this.currentPrice));
        this.setItem(22, confirmButton, e -> {
            double maxPrice;
            if (this.currentPrice <= 0.0) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cPrice must be greater than 0!");
                return;
            }
            double minPrice = this.shop != null ? this.plugin.getConfig().getDouble("player-shops.min-price", 1.0) : this.plugin.getConfig().getDouble("auction-house.min-price", 1.0);
            double d = maxPrice = this.shop != null ? this.plugin.getConfig().getDouble("player-shops.max-price", 1000000.0) : this.plugin.getConfig().getDouble("auction-house.max-price", 1000000.0);
            if (this.currentPrice < minPrice || this.currentPrice > maxPrice) {
                this.playErrorSound();
                this.player.sendMessage("\u00a7cPrice must be between " + this.plugin.getEconomyManager().formatMoney(minPrice) + " and " + this.plugin.getEconomyManager().formatMoney(maxPrice));
                return;
            }
            this.playSuccessSound();
            if (this.onComplete != null) {
                this.isConfirmed = true;
                this.onComplete.accept(this.currentPrice);
                this.player.closeInventory();
            } else if (this.shop != null) {
                if (this.item != null) {
                    this.shop.addItem(this.slot, this.item, this.currentPrice, this.item.getAmount());
                } else {
                    PlayerShop.ShopItem shopItem = this.shop.getItems().get(this.slot);
                    if (shopItem != null) {
                        shopItem.setPrice(this.currentPrice);
                    }
                }
                this.plugin.getShopManager().saveShop(this.shop);
                this.isConfirmed = true;
                new PlayerShopGUI(this.player, this.plugin, this.shop).open();
            }
        });
    }
}

