/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.CreateAdvertisementGUI;
import MPP.marketPlacePlus.gui.MyShopsGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ShopSettingsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final PlayerShop shop;

    public ShopSettingsGUI(Player player, MarketPlacePlus plugin, PlayerShop shop) {
        super(player, "\u00a76Shop Settings - " + shop.getShopName(), 3);
        this.plugin = plugin;
        this.shop = shop;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        ItemStack nameItem = this.createItem(Material.NAME_TAG, "\u00a76Change Shop Name", "\u00a77Current: \u00a7f" + this.shop.getShopName(), "", "\u00a7eClick to change");
        this.setItem(11, nameItem, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter new shop name:");
            this.plugin.getChatInputManager().waitForInput(this.player, newName -> {
                if (newName.length() > 32) {
                    this.player.sendMessage("\u00a7cShop name too long! Max 32 characters.");
                    return;
                }
                this.shop.setShopName((String)newName);
                this.plugin.getDatabaseManager().updateShop(this.shop);
                this.player.sendMessage("\u00a7aShop name updated!");
                new ShopSettingsGUI(this.player, this.plugin, this.shop).open();
            });
        });
        String[] descLore = this.createDescriptionLore();
        String[] fullLore = new String[descLore.length + 2];
        System.arraycopy(descLore, 0, fullLore, 0, descLore.length);
        fullLore[descLore.length] = "";
        fullLore[descLore.length + 1] = "\u00a7eClick to change";
        ItemStack descItem = this.createItem(Material.WRITABLE_BOOK, "\u00a76Change Description", fullLore);
        this.setItem(12, descItem, e -> {
            this.playClickSound();
            this.player.closeInventory();
            this.player.sendMessage("\u00a7eEnter new description (or 'none' to clear):");
            this.plugin.getChatInputManager().waitForInput(this.player, newDesc -> {
                if (newDesc.equalsIgnoreCase("none")) {
                    newDesc = "";
                } else if (newDesc.length() > 128) {
                    this.player.sendMessage("\u00a7cDescription too long! Max 128 characters.");
                    return;
                }
                this.shop.setDescription((String)newDesc);
                this.plugin.getDatabaseManager().updateShop(this.shop);
                this.player.sendMessage("\u00a7aDescription updated!");
                new ShopSettingsGUI(this.player, this.plugin, this.shop).open();
            });
        });
        Material statusMaterial = this.shop.isActive() ? Material.LIME_DYE : Material.GRAY_DYE;
        String statusName = this.shop.isActive() ? "\u00a7aShop Active" : "\u00a7cShop Inactive";
        String statusAction = this.shop.isActive() ? "\u00a7eClick to deactivate" : "\u00a7eClick to activate";
        ItemStack statusItem = this.createItem(statusMaterial, statusName, "\u00a77Status: " + (this.shop.isActive() ? "\u00a7aOpen for business" : "\u00a7cClosed"), "", statusAction);
        this.setItem(13, statusItem, e -> {
            this.playClickSound();
            this.shop.setActive(!this.shop.isActive());
            this.plugin.getDatabaseManager().updateShop(this.shop);
            this.refresh();
        });
        ItemStack collectItem = this.createItem(Material.GOLD_INGOT, "\u00a76Collect Earnings", "\u00a77Available: \u00a76" + this.plugin.getEconomyManager().formatMoney(this.shop.getTotalEarnings()), "", "\u00a7eClick to collect");
        this.setItem(14, collectItem, e -> {
            this.playClickSound();
            if (this.shop.getTotalEarnings() > 0.0) {
                this.plugin.getEconomyManager().depositPlayer(this.player, this.shop.getTotalEarnings());
                this.player.sendMessage("\u00a7aCollected \u00a76" + this.plugin.getEconomyManager().formatMoney(this.shop.getTotalEarnings()));
                this.shop.setTotalEarnings(0.0);
                this.plugin.getDatabaseManager().updateShop(this.shop);
                this.refresh();
            } else {
                this.player.sendMessage("\u00a7cNo earnings to collect!");
            }
        });
        ItemStack deleteItem = this.createItem(Material.BARRIER, "\u00a7cDelete Shop", "\u00a77This action cannot be undone!", "\u00a77All items will be returned to you.", "", "\u00a7cShift + Right Click to delete");
        this.setItem(15, deleteItem, e -> {
            if (e.isShiftClick() && e.isRightClick()) {
                e.setCancelled(true);
                this.playClickSound();
                if (this.plugin.getShopManager().deleteShop(this.player, this.shop.getId())) {
                    this.player.sendMessage("\u00a7aShop deleted successfully!");
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.player.closeInventory());
                } else {
                    this.player.sendMessage("\u00a7cFailed to delete shop!");
                }
            }
        });
        ItemStack advertiseItem = this.createItem(Material.BEACON, "\u00a76Advertise Shop", "\u00a77Broadcast your shop to", "\u00a77all online players!", "", "\u00a77Cost: \u00a7a" + this.plugin.getEconomyManager().formatMoney(this.plugin.getConfig().getDouble("advertisements.cost", 5000.0)), "", "\u00a7eClick to create ad");
        this.setItem(16, advertiseItem, e -> {
            this.playClickSound();
            new CreateAdvertisementGUI(this.player, this.plugin, this.shop).open();
        });
        ItemStack backItem = this.createItem(Material.ARROW, "\u00a7cBack", "\u00a77Return to my shops");
        this.setItem(22, backItem, e -> {
            this.playClickSound();
            new MyShopsGUI(this.player, this.plugin).open();
        });
    }

    private String[] createDescriptionLore() {
        ArrayList<Object> lore = new ArrayList<Object>();
        if (this.shop.getDescription().isEmpty()) {
            lore.add("\u00a77No description set");
        } else {
            String[] lines;
            lore.add("\u00a77Current:");
            for (String line : lines = this.shop.getDescription().split("(?<=\\G.{30})")) {
                lore.add("\u00a7f" + line.trim());
            }
        }
        return lore.toArray(new String[0]);
    }
}

