/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminListingsGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayersGUI;
import MPP.marketPlacePlus.gui.admin.AdminReportsGUI;
import MPP.marketPlacePlus.gui.admin.AdminSettingsGUI;
import MPP.marketPlacePlus.gui.admin.AdminShopsGUI;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AdminPanelGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;

    public AdminPanelGUI(MarketPlacePlus plugin, Player player) {
        super(player, "\u00a7c\u00a7lAdmin Panel", 5);
        this.plugin = plugin;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        Map<String, Object> stats = this.plugin.getAdminManager().getMarketStatistics();
        ItemStack statsItem = this.createItem(Material.BOOK, "\u00a76\u00a7lMarket Statistics", "\u00a77Total Listings: \u00a7e" + String.valueOf(stats.get("totalListings")), "\u00a77Total Shops: \u00a7e" + String.valueOf(stats.get("totalShops")), "\u00a77Banned Players: \u00a7c" + String.valueOf(stats.get("totalBannedPlayers")), "\u00a77Total Transactions: \u00a7e" + String.valueOf(stats.get("totalTransactions")), "\u00a77Total Volume: \u00a7a$" + String.format("%.2f", stats.get("totalVolume")), "", "\u00a7eClick to refresh");
        this.setItem(4, statsItem, e -> this.refresh());
        ItemStack playersItem = this.createItem(Material.PLAYER_HEAD, "\u00a7e\u00a7lManage Players", "\u00a77View and manage all players", "\u00a77Ban/unban players from market", "\u00a77Clear player data", "\u00a77View player statistics", "", "\u00a7eClick to open");
        this.setItem(20, playersItem, e -> new AdminPlayersGUI(this.plugin, this.player, 1).open());
        ItemStack listingsItem = this.createItem(Material.GOLD_INGOT, "\u00a7e\u00a7lManage Listings", "\u00a77View all active listings", "\u00a77Delete inappropriate listings", "\u00a77Force expire listings", "\u00a77Adjust listing prices", "", "\u00a7eClick to open");
        this.setItem(22, listingsItem, e -> new AdminListingsGUI(this.plugin, this.player, 1).open());
        ItemStack shopsItem = this.createItem(Material.CHEST, "\u00a7e\u00a7lManage Shops", "\u00a77View all player shops", "\u00a77Delete inappropriate shops", "\u00a77Edit shop details", "\u00a77Manage shop items", "", "\u00a7eClick to open");
        this.setItem(24, shopsItem, e -> new AdminShopsGUI(this.plugin, this.player, 1).open());
        ItemStack alertsItem = this.createItem(Material.BELL, "\u00a7c\u00a7lAlerts & Reports", "\u00a77View reported listings", "\u00a77View reported shops", "\u00a77View flagged transactions", "\u00a77Active admins: \u00a7a" + this.plugin.getAdminManager().getOnlineAdmins().size(), "", "\u00a7eClick to view");
        this.setItem(30, alertsItem, e -> {
            this.playClickSound();
            new AdminReportsGUI(this.plugin, this.player).open();
        });
        ItemStack settingsItem = this.createItem(Material.REDSTONE, "\u00a7c\u00a7lAdmin Settings", "\u00a77Configure admin alerts", "\u00a77Set auto-moderation rules", "\u00a77Configure ban settings", "\u00a77Webhook notifications", "", "\u00a7eClick to configure");
        this.setItem(32, settingsItem, e -> new AdminSettingsGUI(this.plugin, this.player, AdminSettingsGUI.SettingsCategory.MAIN).open());
        ItemStack reloadItem = this.createItem(Material.EMERALD, "\u00a7a\u00a7lReload Plugin", "\u00a77Reload configuration files", "\u00a77Refresh all data", "", "\u00a7c\u00a7lWarning: \u00a77This may cause", "\u00a77temporary disruption", "", "\u00a7eClick to reload");
        this.setItem(40, reloadItem, e -> {
            if (this.plugin.getAdminManager().hasSpecificPermission(this.player, "reload")) {
                this.plugin.reload();
                this.player.sendMessage("\u00a7aPlugin reloaded successfully!");
                this.playSuccessSound();
                this.refresh();
            } else {
                this.player.sendMessage("\u00a7cYou don't have permission to reload!");
                this.playErrorSound();
            }
        });
    }
}

