/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import MPP.marketPlacePlus.models.PlayerShop;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminPlayerShopsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final OfflinePlayer targetPlayer;
    private final List<PlayerShop> playerShops;

    public AdminPlayerShopsGUI(MarketPlacePlus plugin, Player player, OfflinePlayer targetPlayer) {
        super(player, "\u00a7c\u00a7l" + targetPlayer.getName() + "'s Shops", 4);
        this.plugin = plugin;
        this.targetPlayer = targetPlayer;
        this.playerShops = plugin.getShopManager().getPlayerShops(targetPlayer.getUniqueId());
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Player", "\u00a77Return to " + this.targetPlayer.getName() + "'s profile");
        this.setItem(27, backButton, e -> new AdminPlayerManageGUI(this.plugin, this.player, this.targetPlayer).open());
        if (this.playerShops.isEmpty()) {
            ItemStack noShops = this.createItem(Material.BARRIER, "\u00a7cNo Shops Found", "\u00a77This player doesn't", "\u00a77own any shops");
            this.setItem(13, noShops, null);
            return;
        }
        int slot = 10;
        for (PlayerShop shop : this.playerShops) {
            if (slot == 17) {
                slot = 19;
            }
            if (slot > 25) break;
            ItemStack shopItem = new ItemStack(Material.CHEST);
            ItemMeta meta = shopItem.getItemMeta();
            meta.setDisplayName("\u00a7e" + shop.getName());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + shop.getDescription());
            lore.add("");
            lore.add("\u00a77Items: \u00a7e" + shop.getItems().size());
            lore.add("\u00a77Rating: " + shop.getFormattedRating());
            lore.add("\u00a77Location: \u00a7f" + shop.getLocationString());
            lore.add("");
            lore.add("\u00a7c\u00a7lAdmin Actions:");
            lore.add("\u00a7e\u00a7lLeft Click \u00a77to view items");
            lore.add("\u00a7c\u00a7lRight Click \u00a77to delete shop");
            meta.setLore(lore);
            shopItem.setItemMeta(meta);
            this.setItem(slot, shopItem, e -> {
                if (e.isLeftClick()) {
                    this.player.sendMessage("\u00a7eShop items for " + shop.getName() + ":");
                    shop.getItemsAsItemStacks().forEach((itemSlot, item) -> this.player.sendMessage("\u00a77- " + String.valueOf(item.getType()) + " x" + item.getAmount() + " \u00a7a($" + shop.getItemPrice((int)itemSlot) + ")"));
                } else if (e.isRightClick()) {
                    if (this.plugin.getAdminManager().deletePlayerShop(shop.getIdAsUUID(), this.player)) {
                        this.player.sendMessage("\u00a7aSuccessfully deleted shop!");
                        this.playSuccessSound();
                        this.refresh();
                    } else {
                        this.player.sendMessage("\u00a7cFailed to delete shop!");
                        this.playErrorSound();
                    }
                }
            });
            ++slot;
        }
    }
}

