/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPanelGUI;
import MPP.marketPlacePlus.gui.admin.AdminPlayerManageGUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class AdminPlayersGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private final int page;
    private List<OfflinePlayer> allPlayers;
    private static final int ITEMS_PER_PAGE = 28;

    public AdminPlayersGUI(MarketPlacePlus plugin, Player player, int page) {
        super(player, "\u00a7c\u00a7lManage Players - Page " + page, 6);
        this.plugin = plugin;
        this.page = page;
        this.loadPlayers();
    }

    private void loadPlayers() {
        this.allPlayers = Arrays.stream(Bukkit.getOfflinePlayers()).filter(p -> p.hasPlayedBefore() && p.getName() != null).sorted((a, b) -> {
            boolean aBanned = this.plugin.getAdminManager().isPlayerBanned(a.getUniqueId());
            boolean bBanned = this.plugin.getAdminManager().isPlayerBanned(b.getUniqueId());
            if (aBanned && !bBanned) {
                return -1;
            }
            if (!aBanned && bBanned) {
                return 1;
            }
            int aListings = this.plugin.getAuctionManager().getPlayerActiveListings(a.getUniqueId()).size();
            int bListings = this.plugin.getAuctionManager().getPlayerActiveListings(b.getUniqueId()).size();
            return Integer.compare(bListings, aListings);
        }).collect(Collectors.toList());
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        ItemStack backButton = this.createItem(Material.BARRIER, "\u00a7cBack to Admin Panel", "\u00a77Click to return");
        this.setItem(45, backButton, e -> new AdminPanelGUI(this.plugin, this.player).open());
        ItemStack searchButton = this.createItem(Material.COMPASS, "\u00a7eSearch Players", "\u00a77Search by name", "", "\u00a7eClick to search");
        this.setItem(49, searchButton, e -> {
            this.player.closeInventory();
            this.player.sendMessage("\u00a7ePlease type the player name to search:");
            MarketPlacePlus.getInstance().getChatInputManager().waitForInput(this.player, input -> {
                List searchResults = this.allPlayers.stream().filter(p -> p.getName().toLowerCase().contains(input.toLowerCase())).collect(Collectors.toList());
                if (searchResults.isEmpty()) {
                    this.player.sendMessage("\u00a7cNo players found matching: " + input);
                    new AdminPlayersGUI(this.plugin, this.player, this.page).open();
                } else {
                    this.allPlayers = searchResults;
                    new AdminPlayersGUI(this.plugin, this.player, 1).open();
                }
            });
        });
        ItemStack bannedFilter = this.createItem(Material.REDSTONE_BLOCK, "\u00a7cShow Banned Only", "\u00a77Filter to show only", "\u00a77banned players", "", "\u00a7eClick to filter");
        this.setItem(53, bannedFilter, e -> {
            this.allPlayers = this.allPlayers.stream().filter(p -> this.plugin.getAdminManager().isPlayerBanned(p.getUniqueId())).collect(Collectors.toList());
            new AdminPlayersGUI(this.plugin, this.player, 1).open();
        });
        int startIndex = (this.page - 1) * 28;
        int endIndex = Math.min(startIndex + 28, this.allPlayers.size());
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex && slotIndex < slots.length; ++i, ++slotIndex) {
            OfflinePlayer targetPlayer = this.allPlayers.get(i);
            Map<String, Object> stats = this.plugin.getAdminManager().getPlayerStatistics(targetPlayer.getUniqueId());
            boolean isBanned = (Boolean)stats.get("isBanned");
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
            meta.setOwningPlayer(targetPlayer);
            meta.setDisplayName((isBanned ? "\u00a7c" : "\u00a7a") + targetPlayer.getName());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77UUID: \u00a7f" + targetPlayer.getUniqueId().toString().substring(0, 8) + "...");
            lore.add("");
            lore.add("\u00a77Status: " + (isBanned ? "\u00a7cBanned" : "\u00a7aActive"));
            if (isBanned) {
                String reason = this.plugin.getAdminManager().getBanReason(targetPlayer.getUniqueId());
                lore.add("\u00a77Ban Reason: \u00a7c" + reason);
            }
            lore.add("");
            lore.add("\u00a77Active Listings: \u00a7e" + String.valueOf(stats.get("activeListings")));
            lore.add("\u00a77Total Shops: \u00a7e" + String.valueOf(stats.get("totalShops")));
            lore.add("\u00a77Total Earnings: \u00a7a$" + String.format("%.2f", stats.get("totalEarnings")));
            lore.add("\u00a77Total Spent: \u00a7c$" + String.format("%.2f", stats.get("totalSpent")));
            lore.add("");
            lore.add("\u00a7e\u00a7lLeft Click \u00a77to manage");
            lore.add("\u00a7c\u00a7lRight Click \u00a77for quick actions");
            meta.setLore(lore);
            playerHead.setItemMeta((ItemMeta)meta);
            this.setItem(slots[slotIndex], playerHead, e -> {
                if (e.isLeftClick()) {
                    new AdminPlayerManageGUI(this.plugin, this.player, targetPlayer).open();
                } else if (e.isRightClick()) {
                    this.openQuickActionsMenu(targetPlayer);
                }
            });
        }
        int maxPages = (this.allPlayers.size() - 1) / 28;
        this.addNavigationButtons(this.page - 1, maxPages, () -> new AdminPlayersGUI(this.plugin, this.player, this.page - 1).open(), () -> new AdminPlayersGUI(this.plugin, this.player, this.page + 1).open());
    }

    private void openQuickActionsMenu(OfflinePlayer targetPlayer) {
        this.player.closeInventory();
        this.player.sendMessage("\u00a76\u00a7lQuick Actions for " + targetPlayer.getName() + ":");
        this.player.sendMessage("\u00a7e1. \u00a77Ban player - \u00a7c/mpadmin ban " + targetPlayer.getName() + " <reason>");
        this.player.sendMessage("\u00a7e2. \u00a77Unban player - \u00a7a/mpadmin unban " + targetPlayer.getName());
        this.player.sendMessage("\u00a7e3. \u00a77Clear data - \u00a7c/mpadmin clear " + targetPlayer.getName());
        this.player.sendMessage("\u00a7e4. \u00a77View stats - \u00a7e/mpadmin stats " + targetPlayer.getName());
        this.player.sendMessage("\u00a77Type \u00a7e/mpadmin players \u00a77to return to the GUI");
    }
}

