/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.gui.admin;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import MPP.marketPlacePlus.gui.admin.AdminPanelGUI;
import MPP.marketPlacePlus.gui.admin.AdminReportDetailsGUI;
import MPP.marketPlacePlus.models.Report;
import MPP.marketPlacePlus.utils.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminReportsGUI
extends BaseGUI {
    private final MarketPlacePlus plugin;
    private Report.ReportStatus filterStatus = Report.ReportStatus.PENDING;
    private List<Report> reports;
    private int currentPage = 0;
    private static final int REPORTS_PER_PAGE = 28;

    public AdminReportsGUI(MarketPlacePlus plugin, Player player) {
        super(player, "\u00a7c\u00a7lReports Management", 6);
        this.plugin = plugin;
    }

    @Override
    public void setupGUI() {
        this.fillBorder(Material.RED_STAINED_GLASS_PANE);
        this.loadReports();
        this.addControlButtons();
        this.displayReports();
        this.addNavigationButtons(this.currentPage, this.getMaxPages(), this::previousPage, this::nextPage);
    }

    private void loadReports() {
        switch (this.filterStatus) {
            case PENDING: {
                this.reports = this.plugin.getReportManager().getPendingReports();
                break;
            }
            case REVIEWING: {
                this.reports = this.plugin.getReportManager().getReviewingReports();
                break;
            }
            default: {
                this.reports = this.plugin.getReportManager().getResolvedReports(100);
            }
        }
    }

    private void addControlButtons() {
        Map<String, Integer> stats = this.plugin.getReportManager().getReportStatistics();
        ItemStack statsItem = this.createItem(Material.BOOK, "\u00a76\u00a7lReport Statistics", "\u00a77Total Reports: \u00a7e" + String.valueOf(stats.get("total")), "\u00a77Pending: \u00a7c" + String.valueOf(stats.get("pending")), "\u00a77Under Review: \u00a76" + String.valueOf(stats.get("reviewing")), "\u00a77Resolved: \u00a7a" + String.valueOf(stats.get("resolved")), "\u00a77Dismissed: \u00a78" + String.valueOf(stats.get("dismissed")), "", "\u00a7eClick to refresh");
        this.setItem(4, statsItem, e -> this.refresh());
        ItemStack pendingFilter = this.createItem(this.filterStatus == Report.ReportStatus.PENDING ? Material.REDSTONE_BLOCK : Material.REDSTONE, "\u00a7c\u00a7lPending Reports", "\u00a77Show reports awaiting review", "\u00a77Count: \u00a7e" + String.valueOf(stats.get("pending")), "", this.filterStatus == Report.ReportStatus.PENDING ? "\u00a7a\u00a7lCURRENTLY SELECTED" : "\u00a7eClick to filter");
        this.setItem(0, pendingFilter, e -> {
            if (this.filterStatus != Report.ReportStatus.PENDING) {
                this.filterStatus = Report.ReportStatus.PENDING;
                this.currentPage = 0;
                this.refresh();
            }
        });
        ItemStack reviewingFilter = this.createItem(this.filterStatus == Report.ReportStatus.REVIEWING ? Material.GOLD_BLOCK : Material.GOLD_INGOT, "\u00a76\u00a7lUnder Review", "\u00a77Show reports being reviewed", "\u00a77Count: \u00a7e" + String.valueOf(stats.get("reviewing")), "", this.filterStatus == Report.ReportStatus.REVIEWING ? "\u00a7a\u00a7lCURRENTLY SELECTED" : "\u00a7eClick to filter");
        this.setItem(1, reviewingFilter, e -> {
            if (this.filterStatus != Report.ReportStatus.REVIEWING) {
                this.filterStatus = Report.ReportStatus.REVIEWING;
                this.currentPage = 0;
                this.refresh();
            }
        });
        ItemStack resolvedFilter = this.createItem(this.filterStatus != Report.ReportStatus.PENDING && this.filterStatus != Report.ReportStatus.REVIEWING ? Material.EMERALD_BLOCK : Material.EMERALD, "\u00a7a\u00a7lResolved Reports", "\u00a77Show completed reports", "\u00a77Count: \u00a7e" + (stats.get("resolved") + stats.get("dismissed")), "", this.filterStatus != Report.ReportStatus.PENDING && this.filterStatus != Report.ReportStatus.REVIEWING ? "\u00a7a\u00a7lCURRENTLY SELECTED" : "\u00a7eClick to filter");
        this.setItem(2, resolvedFilter, e -> {
            if (this.filterStatus == Report.ReportStatus.PENDING || this.filterStatus == Report.ReportStatus.REVIEWING) {
                this.filterStatus = Report.ReportStatus.RESOLVED;
                this.currentPage = 0;
                this.refresh();
            }
        });
        ItemStack backButton = this.createItem(Material.ARROW, "\u00a7cBack to Admin Panel", new String[0]);
        this.setItem(8, backButton, e -> new AdminPanelGUI(this.plugin, this.player).open());
    }

    private void displayReports() {
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.reports.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot % 9 == 8) {
                slot += 2;
            }
            Report report = this.reports.get(i);
            ItemStack reportItem = this.createReportItem(report);
            this.setItem(slot, reportItem, e -> {
                if (e.getClick() == ClickType.LEFT) {
                    new AdminReportDetailsGUI(this.plugin, this.player, report).open();
                } else if (e.getClick() == ClickType.RIGHT && report.getStatus() == Report.ReportStatus.PENDING) {
                    this.plugin.getReportManager().updateReportStatus(report.getId(), Report.ReportStatus.REVIEWING, this.player.getUniqueId().toString());
                    this.playSuccessSound();
                    this.refresh();
                }
            });
            ++slot;
        }
    }

    private ItemStack createReportItem(Report report) {
        ItemStack item = new ItemStack(switch (report.getStatus()) {
            case Report.ReportStatus.PENDING -> Material.RED_WOOL;
            case Report.ReportStatus.REVIEWING -> Material.YELLOW_WOOL;
            case Report.ReportStatus.RESOLVED -> Material.LIME_WOOL;
            case Report.ReportStatus.DISMISSED -> Material.GRAY_WOOL;
            default -> Material.WHITE_WOOL;
        });
        ItemMeta meta = item.getItemMeta();
        String statusColor = switch (report.getStatus()) {
            case Report.ReportStatus.PENDING -> "\u00a7c";
            case Report.ReportStatus.REVIEWING -> "\u00a76";
            case Report.ReportStatus.RESOLVED -> "\u00a7a";
            case Report.ReportStatus.DISMISSED -> "\u00a78";
            default -> "\u00a77";
        };
        meta.setDisplayName(statusColor + "Report #" + report.getId().substring(0, 8));
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Type: \u00a7e" + report.getReportType().name());
        lore.add("\u00a77Reporter: \u00a7e" + report.getReporterName());
        lore.add("\u00a77Reported: \u00a7c" + report.getReportedName());
        lore.add("\u00a77Reason: \u00a7f" + report.getReason());
        lore.add("\u00a77Time: \u00a7f" + TimeUtils.formatTimeAgo(report.getReportTime()));
        lore.add("\u00a77Status: " + statusColor + report.getStatus().name());
        if (report.getResolvedBy() != null) {
            lore.add("\u00a77Resolved by: \u00a7e" + this.plugin.getServer().getOfflinePlayer(UUID.fromString(report.getResolvedBy())).getName());
        }
        lore.add("");
        lore.add("\u00a7aLeft-click to view details");
        if (report.getStatus() == Report.ReportStatus.PENDING) {
            lore.add("\u00a7eRight-click to start review");
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private int getMaxPages() {
        return Math.max(0, (this.reports.size() - 1) / 28);
    }

    private void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.refresh();
        }
    }

    private void nextPage() {
        if (this.currentPage < this.getMaxPages()) {
            ++this.currentPage;
            this.refresh();
        }
    }
}

