/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.integrations;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.managers.PlaceholderStubMethods;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MarketPlacePlusExpansion
extends PlaceholderExpansion {
    private final MarketPlacePlus plugin;
    private final DecimalFormat moneyFormat = new DecimalFormat("#,##0.00");
    private final DecimalFormat numberFormat = new DecimalFormat("#,##0");

    public MarketPlacePlusExpansion(MarketPlacePlus plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "mpp";
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return this.handleGlobalPlaceholder(params);
        }
        String[] args = params.split("_");
        switch (args[0].toLowerCase()) {
            case "listings": {
                return this.handleListingsPlaceholder(player, args);
            }
            case "shop": {
                return this.handleShopPlaceholder(player, args);
            }
            case "stats": {
                return this.handleStatsPlaceholder(player, args);
            }
            case "balance": {
                return this.handleBalancePlaceholder(player, args);
            }
            case "collection": {
                return this.handleCollectionPlaceholder(player, args);
            }
            case "auction": {
                return this.handleAuctionPlaceholder(player, args);
            }
            case "top": {
                return this.handleTopPlaceholder(args);
            }
            case "global": {
                return this.handleGlobalPlaceholder(params.substring(7));
            }
            case "leaderboard": {
                return this.handleLeaderboardPlaceholder(args);
            }
            case "time": {
                return this.handleTimePlaceholder(player, args);
            }
            case "tax": {
                return this.handleTaxPlaceholder(player, args);
            }
        }
        return null;
    }

    private String handleListingsPlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        UUID playerId = player.getUniqueId();
        List<MarketItem> listings = this.plugin.getAuctionManager().getPlayerListings(playerId);
        switch (args[1].toLowerCase()) {
            case "active": {
                return this.numberFormat.format(listings.stream().filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "sold": {
                return this.numberFormat.format(listings.stream().filter(MarketItem::isSold).count());
            }
            case "expired": {
                return this.numberFormat.format(listings.stream().filter(MarketItem::isExpired).count());
            }
            case "total": {
                return this.numberFormat.format(listings.size());
            }
            case "earnings": {
                return this.moneyFormat.format(listings.stream().filter(MarketItem::isSold).mapToDouble(MarketItem::getPrice).sum());
            }
            case "auctions": {
                return this.numberFormat.format(listings.stream().filter(MarketItem::isAuction).filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "buynow": {
                return this.numberFormat.format(listings.stream().filter(item -> !item.isAuction()).filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "highestbid": {
                return this.moneyFormat.format(listings.stream().filter(MarketItem::isAuction).filter(item -> item.getCurrentBid() > 0.0).mapToDouble(MarketItem::getCurrentBid).max().orElse(0.0));
            }
        }
        return "0";
    }

    private String handleShopPlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        UUID playerId = player.getUniqueId();
        PlayerShop shop = this.plugin.getShopManager().getPlayerShop(playerId);
        if (shop == null) {
            return args[1].equals("exists") ? "false" : "0";
        }
        switch (args[1].toLowerCase()) {
            case "exists": {
                return "true";
            }
            case "name": {
                return shop.getShopName();
            }
            case "items": {
                return this.numberFormat.format(shop.getItems().size());
            }
            case "visits": {
                return this.numberFormat.format(shop.getVisitCount());
            }
            case "rating": {
                return String.format("%.1f", shop.getAverageRating());
            }
            case "earnings": {
                return this.moneyFormat.format(shop.getTotalEarnings());
            }
            case "active": {
                return String.valueOf(shop.isActive());
            }
            case "stock": {
                return this.numberFormat.format(shop.getItems().values().stream().mapToInt(PlayerShop.ShopItem::getStock).sum());
            }
            case "totalvalue": {
                return this.moneyFormat.format(shop.getItems().values().stream().mapToDouble(item -> item.getPrice() * (double)item.getStock()).sum());
            }
            case "ratingcount": {
                return this.numberFormat.format(shop.getTotalRatings());
            }
            case "location": {
                if (shop.getLocation() != null) {
                    return String.format("%s:%d,%d,%d", shop.getLocation().getWorld().getName(), shop.getLocation().getBlockX(), shop.getLocation().getBlockY(), shop.getLocation().getBlockZ());
                }
                return "Not Set";
            }
            case "topselling": {
                return shop.getItems().values().stream().max((a, b) -> Double.compare(a.getPrice() * (double)(1000 - a.getStock()), b.getPrice() * (double)(1000 - b.getStock()))).map(item -> item.getItem().getType().name()).orElse("None");
            }
        }
        return "0";
    }

    private String handleStatsPlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        UUID playerId = player.getUniqueId();
        switch (args[1].toLowerCase()) {
            case "totalsales": {
                return this.numberFormat.format(this.plugin.getTradeHistoryManager().getPlayerSalesCount(playerId));
            }
            case "totalpurchases": {
                return this.numberFormat.format(this.plugin.getTradeHistoryManager().getPlayerPurchaseCount(playerId));
            }
            case "totalspent": {
                return this.moneyFormat.format(this.plugin.getTradeHistoryManager().getPlayerTotalSpent(playerId));
            }
            case "totalearned": {
                return this.moneyFormat.format(this.plugin.getTradeHistoryManager().getPlayerTotalEarned(playerId));
            }
            case "averagesale": {
                double totalEarned = this.plugin.getTradeHistoryManager().getPlayerTotalEarned(playerId);
                int salesCount = this.plugin.getTradeHistoryManager().getPlayerSalesCount(playerId);
                return this.moneyFormat.format(salesCount > 0 ? totalEarned / (double)salesCount : 0.0);
            }
            case "reputation": {
                return this.calculateReputation(playerId);
            }
            case "rank": {
                return this.getPlayerRank(playerId);
            }
            case "tradepartners": {
                return this.numberFormat.format(this.plugin.getTradeHistoryManager().getUniqueTradePartners(playerId).size());
            }
            case "lasttradedays": {
                LocalDateTime lastTrade = this.plugin.getTradeHistoryManager().getLastTradeTime(playerId);
                return lastTrade != null ? String.valueOf(ChronoUnit.DAYS.between(lastTrade, LocalDateTime.now())) : "Never";
            }
        }
        return "0";
    }

    private String handleBalancePlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        switch (args[1].toLowerCase()) {
            case "current": {
                Player onlinePlayer = player.getPlayer();
                if (onlinePlayer != null) {
                    return this.moneyFormat.format(this.plugin.getEconomyManager().getBalance(onlinePlayer));
                }
                return "0";
            }
            case "formatted": {
                Player onlinePlayer2 = player.getPlayer();
                if (onlinePlayer2 != null) {
                    return this.plugin.getEconomyManager().formatMoney(this.plugin.getEconomyManager().getBalance(onlinePlayer2));
                }
                return "$0.00";
            }
            case "pending": {
                return this.moneyFormat.format(PlaceholderStubMethods.CollectionManagerStubs.getPendingBalance(player.getUniqueId()));
            }
        }
        return "0";
    }

    private String handleCollectionPlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        UUID playerId = player.getUniqueId();
        switch (args[1].toLowerCase()) {
            case "items": {
                return this.numberFormat.format(PlaceholderStubMethods.CollectionManagerStubs.getCollectionItems(playerId).size());
            }
            case "money": {
                return this.moneyFormat.format(PlaceholderStubMethods.CollectionManagerStubs.getPendingBalance(playerId));
            }
            case "total": {
                return this.numberFormat.format(PlaceholderStubMethods.CollectionManagerStubs.getCollectionItems(playerId).size() + (PlaceholderStubMethods.CollectionManagerStubs.getPendingBalance(playerId) > 0.0 ? 1 : 0));
            }
        }
        return "0";
    }

    private String handleAuctionPlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        UUID playerId = player.getUniqueId();
        List auctions = this.plugin.getAuctionManager().getPlayerListings(playerId).stream().filter(MarketItem::isAuction).collect(Collectors.toList());
        switch (args[1].toLowerCase()) {
            case "active": {
                return this.numberFormat.format(auctions.stream().filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "bids": {
                return this.numberFormat.format(auctions.stream().filter(item -> item.getCurrentBid() > 0.0).count());
            }
            case "watching": {
                return this.numberFormat.format(PlaceholderStubMethods.AuctionManagerStubs.getWatchedAuctions(playerId).size());
            }
            case "winning": {
                return this.numberFormat.format(this.plugin.getAuctionManager().getAllListings().stream().filter(MarketItem::isAuction).filter(item -> item.getCurrentBid() > 0.0).filter(item -> item.getHighestBidderId() != null && item.getHighestBidderId().equals(playerId)).count());
            }
            case "outbid": {
                return this.numberFormat.format(PlaceholderStubMethods.NotificationManagerStubs.getOutbidCount(playerId));
            }
        }
        return "0";
    }

    private String handleTopPlaceholder(String[] args) {
        int position;
        if (args.length < 3) {
            return "";
        }
        try {
            position = Integer.parseInt(args[1]) - 1;
        }
        catch (NumberFormatException e) {
            return "";
        }
        switch (args[2].toLowerCase()) {
            case "seller": {
                return this.getTopSeller(position);
            }
            case "buyer": {
                return this.getTopBuyer(position);
            }
            case "shop": {
                return this.getTopShop(position);
            }
            case "earnings": {
                return this.getTopEarnings(position);
            }
            case "shoprating": {
                return this.getTopShopByRating(position);
            }
            case "shopvisits": {
                return this.getTopShopByVisits(position);
            }
            case "auctioneer": {
                return this.getTopAuctioneer(position);
            }
            case "trader": {
                return this.getTopTrader(position);
            }
        }
        return "";
    }

    private String handleGlobalPlaceholder(String params) {
        String[] args = params.split("_");
        switch (args[0].toLowerCase()) {
            case "totallistings": {
                return this.numberFormat.format(this.plugin.getAuctionManager().getAllListings().size());
            }
            case "activelistings": {
                return this.numberFormat.format(this.plugin.getAuctionManager().getAllListings().stream().filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "totalshops": {
                return this.numberFormat.format(this.plugin.getShopManager().getAllShops().size());
            }
            case "activeshops": {
                return this.numberFormat.format(this.plugin.getShopManager().getAllShops().stream().filter(PlayerShop::isActive).count());
            }
            case "totalvolume": {
                return this.moneyFormat.format(this.plugin.getCacheManager().getTotalMarketVolume());
            }
            case "averageprice": {
                return this.moneyFormat.format(this.plugin.getCacheManager().getAverageItemPrice());
            }
            case "totalauctions": {
                return this.numberFormat.format(this.plugin.getAuctionManager().getAllListings().stream().filter(MarketItem::isAuction).filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "totalbuynow": {
                return this.numberFormat.format(this.plugin.getAuctionManager().getAllListings().stream().filter(item -> !item.isAuction()).filter(item -> !item.isSold() && !item.isExpired()).count());
            }
            case "onlineplayers": {
                return this.numberFormat.format(Bukkit.getOnlinePlayers().size());
            }
            case "marketactivity": {
                return this.calculateMarketActivity();
            }
            case "trendingitem": {
                return this.plugin.getCacheManager().getTrendingItem();
            }
            case "taxcollected": {
                return this.moneyFormat.format(this.plugin.getCacheManager().getTotalTaxCollected());
            }
            case "advertisements": {
                return this.numberFormat.format(this.plugin.getAdvertisementManager().getActiveAdvertisements().size());
            }
            case "reports": {
                return this.numberFormat.format(this.plugin.getReportManager().getPendingReports().size());
            }
        }
        return "0";
    }

    private String handleLeaderboardPlaceholder(String[] args) {
        int position;
        if (args.length < 3) {
            return "";
        }
        try {
            position = Integer.parseInt(args[2]) - 1;
        }
        catch (NumberFormatException e) {
            return "";
        }
        switch (args[1].toLowerCase()) {
            case "sales": {
                return this.getLeaderboardEntry("sales", position);
            }
            case "purchases": {
                return this.getLeaderboardEntry("purchases", position);
            }
            case "volume": {
                return this.getLeaderboardEntry("volume", position);
            }
            case "shops": {
                return this.getLeaderboardEntry("shops", position);
            }
            case "auctions": {
                return this.getLeaderboardEntry("auctions", position);
            }
        }
        return "";
    }

    private String handleTimePlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "";
        }
        switch (args[1].toLowerCase()) {
            case "nextauction": {
                return this.getTimeUntilNextAuctionExpiry();
            }
            case "shoprefresh": {
                return this.getTimeUntilShopRefresh();
            }
            case "advertisementcooldown": {
                return this.getAdvertisementCooldown(player.getUniqueId());
            }
            case "listingcooldown": {
                return this.getListingCooldown(player.getUniqueId());
            }
        }
        return "";
    }

    private String handleTaxPlaceholder(OfflinePlayer player, String[] args) {
        if (args.length < 2) {
            return "0";
        }
        switch (args[1].toLowerCase()) {
            case "rate": {
                return String.format("%.1f%%", this.plugin.getConfig().getDouble("taxes.sales", 5.0));
            }
            case "nextamount": {
                if (args.length > 2) {
                    try {
                        double amount = Double.parseDouble(args[2]);
                        double taxRate = this.plugin.getConfig().getDouble("taxes.sales", 5.0) / 100.0;
                        return this.moneyFormat.format(amount * taxRate);
                    }
                    catch (NumberFormatException e) {
                        return "0";
                    }
                }
                return "0";
            }
            case "saved": {
                if (player.isOnline() && ((Player)player).hasPermission("marketplaceplus.admin.bypass.tax")) {
                    return this.moneyFormat.format(this.plugin.getCacheManager().getPlayerTaxSaved(player.getUniqueId()));
                }
                return "0";
            }
        }
        return "0";
    }

    private String calculateReputation(UUID playerId) {
        double rating;
        int sales = this.plugin.getTradeHistoryManager().getPlayerSalesCount(playerId);
        PlayerShop shop = this.plugin.getShopManager().getPlayerShop(playerId);
        double d = rating = shop != null ? shop.getAverageRating() : 0.0;
        if (sales >= 1000 && rating >= 4.5) {
            return "Legendary";
        }
        if (sales >= 500 && rating >= 4.0) {
            return "Master";
        }
        if (sales >= 200 && rating >= 3.5) {
            return "Expert";
        }
        if (sales >= 50 && rating >= 3.0) {
            return "Trusted";
        }
        if (sales >= 10) {
            return "Regular";
        }
        return "Newcomer";
    }

    private String getPlayerRank(UUID playerId) {
        List<UUID> topSellers = this.plugin.getCacheManager().getTopSellers();
        int position = topSellers.indexOf(playerId) + 1;
        return position > 0 ? "#" + position : "Unranked";
    }

    private String getTopSeller(int position) {
        List<UUID> topSellers = this.plugin.getCacheManager().getTopSellers();
        if (position >= 0 && position < topSellers.size()) {
            return Bukkit.getOfflinePlayer((UUID)topSellers.get(position)).getName();
        }
        return "None";
    }

    private String getTopBuyer(int position) {
        List<UUID> topBuyers = this.plugin.getCacheManager().getTopBuyers();
        if (position >= 0 && position < topBuyers.size()) {
            return Bukkit.getOfflinePlayer((UUID)topBuyers.get(position)).getName();
        }
        return "None";
    }

    private String getTopShop(int position) {
        List<PlayerShop> topShops = this.plugin.getShopManager().getTopShops();
        if (position >= 0 && position < topShops.size()) {
            return topShops.get(position).getShopName();
        }
        return "None";
    }

    private String getTopEarnings(int position) {
        List<UUID> topEarners = this.plugin.getCacheManager().getTopEarners();
        if (position >= 0 && position < topEarners.size()) {
            UUID playerId = topEarners.get(position);
            return this.moneyFormat.format(this.plugin.getTradeHistoryManager().getPlayerTotalEarned(playerId));
        }
        return "0";
    }

    private String getTopShopByRating(int position) {
        List shops = this.plugin.getShopManager().getAllShops().stream().sorted((a, b) -> Double.compare(b.getAverageRating(), a.getAverageRating())).toList();
        if (position >= 0 && position < shops.size()) {
            return ((PlayerShop)shops.get(position)).getShopName();
        }
        return "None";
    }

    private String getTopShopByVisits(int position) {
        List shops = this.plugin.getShopManager().getAllShops().stream().sorted((a, b) -> Integer.compare(b.getVisitCount(), a.getVisitCount())).toList();
        if (position >= 0 && position < shops.size()) {
            return ((PlayerShop)shops.get(position)).getShopName();
        }
        return "None";
    }

    private String getTopAuctioneer(int position) {
        List<UUID> topAuctioneers = this.plugin.getCacheManager().getTopAuctioneers();
        if (position >= 0 && position < topAuctioneers.size()) {
            return Bukkit.getOfflinePlayer((UUID)topAuctioneers.get(position)).getName();
        }
        return "None";
    }

    private String getTopTrader(int position) {
        List<UUID> topTraders = this.plugin.getCacheManager().getTopTraders();
        if (position >= 0 && position < topTraders.size()) {
            return Bukkit.getOfflinePlayer((UUID)topTraders.get(position)).getName();
        }
        return "None";
    }

    private String calculateMarketActivity() {
        int activeListings = (int)this.plugin.getAuctionManager().getAllListings().stream().filter(item -> !item.isSold() && !item.isExpired()).count();
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        if (activeListings > 100 && onlinePlayers > 20) {
            return "Very High";
        }
        if (activeListings > 50 && onlinePlayers > 10) {
            return "High";
        }
        if (activeListings > 20 && onlinePlayers > 5) {
            return "Medium";
        }
        if (activeListings > 5) {
            return "Low";
        }
        return "Very Low";
    }

    private String getTimeUntilNextAuctionExpiry() {
        return this.plugin.getAuctionManager().getAllListings().stream().filter(MarketItem::isAuction).filter(item -> !item.isSold() && !item.isExpired()).map(MarketItem::getExpiryTime).min(LocalDateTime::compareTo).map(time -> this.formatTimeUntil((LocalDateTime)time)).orElse("None");
    }

    private String getTimeUntilShopRefresh() {
        long minutes = this.plugin.getConfig().getLong("shops.refresh-interval", 60L);
        return this.formatDuration(minutes * 60L);
    }

    private String getAdvertisementCooldown(UUID playerId) {
        long cooldown = PlaceholderStubMethods.AdvertisementManagerStubs.getCooldown(playerId);
        return cooldown > 0L ? this.formatDuration(cooldown) : "Ready";
    }

    private String getListingCooldown(UUID playerId) {
        long cooldown = PlaceholderStubMethods.AuctionManagerStubs.getListingCooldown(playerId);
        return cooldown > 0L ? this.formatDuration(cooldown) : "Ready";
    }

    private String getLeaderboardEntry(String type, int position) {
        return "Player" + (position + 1);
    }

    private String formatTimeUntil(LocalDateTime time) {
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), time);
        return this.formatDuration(seconds);
    }

    private String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + "h";
        }
        return seconds / 86400L + "d";
    }
}

