/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.listeners;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.gui.BaseGUI;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BaseGUI gui = BaseGUI.getOpenGUI(event.getPlayer().getUniqueId());
        if (gui != null) {
            event.getPlayer().closeInventory();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        MarketPlacePlus plugin = MarketPlacePlus.getInstance();
        if (plugin != null) {
            plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> {
                int itemCount;
                if (plugin.getShopManager() != null) {
                    plugin.getShopManager().loadPlayerShops(player.getUniqueId());
                }
                if (plugin.getCollectionManager() != null && (itemCount = plugin.getCollectionManager().getItemCount(player.getUniqueId())) > 0 && plugin.getCollectionManager().shouldNotifyPlayer(player.getUniqueId())) {
                    plugin.getServer().getScheduler().runTask((Plugin)plugin, () -> {
                        player.sendMessage("\u00a76\u00a7l[Collection Box] \u00a7eYou have \u00a7f" + itemCount + " \u00a7eitems waiting in your collection box!");
                        player.sendMessage("\u00a7eUse \u00a76/market collect \u00a7eto retrieve them!");
                        plugin.getCollectionManager().updateLastNotificationTime(player.getUniqueId());
                        if (plugin.getConfig().getBoolean("collection.auto-collect-on-join", false)) {
                            plugin.getCollectionManager().tryAutoCollect(player);
                        }
                    });
                }
            }, 20L);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        BaseGUI gui = BaseGUI.getOpenGUI(event.getEntity().getUniqueId());
        if (gui != null) {
            event.getEntity().closeInventory();
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        BaseGUI gui;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null || from.getWorld() == null || to.getWorld() == null) {
            return;
        }
        if ((!from.getWorld().equals((Object)to.getWorld()) || from.distance(to) > 50.0) && (gui = BaseGUI.getOpenGUI(player.getUniqueId())) != null) {
            player.closeInventory();
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        BaseGUI gui = BaseGUI.getOpenGUI(event.getPlayer().getUniqueId());
        if (gui != null) {
            event.getPlayer().closeInventory();
        }
    }
}

