/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class AdminManager {
    private final MarketPlacePlus plugin;
    private final Map<UUID, AdminAction> pendingActions;
    private final Map<UUID, Long> lastAdminActions;

    public AdminManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.pendingActions = new HashMap<UUID, AdminAction>();
        this.lastAdminActions = new HashMap<UUID, Long>();
    }

    public boolean hasAdminPermission(Player player) {
        return player.hasPermission("marketplaceplus.admin.*") || player.hasPermission("marketplaceplus.admin.manage.*");
    }

    public boolean hasSpecificPermission(Player player, String permission) {
        return player.hasPermission("marketplaceplus.admin." + permission) || player.hasPermission("marketplaceplus.admin.*");
    }

    public void setPendingAction(UUID adminId, AdminAction action) {
        this.pendingActions.put(adminId, action);
    }

    public AdminAction getPendingAction(UUID adminId) {
        return this.pendingActions.get(adminId);
    }

    public void clearPendingAction(UUID adminId) {
        this.pendingActions.remove(adminId);
    }

    public boolean deleteMarketListing(UUID listingId, Player admin) {
        if (!this.hasSpecificPermission(admin, "manage.auctions")) {
            return false;
        }
        MarketItem item = this.plugin.getAuctionManager().getListingById(listingId);
        if (item == null) {
            return false;
        }
        this.plugin.getAuctionManager().removeListingAdmin(listingId);
        this.logAdminAction(admin, "Deleted listing: " + String.valueOf(listingId));
        Player seller = Bukkit.getPlayer((UUID)item.getSellerId());
        if (seller != null && seller.isOnline()) {
            seller.sendMessage("\u00a7c\u00a7lAdmin Notice: \u00a77Your listing has been removed by an administrator.");
        }
        return true;
    }

    public boolean deletePlayerShop(UUID shopId, Player admin) {
        if (!this.hasSpecificPermission(admin, "manage.shops")) {
            return false;
        }
        PlayerShop shop = this.plugin.getShopManager().getShop(shopId);
        if (shop == null) {
            return false;
        }
        this.plugin.getShopManager().deleteShopAdmin(shopId);
        this.logAdminAction(admin, "Deleted shop: " + String.valueOf(shopId) + " owned by " + shop.getOwnerName());
        Player owner = Bukkit.getPlayer((UUID)shop.getOwnerId());
        if (owner != null && owner.isOnline()) {
            owner.sendMessage("\u00a7c\u00a7lAdmin Notice: \u00a77Your shop has been removed by an administrator.");
        }
        return true;
    }

    public boolean banPlayerFromMarket(UUID playerId, Player admin, String reason) {
        if (!this.hasSpecificPermission(admin, "manage.players")) {
            return false;
        }
        this.plugin.getDatabaseManager().banPlayer(playerId, reason);
        this.plugin.getAuctionManager().removeAllPlayerListings(playerId);
        this.plugin.getShopManager().removeAllPlayerShops(playerId);
        OfflinePlayer bannedPlayer = Bukkit.getOfflinePlayer((UUID)playerId);
        this.logAdminAction(admin, "Banned player " + bannedPlayer.getName() + " from market. Reason: " + reason);
        Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
        if (onlinePlayer != null && onlinePlayer.isOnline()) {
            onlinePlayer.sendMessage("\u00a7c\u00a7lMarket Ban: \u00a77You have been banned from using the marketplace.");
            onlinePlayer.sendMessage("\u00a77Reason: \u00a7f" + reason);
        }
        return true;
    }

    public boolean unbanPlayerFromMarket(UUID playerId, Player admin) {
        if (!this.hasSpecificPermission(admin, "manage.players")) {
            return false;
        }
        this.plugin.getDatabaseManager().unbanPlayer(playerId);
        OfflinePlayer unbannedPlayer = Bukkit.getOfflinePlayer((UUID)playerId);
        this.logAdminAction(admin, "Unbanned player " + unbannedPlayer.getName() + " from market");
        Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
        if (onlinePlayer != null && onlinePlayer.isOnline()) {
            onlinePlayer.sendMessage("\u00a7a\u00a7lMarket Access Restored: \u00a77You can now use the marketplace again.");
        }
        return true;
    }

    public boolean isPlayerBanned(UUID playerId) {
        return this.plugin.getDatabaseManager().isPlayerBanned(playerId);
    }

    public String getBanReason(UUID playerId) {
        return this.plugin.getDatabaseManager().getPlayerBanReason(playerId);
    }

    public List<UUID> getBannedPlayers() {
        return this.plugin.getDatabaseManager().getBannedPlayers();
    }

    public boolean clearPlayerData(UUID playerId, Player admin) {
        if (!this.hasSpecificPermission(admin, "manage.players")) {
            return false;
        }
        this.plugin.getAuctionManager().removeAllPlayerListings(playerId);
        this.plugin.getShopManager().removeAllPlayerShops(playerId);
        this.plugin.getTradeHistoryManager().clearPlayerHistory(playerId);
        OfflinePlayer clearedPlayer = Bukkit.getOfflinePlayer((UUID)playerId);
        this.logAdminAction(admin, "Cleared all market data for player " + clearedPlayer.getName());
        return true;
    }

    public boolean forceExpireListing(UUID listingId, Player admin) {
        if (!this.hasSpecificPermission(admin, "manage.auctions")) {
            return false;
        }
        MarketItem item = this.plugin.getAuctionManager().getListingById(listingId);
        if (item == null) {
            return false;
        }
        this.plugin.getAuctionManager().expireListingAdmin(listingId);
        this.logAdminAction(admin, "Force expired listing: " + String.valueOf(listingId));
        return true;
    }

    public boolean adjustListingPrice(UUID listingId, double newPrice, Player admin) {
        if (!this.hasSpecificPermission(admin, "manage.auctions")) {
            return false;
        }
        MarketItem item = this.plugin.getAuctionManager().getListingById(listingId);
        if (item == null) {
            return false;
        }
        double oldPrice = item.getPrice();
        this.plugin.getAuctionManager().updateListingPrice(listingId, newPrice);
        this.logAdminAction(admin, String.format("Adjusted listing %s price from %.2f to %.2f", listingId, oldPrice, newPrice));
        Player seller = Bukkit.getPlayer((UUID)item.getSellerId());
        if (seller != null && seller.isOnline()) {
            seller.sendMessage(String.format("\u00a7e\u00a7lPrice Adjustment: \u00a77An admin has adjusted your listing price from \u00a7a$%.2f \u00a77to \u00a7a$%.2f", oldPrice, newPrice));
        }
        return true;
    }

    public Map<String, Object> getPlayerStatistics(UUID playerId) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalListings", this.plugin.getAuctionManager().getPlayerListingCount(playerId));
        stats.put("activeListings", this.plugin.getAuctionManager().getPlayerActiveListings(playerId).size());
        stats.put("totalShops", this.plugin.getShopManager().getPlayerShopCount(playerId));
        stats.put("totalEarnings", this.plugin.getTradeHistoryManager().getPlayerTotalEarnings(playerId));
        stats.put("totalSpent", this.plugin.getTradeHistoryManager().getPlayerTotalSpent(playerId));
        stats.put("isBanned", this.isPlayerBanned(playerId));
        return stats;
    }

    public Map<String, Object> getMarketStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalListings", this.plugin.getAuctionManager().getAllListings().size());
        stats.put("totalShops", this.plugin.getShopManager().getAllShops().size());
        stats.put("totalBannedPlayers", this.getBannedPlayers().size());
        stats.put("totalTransactions", this.plugin.getTradeHistoryManager().getTotalTransactionCount());
        stats.put("totalVolume", this.plugin.getTradeHistoryManager().getTotalTransactionVolume());
        List recentListings = this.plugin.getAuctionManager().getAllListings().stream().sorted((a, b) -> b.getListedTime().compareTo(a.getListedTime())).limit(10L).collect(Collectors.toList());
        stats.put("recentListings", recentListings);
        return stats;
    }

    public List<Player> getOnlineAdmins() {
        return Bukkit.getOnlinePlayers().stream().filter(this::hasAdminPermission).collect(Collectors.toList());
    }

    public void broadcastToAdmins(String message) {
        String formattedMessage = "\u00a76[Admin] \u00a77" + message;
        this.getOnlineAdmins().forEach(admin -> admin.sendMessage(formattedMessage));
    }

    private void logAdminAction(Player admin, String action) {
        this.lastAdminActions.put(admin.getUniqueId(), System.currentTimeMillis());
        this.plugin.getLogger().info("[ADMIN ACTION] " + admin.getName() + ": " + action);
        this.broadcastToAdmins(admin.getName() + " performed: " + action);
    }

    public List<MarketItem> searchListings(String query) {
        return this.plugin.getAuctionManager().getAllListings().stream().filter(item -> {
            String lowerQuery = query.toLowerCase();
            return item.getItemStack().getType().name().toLowerCase().contains(lowerQuery) || item.getItemStack().hasItemMeta() && item.getItemStack().getItemMeta().hasDisplayName() && item.getItemStack().getItemMeta().getDisplayName().toLowerCase().contains(lowerQuery) || Bukkit.getOfflinePlayer((UUID)item.getSellerId()).getName().toLowerCase().contains(lowerQuery);
        }).collect(Collectors.toList());
    }

    public List<PlayerShop> searchShops(String query) {
        return this.plugin.getShopManager().getAllShops().stream().filter(shop -> {
            String lowerQuery = query.toLowerCase();
            return shop.getName().toLowerCase().contains(lowerQuery) || shop.getDescription().toLowerCase().contains(lowerQuery) || shop.getOwnerName().toLowerCase().contains(lowerQuery);
        }).collect(Collectors.toList());
    }

    public static enum AdminAction {
        DELETE_LISTING,
        DELETE_SHOP,
        BAN_PLAYER,
        UNBAN_PLAYER,
        CLEAR_PLAYER_DATA,
        FORCE_EXPIRE,
        ADJUST_PRICE,
        REFUND_PLAYER;

    }
}

