/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ChatInputManager
implements Listener {
    private final Map<UUID, InputRequest> pendingInputs = new ConcurrentHashMap<UUID, InputRequest>();
    private final Plugin plugin;

    public ChatInputManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public void waitForInput(Player player, Consumer<String> callback) {
        this.waitForInput(player, callback, 60);
    }

    public void waitForInput(Player player, Consumer<String> callback, int timeoutSeconds) {
        if (this.hasInput(player)) {
            player.sendMessage("\u00a7cYou already have a pending input request. Type 'cancel' to cancel it.");
            return;
        }
        UUID playerId = player.getUniqueId();
        InputRequest request = new InputRequest(callback, System.currentTimeMillis());
        this.pendingInputs.put(playerId, request);
        this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> {
            if (this.pendingInputs.remove(playerId) != null) {
                player.sendMessage("\u00a7cInput request timed out.");
            }
        }, (long)timeoutSeconds * 20L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        InputRequest request = this.pendingInputs.remove(player.getUniqueId());
        if (request != null) {
            event.setCancelled(true);
            String input = event.getMessage();
            if (input.equalsIgnoreCase("cancel")) {
                player.sendMessage("\u00a7eInput cancelled.");
                return;
            }
            this.plugin.getServer().getScheduler().runTask(this.plugin, () -> request.callback.accept(input));
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.pendingInputs.remove(event.getPlayer().getUniqueId());
    }

    public void cancelInput(Player player) {
        this.pendingInputs.remove(player.getUniqueId());
    }

    public boolean hasInput(Player player) {
        return this.pendingInputs.containsKey(player.getUniqueId());
    }

    private static class InputRequest {
        final Consumer<String> callback;
        final long timestamp;

        InputRequest(Consumer<String> callback, long timestamp) {
            this.callback = callback;
            this.timestamp = timestamp;
        }
    }
}

