/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.MarketItem;
import MPP.marketPlacePlus.models.PlayerShop;
import MPP.marketPlacePlus.models.Report;
import MPP.marketPlacePlus.utils.ItemUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DiscordWebhookManager {
    private final MarketPlacePlus plugin;
    private final Map<String, Long> lastNotificationTime;
    private final long NOTIFICATION_COOLDOWN = 1000L;

    public DiscordWebhookManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.lastNotificationTime = new ConcurrentHashMap<String, Long>();
    }

    public void sendAuctionSaleNotification(MarketItem item, Player buyer) {
        if (!this.plugin.getConfig().getBoolean("discord.enabled", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("discord.notify-auction-sales", true)) {
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("discord.webhook-url", "");
        if (webhookUrl.isEmpty()) {
            this.plugin.getLogger().warning("Discord webhook URL is empty!");
            return;
        }
        if (!this.checkCooldown("auction_" + item.getId())) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject embed = this.createAuctionEmbed(item, buyer);
                this.sendWebhook(webhookUrl, embed);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void sendListingNotification(MarketItem item, Player seller) {
        if (!this.plugin.getConfig().getBoolean("discord.enabled", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("discord.notify-new-listings", true)) {
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("discord.webhook-url", "");
        if (webhookUrl.isEmpty()) {
            return;
        }
        if (!this.checkCooldown("listing_" + item.getId())) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject embed = this.createListingEmbed(item, seller);
                this.sendWebhook(webhookUrl, embed);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void sendAuctionCreatedNotification(MarketItem item, Player seller) {
        if (!this.plugin.getConfig().getBoolean("discord.enabled", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("discord.notify-new-auctions", true)) {
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("discord.webhook-url", "");
        if (webhookUrl.isEmpty()) {
            return;
        }
        if (!this.checkCooldown("auction_create_" + item.getId())) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject embed = this.createAuctionCreatedEmbed(item, seller);
                this.sendWebhook(webhookUrl, embed);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void sendShopSaleNotification(PlayerShop shop, Player buyer, ItemStack item, double price, int amount) {
        if (!this.plugin.getConfig().getBoolean("discord.enabled", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("discord.notify-shop-sales", false)) {
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("discord.webhook-url", "");
        if (webhookUrl.isEmpty()) {
            return;
        }
        String cooldownKey = "shop_" + shop.getId() + "_" + String.valueOf(buyer.getUniqueId()) + "_" + String.valueOf(item.getType());
        if (!this.checkCooldown(cooldownKey)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject embed = this.createShopEmbed(shop, buyer, item, price, amount);
                this.sendWebhook(webhookUrl, embed);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send Discord webhook: " + e.getMessage());
            }
        });
    }

    private JsonObject createAuctionEmbed(MarketItem item, Player buyer) {
        JsonObject embed = new JsonObject();
        embed.addProperty("title", item.isAuction() ? "\ud83c\udf89 Auction Won!" : "\ud83d\udcb8 Item Sold!");
        embed.addProperty("color", (Number)this.getEmbedColor("auction"));
        embed.addProperty("timestamp", Instant.now().toString());
        embed.addProperty("description", String.format("**%s** has purchased an item from **%s**!", buyer.getName(), item.getSellerName()));
        JsonArray fields = new JsonArray();
        JsonObject itemField = new JsonObject();
        itemField.addProperty("name", "\ud83d\udce6 Item");
        itemField.addProperty("value", "```" + this.getItemDisplayName(item.getItemStack()) + "```");
        itemField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)itemField);
        JsonObject amountField = new JsonObject();
        amountField.addProperty("name", "\ud83d\udcca Amount");
        amountField.addProperty("value", "```" + item.getItemStack().getAmount() + "x```");
        amountField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)amountField);
        JsonObject priceField = new JsonObject();
        priceField.addProperty("name", "\ud83d\udcb0 " + (item.isAuction() ? "Final Bid" : "Price"));
        priceField.addProperty("value", "```" + this.plugin.getEconomyManager().formatMoney(item.getPrice()) + "```");
        priceField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)priceField);
        JsonObject sellerField = new JsonObject();
        sellerField.addProperty("name", "\ud83d\udce4 Seller");
        sellerField.addProperty("value", "```" + item.getSellerName() + "```");
        sellerField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)sellerField);
        JsonObject buyerField = new JsonObject();
        buyerField.addProperty("name", "\ud83d\udce5 Buyer");
        buyerField.addProperty("value", "```" + buyer.getName() + "```");
        buyerField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)buyerField);
        JsonObject typeField = new JsonObject();
        typeField.addProperty("name", "\ud83c\udff7\ufe0f Sale Type");
        typeField.addProperty("value", item.isAuction() ? "**Auction** \ud83d\udd28" : "**Instant Buy** \ud83d\uded2");
        typeField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)typeField);
        ItemMeta meta = item.getItemStack().getItemMeta();
        if (meta != null) {
            if (!meta.getEnchants().isEmpty()) {
                StringBuilder enchants = new StringBuilder();
                for (Map.Entry entry : meta.getEnchants().entrySet()) {
                    if (enchants.length() > 0) {
                        enchants.append("\n");
                    }
                    enchants.append("\u2022 ").append(this.beautifyEnchantment((Enchantment)entry.getKey())).append(" **").append(entry.getValue()).append("**");
                }
                JsonObject enchantField = new JsonObject();
                enchantField.addProperty("name", "\u2728 Enchantments");
                enchantField.addProperty("value", enchants.toString());
                enchantField.addProperty("inline", Boolean.valueOf(false));
                fields.add((JsonElement)enchantField);
            }
            if (meta.hasLore() && meta.getLore() != null && !meta.getLore().isEmpty()) {
                StringBuilder lore = new StringBuilder();
                for (String line : meta.getLore()) {
                    String cleanLine;
                    if (lore.length() > 0) {
                        lore.append("\n");
                    }
                    if ((cleanLine = line.replaceAll("\u00a7[0-9a-fk-or]", "")).trim().isEmpty()) continue;
                    lore.append("\u203a ").append(cleanLine);
                }
                if (lore.length() > 0 && lore.length() <= 1024) {
                    JsonObject loreField = new JsonObject();
                    loreField.addProperty("name", "\ud83d\udccb Item Details");
                    loreField.addProperty("value", "```" + lore.toString() + "```");
                    loreField.addProperty("inline", Boolean.valueOf(false));
                    fields.add((JsonElement)loreField);
                }
            }
        }
        embed.add("fields", (JsonElement)fields);
        JsonObject footer = new JsonObject();
        footer.addProperty("text", "MarketPlace+ | " + this.plugin.getConfig().getString("server-name", "Server"));
        embed.add("footer", (JsonElement)footer);
        return embed;
    }

    private JsonObject createListingEmbed(MarketItem item, Player seller) {
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\ud83d\udce2 New Market Listing!");
        embed.addProperty("color", (Number)this.getEmbedColor("listing"));
        embed.addProperty("timestamp", Instant.now().toString());
        embed.addProperty("description", String.format("**%s** has listed an item for sale!", seller.getName()));
        JsonArray fields = new JsonArray();
        JsonObject itemField = new JsonObject();
        itemField.addProperty("name", "\ud83d\udce6 Item");
        itemField.addProperty("value", "```" + this.getItemDisplayName(item.getItemStack()) + "```");
        itemField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)itemField);
        JsonObject amountField = new JsonObject();
        amountField.addProperty("name", "\ud83d\udcca Amount");
        amountField.addProperty("value", "```" + item.getItemStack().getAmount() + "x```");
        amountField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)amountField);
        JsonObject priceField = new JsonObject();
        priceField.addProperty("name", "\ud83d\udcb0 Price");
        priceField.addProperty("value", "```" + this.plugin.getEconomyManager().formatMoney(item.getPrice()) + "```");
        priceField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)priceField);
        JsonObject sellerField = new JsonObject();
        sellerField.addProperty("name", "\ud83d\udc64 Seller");
        sellerField.addProperty("value", "```" + seller.getName() + "```");
        sellerField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)sellerField);
        JsonObject categoryField = new JsonObject();
        categoryField.addProperty("name", "\ud83c\udff7\ufe0f Category");
        categoryField.addProperty("value", this.formatCategory(item.getCategory()));
        categoryField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)categoryField);
        JsonObject expiresField = new JsonObject();
        expiresField.addProperty("name", "\u23f0 Expires In");
        expiresField.addProperty("value", "```" + this.formatTimeRemaining(item.getExpiryTime()) + "```");
        expiresField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)expiresField);
        ItemMeta meta = item.getItemStack().getItemMeta();
        if (meta != null && !meta.getEnchants().isEmpty()) {
            StringBuilder enchants = new StringBuilder();
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                if (enchants.length() > 0) {
                    enchants.append("\n");
                }
                enchants.append("\u2022 ").append(this.beautifyEnchantment((Enchantment)entry.getKey())).append(" **").append(entry.getValue()).append("**");
            }
            JsonObject enchantField = new JsonObject();
            enchantField.addProperty("name", "\u2728 Enchantments");
            enchantField.addProperty("value", enchants.toString());
            enchantField.addProperty("inline", Boolean.valueOf(false));
            fields.add((JsonElement)enchantField);
        }
        embed.add("fields", (JsonElement)fields);
        JsonObject footer = new JsonObject();
        footer.addProperty("text", "MarketPlace+ | " + this.plugin.getConfig().getString("server-name", "Server"));
        embed.add("footer", (JsonElement)footer);
        return embed;
    }

    private JsonObject createAuctionCreatedEmbed(MarketItem item, Player seller) {
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\ud83d\udd28 New Auction Started!");
        embed.addProperty("color", (Number)this.getEmbedColor("auction_new"));
        embed.addProperty("timestamp", Instant.now().toString());
        embed.addProperty("description", String.format("**%s** has started a new auction! Place your bids now!", seller.getName()));
        JsonArray fields = new JsonArray();
        JsonObject itemField = new JsonObject();
        itemField.addProperty("name", "\ud83d\udce6 Item");
        itemField.addProperty("value", "```" + this.getItemDisplayName(item.getItemStack()) + "```");
        itemField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)itemField);
        JsonObject amountField = new JsonObject();
        amountField.addProperty("name", "\ud83d\udcca Amount");
        amountField.addProperty("value", "```" + item.getItemStack().getAmount() + "x```");
        amountField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)amountField);
        JsonObject startingBidField = new JsonObject();
        startingBidField.addProperty("name", "\ud83d\udcb5 Starting Bid");
        startingBidField.addProperty("value", "```" + this.plugin.getEconomyManager().formatMoney(item.getStartingBid()) + "```");
        startingBidField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)startingBidField);
        JsonObject bidIncrementField = new JsonObject();
        bidIncrementField.addProperty("name", "\ud83d\udcc8 Min Increment");
        bidIncrementField.addProperty("value", "```" + this.plugin.getEconomyManager().formatMoney(item.getBidIncrement()) + "```");
        bidIncrementField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)bidIncrementField);
        JsonObject sellerField = new JsonObject();
        sellerField.addProperty("name", "\ud83d\udc64 Auctioneer");
        sellerField.addProperty("value", "```" + seller.getName() + "```");
        sellerField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)sellerField);
        JsonObject durationField = new JsonObject();
        durationField.addProperty("name", "\u23f0 Duration");
        durationField.addProperty("value", "```" + this.formatTimeRemaining(item.getExpiryTime()) + "```");
        durationField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)durationField);
        ItemMeta meta = item.getItemStack().getItemMeta();
        if (meta != null && !meta.getEnchants().isEmpty()) {
            StringBuilder enchants = new StringBuilder();
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                if (enchants.length() > 0) {
                    enchants.append("\n");
                }
                enchants.append("\u2022 ").append(this.beautifyEnchantment((Enchantment)entry.getKey())).append(" **").append(entry.getValue()).append("**");
            }
            JsonObject enchantField = new JsonObject();
            enchantField.addProperty("name", "\u2728 Enchantments");
            enchantField.addProperty("value", enchants.toString());
            enchantField.addProperty("inline", Boolean.valueOf(false));
            fields.add((JsonElement)enchantField);
        }
        embed.add("fields", (JsonElement)fields);
        JsonObject footer = new JsonObject();
        footer.addProperty("text", "MarketPlace+ | " + this.plugin.getConfig().getString("server-name", "Server"));
        embed.add("footer", (JsonElement)footer);
        return embed;
    }

    private JsonObject createShopEmbed(PlayerShop shop, Player buyer, ItemStack item, double price, int amount) {
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "Player Shop Sale!");
        embed.addProperty("color", (Number)this.getEmbedColor("shop"));
        embed.addProperty("timestamp", Instant.now().toString());
        JsonArray fields = new JsonArray();
        JsonObject itemField = new JsonObject();
        itemField.addProperty("name", "Item");
        itemField.addProperty("value", this.getItemDisplayName(item));
        itemField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)itemField);
        JsonObject amountField = new JsonObject();
        amountField.addProperty("name", "Amount");
        amountField.addProperty("value", String.valueOf(amount));
        amountField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)amountField);
        JsonObject priceField = new JsonObject();
        priceField.addProperty("name", "Total Price");
        priceField.addProperty("value", this.plugin.getEconomyManager().formatMoney(price));
        priceField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)priceField);
        JsonObject shopField = new JsonObject();
        shopField.addProperty("name", "Shop");
        shopField.addProperty("value", shop.getDisplayName());
        shopField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)shopField);
        JsonObject ownerField = new JsonObject();
        ownerField.addProperty("name", "Shop Owner");
        ownerField.addProperty("value", shop.getOwnerName());
        ownerField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)ownerField);
        JsonObject buyerField = new JsonObject();
        buyerField.addProperty("name", "Buyer");
        buyerField.addProperty("value", buyer.getName());
        buyerField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)buyerField);
        JsonObject unitPriceField = new JsonObject();
        unitPriceField.addProperty("name", "Price per Item");
        unitPriceField.addProperty("value", this.plugin.getEconomyManager().formatMoney(price / (double)amount));
        unitPriceField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)unitPriceField);
        ItemMeta meta = item.getItemMeta();
        if (meta != null && !meta.getEnchants().isEmpty()) {
            StringBuilder enchants = new StringBuilder();
            for (Map.Entry entry : meta.getEnchants().entrySet()) {
                if (enchants.length() > 0) {
                    enchants.append("\n");
                }
                enchants.append("\u2022 ").append(this.beautifyEnchantment((Enchantment)entry.getKey())).append(" **").append(entry.getValue()).append("**");
            }
            JsonObject enchantField = new JsonObject();
            enchantField.addProperty("name", "\u2728 Enchantments");
            enchantField.addProperty("value", enchants.toString());
            enchantField.addProperty("inline", Boolean.valueOf(false));
            fields.add((JsonElement)enchantField);
        }
        embed.add("fields", (JsonElement)fields);
        JsonObject footer = new JsonObject();
        footer.addProperty("text", "MarketPlace+ | " + this.plugin.getConfig().getString("server-name", "Server"));
        embed.add("footer", (JsonElement)footer);
        return embed;
    }

    private void sendWebhook(String webhookUrl, JsonObject embed) throws IOException {
        URL url = new URL(webhookUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        JsonObject payload = new JsonObject();
        JsonArray embeds = new JsonArray();
        embeds.add((JsonElement)embed);
        payload.add("embeds", (JsonElement)embeds);
        payload.addProperty("username", this.plugin.getConfig().getString("discord.bot-name", "MarketPlace+"));
        String avatarUrl = this.plugin.getConfig().getString("discord.bot-avatar", "");
        if (!avatarUrl.isEmpty()) {
            payload.addProperty("avatar_url", avatarUrl);
        }
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = payload.toString().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode != 204) {
            this.plugin.getLogger().warning("Discord webhook returned response code: " + responseCode);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream() != null ? connection.getErrorStream() : connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
                this.plugin.getLogger().warning("Discord response: " + response.toString());
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not read Discord response: " + e.getMessage());
            }
        }
        connection.disconnect();
    }

    private boolean checkCooldown(String key) {
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastNotificationTime.get(key);
        if (lastTime != null && currentTime - lastTime < 1000L) {
            return false;
        }
        this.lastNotificationTime.put(key, currentTime);
        this.cleanupOldCooldowns();
        return true;
    }

    private void cleanupOldCooldowns() {
        if (this.lastNotificationTime.size() > 1000) {
            long cutoffTime = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
            this.lastNotificationTime.entrySet().removeIf(entry -> (Long)entry.getValue() < cutoffTime);
        }
    }

    private String getItemDisplayName(ItemStack item) {
        String name = ItemUtils.getItemName(item);
        if (name.contains("\u00a7")) {
            name = name.replaceAll("\u00a7[0-9a-fk-or]", "");
        }
        return name;
    }

    private String formatCategory(String category) {
        switch (category) {
            case "WEAPONS_TOOLS": {
                return "\u2694\ufe0f Weapons & Tools";
            }
            case "ARMOR": {
                return "\ud83d\udee1\ufe0f Armor";
            }
            case "CONSUMABLES": {
                return "\ud83c\udf4e Consumables";
            }
            case "BLOCKS": {
                return "\ud83e\uddf1 Blocks";
            }
            case "MATERIALS": {
                return "\ud83d\udce6 Materials";
            }
            case "DECORATIVE": {
                return "\ud83c\udfa8 Decorative";
            }
            case "REDSTONE": {
                return "\ud83d\udd34 Redstone";
            }
            case "SPECIAL_ITEMS": {
                return "\u2728 Special Items";
            }
            case "ENCHANTED_BOOKS": {
                return "\ud83d\udcda Enchanted Books";
            }
        }
        return "\ud83d\udccb " + category.replace("_", " ");
    }

    private String formatTimeRemaining(LocalDateTime expiryTime) {
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(expiryTime)) {
            return "Expired";
        }
        Duration duration = Duration.between(now, expiryTime);
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        if (days > 0L) {
            return String.format("%dd %dh", days, hours);
        }
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%dm", minutes);
        }
        return "<1m";
    }

    private String beautifyEnchantment(Enchantment enchantment) {
        String name = enchantment.getKey().getKey().replace("_", " ");
        StringBuilder result = new StringBuilder();
        for (String word : name.split(" ")) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1).toLowerCase());
        }
        return result.toString();
    }

    private int getEmbedColor(String type) {
        switch (type.toLowerCase()) {
            case "auction": {
                return 9055202;
            }
            case "auction_new": {
                return 16753920;
            }
            case "shop": {
                return 3329330;
            }
            case "listing": {
                return 1974815;
            }
        }
        return 4278245;
    }

    public void sendReportNotification(Report report) {
        if (!this.plugin.getConfig().getBoolean("discord.enabled", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("discord.send-reports", false)) {
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("discord.report-webhook-url", this.plugin.getConfig().getString("discord.webhook-url", ""));
        if (webhookUrl.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                JsonObject embed = this.createReportEmbed(report);
                this.sendWebhook(webhookUrl, embed);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to send report webhook: " + e.getMessage());
            }
        });
    }

    private JsonObject createReportEmbed(Report report) {
        JsonObject embed = new JsonObject();
        embed.addProperty("title", "\ud83d\udea8 New Report Submitted");
        embed.addProperty("color", (Number)15158332);
        embed.addProperty("timestamp", Instant.now().toString());
        JsonArray fields = new JsonArray();
        JsonObject reporterField = new JsonObject();
        reporterField.addProperty("name", "\ud83d\udc64 Reporter");
        reporterField.addProperty("value", "```" + report.getReporterName() + "```");
        reporterField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)reporterField);
        JsonObject reportedField = new JsonObject();
        reportedField.addProperty("name", "\u26a0\ufe0f Reported Player");
        reportedField.addProperty("value", "```" + report.getReportedName() + "```");
        reportedField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)reportedField);
        JsonObject typeField = new JsonObject();
        typeField.addProperty("name", "\ud83d\udccb Report Type");
        typeField.addProperty("value", "```" + report.getReportType().name() + "```");
        typeField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)typeField);
        JsonObject reasonField = new JsonObject();
        reasonField.addProperty("name", "\ud83d\udcdd Reason");
        reasonField.addProperty("value", report.getReason());
        reasonField.addProperty("inline", Boolean.valueOf(false));
        fields.add((JsonElement)reasonField);
        if (report.getDetails() != null && !report.getDetails().isEmpty()) {
            JsonObject detailsField = new JsonObject();
            detailsField.addProperty("name", "\ud83d\udcc4 Additional Details");
            detailsField.addProperty("value", "```" + report.getDetails() + "```");
            detailsField.addProperty("inline", Boolean.valueOf(false));
            fields.add((JsonElement)detailsField);
        }
        JsonObject idField = new JsonObject();
        idField.addProperty("name", "\ud83c\udd94 Report ID");
        idField.addProperty("value", "`" + report.getId().substring(0, 8) + "`");
        idField.addProperty("inline", Boolean.valueOf(true));
        fields.add((JsonElement)idField);
        embed.add("fields", (JsonElement)fields);
        JsonObject footer = new JsonObject();
        footer.addProperty("text", "MarketPlacePlus Report System");
        embed.add("footer", (JsonElement)footer);
        return embed;
    }
}

