/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NotificationManager {
    private final MarketPlacePlus plugin;
    private final Map<UUID, BossBar> activeBossBars;
    private final Map<UUID, Long> cooldowns;

    public NotificationManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.activeBossBars = new ConcurrentHashMap<UUID, BossBar>();
        this.cooldowns = new ConcurrentHashMap<UUID, Long>();
    }

    public void sendNotification(Player player, String message, NotificationType type) {
        if (!this.plugin.getConfig().getBoolean("notifications.enabled", true)) {
            player.sendMessage(message);
            return;
        }
        if (this.plugin.getConfig().getBoolean("notifications.chat", true)) {
            player.sendMessage(message);
        }
        if (this.plugin.getConfig().getBoolean("notifications.action-bar", true)) {
            this.sendActionBar(player, message);
        }
        if (this.plugin.getConfig().getBoolean("notifications.sound", true)) {
            this.playSound(player, type.sound);
        }
    }

    public void sendTitle(Player player, String title, String subtitle, NotificationType type) {
        if (!this.plugin.getConfig().getBoolean("notifications.titles", true)) {
            return;
        }
        int fadeIn = this.plugin.getConfig().getInt("notifications.title-fade-in", 10);
        int stay = this.plugin.getConfig().getInt("notifications.title-stay", 60);
        int fadeOut = this.plugin.getConfig().getInt("notifications.title-fade-out", 10);
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
        if (this.plugin.getConfig().getBoolean("notifications.sound", true)) {
            this.playSound(player, type.sound);
        }
    }

    public void sendBossBar(Player player, String message, NotificationType type, int durationSeconds) {
        if (!this.plugin.getConfig().getBoolean("notifications.boss-bar", true)) {
            player.sendMessage(message);
            return;
        }
        this.removeBossBar(player);
        BossBar bossBar = Bukkit.createBossBar((String)message, (BarColor)type.color, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        bossBar.addPlayer(player);
        bossBar.setProgress(1.0);
        this.activeBossBars.put(player.getUniqueId(), bossBar);
        if (durationSeconds > 0) {
            int totalTicks = durationSeconds * 20;
            double decrementAmount = 1.0 / (double)totalTicks;
            Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task -> {
                double progress = bossBar.getProgress() - decrementAmount;
                if (progress <= 0.0 || !player.isOnline()) {
                    this.removeBossBar(player);
                    task.cancel();
                } else {
                    bossBar.setProgress(progress);
                }
            }, 1L, 1L);
        }
    }

    public void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    public void playSound(Player player, Sound sound) {
        float volume = (float)this.plugin.getConfig().getDouble("notifications.sound-volume", 1.0);
        float pitch = (float)this.plugin.getConfig().getDouble("notifications.sound-pitch", 1.0);
        player.playSound(player.getLocation(), sound, volume, pitch);
    }

    public void removeBossBar(Player player) {
        BossBar bossBar = this.activeBossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    public void removeAllBossBars() {
        this.activeBossBars.values().forEach(BossBar::removeAll);
        this.activeBossBars.clear();
    }

    public void notifySale(Player seller, Player buyer, String itemName, double price) {
        if (seller != null && seller.isOnline()) {
            String sellerMsg = String.format("\u00a7a\u00a7lSOLD! \u00a7f%s \u00a7abought your \u00a7f%s \u00a7afor \u00a76$%.2f", buyer.getName(), itemName, price);
            this.sendTitle(seller, "\u00a7a\u00a7lITEM SOLD!", String.format("\u00a7f%s \u00a77for \u00a76$%.2f", itemName, price), NotificationType.MONEY);
            this.sendBossBar(seller, sellerMsg, NotificationType.MONEY, 5);
        }
        if (buyer != null && buyer.isOnline()) {
            String buyerMsg = String.format("\u00a7a\u00a7lPURCHASED! \u00a7aYou bought \u00a7f%s \u00a7afor \u00a76$%.2f", itemName, price);
            this.sendTitle(buyer, "\u00a7a\u00a7lITEM PURCHASED!", String.format("\u00a7f%s \u00a77for \u00a76$%.2f", itemName, price), NotificationType.SUCCESS);
        }
    }

    public void notifyAuctionWin(Player winner, String itemName, double price) {
        String message = String.format("\u00a76\u00a7lAUCTION WON! \u00a7eYou won \u00a7f%s \u00a7efor \u00a76$%.2f", itemName, price);
        this.sendTitle(winner, "\u00a76\u00a7lAUCTION WON!", String.format("\u00a7f%s \u00a77for \u00a76$%.2f", itemName, price), NotificationType.AUCTION_WIN);
        this.sendBossBar(winner, message, NotificationType.AUCTION_WIN, 10);
    }

    public void notifyOutbid(Player player, String itemName, double newBid) {
        String message = String.format("\u00a7c\u00a7lOUTBID! \u00a7eSomeone bid \u00a76$%.2f \u00a7eon \u00a7f%s", newBid, itemName);
        this.sendTitle(player, "\u00a7c\u00a7lOUTBID!", String.format("\u00a7f%s \u00a77- New bid: \u00a76$%.2f", itemName, newBid), NotificationType.AUCTION_OUTBID);
        this.sendBossBar(player, message, NotificationType.AUCTION_OUTBID, 5);
    }

    public void notifyShopSale(Player shopOwner, String buyerName, String itemName, int amount, double totalPrice) {
        if (!shopOwner.isOnline()) {
            return;
        }
        String message = String.format("\u00a7a\u00a7lSHOP SALE! \u00a7f%s \u00a7abought \u00a7fx%d %s \u00a7afor \u00a76$%.2f", buyerName, amount, itemName, totalPrice);
        this.sendTitle(shopOwner, "\u00a7a\u00a7lSHOP SALE!", String.format("\u00a7fx%d %s \u00a77- \u00a76$%.2f", amount, itemName, totalPrice), NotificationType.SHOP_SALE);
        this.sendActionBar(shopOwner, message);
    }

    public void notifyCollectionReady(Player player, int itemCount) {
        String message = String.format("\u00a76\u00a7lCOLLECTION BOX \u00a7eYou have \u00a7f%d \u00a7eitems ready to collect!", itemCount);
        this.sendBossBar(player, message, NotificationType.INFO, 10);
        this.sendActionBar(player, "\u00a7eUse \u00a76/market collect \u00a7eto retrieve your items!");
    }

    public void notifyListingExpired(Player player, String itemName) {
        String message = String.format("\u00a7e\u00a7lLISTING EXPIRED \u00a77Your \u00a7f%s \u00a77has been moved to collection box", itemName);
        this.sendNotification(player, message, NotificationType.WARNING);
    }

    public void broadcast(String message, NotificationType type) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.sendNotification(player, message, type);
        }
    }

    public void broadcastInWorld(World world, String message, NotificationType type) {
        for (Player player : world.getPlayers()) {
            this.sendNotification(player, message, type);
        }
    }

    public boolean isOnCooldown(Player player, String cooldownKey, int seconds) {
        String key = String.valueOf(player.getUniqueId()) + ":" + cooldownKey;
        Long lastTime = this.cooldowns.get(player.getUniqueId());
        if (lastTime == null) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            return false;
        }
        long timePassed = System.currentTimeMillis() - lastTime;
        if (timePassed < (long)seconds * 1000L) {
            return true;
        }
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        return false;
    }

    public void cleanup() {
        this.removeAllBossBars();
        this.cooldowns.clear();
    }

    public static enum NotificationType {
        SUCCESS(BarColor.GREEN, Sound.ENTITY_PLAYER_LEVELUP),
        ERROR(BarColor.RED, Sound.ENTITY_VILLAGER_NO),
        WARNING(BarColor.YELLOW, Sound.BLOCK_NOTE_BLOCK_PLING),
        INFO(BarColor.BLUE, Sound.BLOCK_NOTE_BLOCK_CHIME),
        MONEY(BarColor.GREEN, Sound.ENTITY_EXPERIENCE_ORB_PICKUP),
        AUCTION_WIN(BarColor.GREEN, Sound.UI_TOAST_CHALLENGE_COMPLETE),
        AUCTION_OUTBID(BarColor.RED, Sound.ENTITY_VILLAGER_HURT),
        SHOP_SALE(BarColor.GREEN, Sound.ENTITY_VILLAGER_YES),
        ITEM_COLLECTED(BarColor.BLUE, Sound.ENTITY_ITEM_PICKUP);

        private final BarColor color;
        private final Sound sound;

        private NotificationType(BarColor color, Sound sound) {
            this.color = color;
            this.sound = sound;
        }
    }
}

