/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.managers;

import MPP.marketPlacePlus.MarketPlacePlus;
import MPP.marketPlacePlus.models.PriceHistory;
import MPP.marketPlacePlus.utils.ItemUtils;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.ItemStack;

public class PriceManager {
    private final MarketPlacePlus plugin;
    private final Map<String, PriceHistory> priceHistories;

    public PriceManager(MarketPlacePlus plugin) {
        this.plugin = plugin;
        this.priceHistories = new ConcurrentHashMap<String, PriceHistory>();
    }

    public void recordPrice(ItemStack item, double price, int quantity) {
        String itemKey = ItemUtils.getItemKey(item);
        PriceHistory history = this.priceHistories.computeIfAbsent(itemKey, PriceHistory::new);
        history.addPricePoint(price / (double)quantity, quantity, LocalDateTime.now());
        this.plugin.getDatabaseManager().savePriceHistory(history);
    }

    public double getLastPrice(String itemKey) {
        PriceHistory history = this.priceHistories.get(itemKey);
        return history != null ? history.getLastPrice() : 0.0;
    }

    public double getAveragePrice(String itemKey) {
        PriceHistory history = this.priceHistories.get(itemKey);
        return history != null ? history.getAveragePrice() : 0.0;
    }

    public PriceHistory getPriceHistory(String itemKey) {
        return this.priceHistories.get(itemKey);
    }

    public void loadPriceHistories() {
        this.priceHistories.clear();
        Map<String, PriceHistory> loaded = this.plugin.getDatabaseManager().loadAllPriceHistories();
        this.priceHistories.putAll(loaded);
    }

    public void savePriceHistories() {
        for (PriceHistory history : this.priceHistories.values()) {
            this.plugin.getDatabaseManager().savePriceHistory(history);
        }
    }
}

