/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class MarketItem {
    private final String id;
    private final UUID sellerId;
    private final String sellerName;
    private final ItemStack itemStack;
    private double price;
    private final LocalDateTime listedTime;
    private LocalDateTime expiryTime;
    private final String category;
    private final String serializedItem;
    private boolean sold;
    private UUID buyerId;
    private String buyerName;
    private LocalDateTime soldTime;
    private boolean isAuction;
    private double startingBid;
    private double currentBid;
    private double bidIncrement;
    private UUID highestBidderId;
    private String highestBidderName;
    private int totalBids;

    public MarketItem(String id, UUID sellerId, String sellerName, ItemStack itemStack, double price, LocalDateTime listedTime, LocalDateTime expiryTime, String category, String serializedItem) {
        this.id = id;
        this.sellerId = sellerId;
        this.sellerName = sellerName;
        this.itemStack = itemStack;
        this.price = price;
        this.listedTime = listedTime;
        this.expiryTime = expiryTime;
        this.category = category;
        this.serializedItem = serializedItem;
        this.sold = false;
        this.isAuction = false;
        this.startingBid = price;
        this.currentBid = 0.0;
        this.bidIncrement = 0.0;
        this.totalBids = 0;
    }

    public void markAsSold(UUID buyerId, String buyerName) {
        this.sold = true;
        this.buyerId = buyerId;
        this.buyerName = buyerName;
        this.soldTime = LocalDateTime.now();
    }

    public boolean isExpired() {
        return LocalDateTime.now().isAfter(this.expiryTime);
    }

    public String getId() {
        return this.id;
    }

    public UUID getSellerId() {
        return this.sellerId;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public double getPrice() {
        return this.price;
    }

    public LocalDateTime getListedTime() {
        return this.listedTime;
    }

    public LocalDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSerializedItem() {
        return this.serializedItem;
    }

    public boolean isSold() {
        return this.sold;
    }

    public UUID getBuyerId() {
        return this.buyerId;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public LocalDateTime getSoldTime() {
        return this.soldTime;
    }

    public void enableAuction(double startingBid, double bidIncrement) {
        this.isAuction = true;
        this.startingBid = startingBid;
        this.currentBid = startingBid;
        this.bidIncrement = bidIncrement;
    }

    public boolean placeBid(UUID bidderId, String bidderName, double bidAmount) {
        if (!this.isAuction || bidAmount < this.getMinimumBid()) {
            return false;
        }
        this.highestBidderId = bidderId;
        this.highestBidderName = bidderName;
        this.currentBid = bidAmount;
        ++this.totalBids;
        return true;
    }

    public double getMinimumBid() {
        return this.currentBid > 0.0 ? this.currentBid + this.bidIncrement : this.startingBid;
    }

    public boolean isAuction() {
        return this.isAuction;
    }

    public double getStartingBid() {
        return this.startingBid;
    }

    public double getCurrentBid() {
        return this.currentBid;
    }

    public double getBidIncrement() {
        return this.bidIncrement;
    }

    public UUID getHighestBidderId() {
        return this.highestBidderId;
    }

    public String getHighestBidderName() {
        return this.highestBidderName;
    }

    public int getTotalBids() {
        return this.totalBids;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void expire() {
        this.expiryTime = LocalDateTime.now().minusMinutes(1L);
    }

    public UUID getIdAsUUID() {
        return UUID.fromString(this.id);
    }

    public List<UUID> getBidders() {
        ArrayList<UUID> bidders = new ArrayList<UUID>();
        if (this.isAuction && this.highestBidderId != null) {
            bidders.add(this.highestBidderId);
        }
        return bidders;
    }
}

