/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

public class PriceHistory {
    private final String itemKey;
    private final LinkedList<PricePoint> pricePoints;
    private double lastPrice;
    private double averagePrice;
    private double lowestPrice;
    private double highestPrice;
    private int totalTrades;

    public PriceHistory(String itemKey) {
        this.itemKey = itemKey;
        this.pricePoints = new LinkedList();
        this.lastPrice = 0.0;
        this.averagePrice = 0.0;
        this.lowestPrice = Double.MAX_VALUE;
        this.highestPrice = 0.0;
        this.totalTrades = 0;
    }

    public void addPricePoint(double price, int quantity, LocalDateTime time) {
        this.pricePoints.add(new PricePoint(price, quantity, time));
        if (this.pricePoints.size() > 100) {
            this.pricePoints.removeFirst();
        }
        this.lastPrice = price;
        ++this.totalTrades;
        if (price < this.lowestPrice) {
            this.lowestPrice = price;
        }
        if (price > this.highestPrice) {
            this.highestPrice = price;
        }
        this.recalculateAverage();
    }

    private void recalculateAverage() {
        if (this.pricePoints.isEmpty()) {
            this.averagePrice = 0.0;
            return;
        }
        double sum = 0.0;
        int count = 0;
        for (PricePoint point : this.pricePoints) {
            sum += point.getPrice() * (double)point.getQuantity();
            count += point.getQuantity();
        }
        this.averagePrice = count > 0 ? sum / (double)count : 0.0;
    }

    public String getItemKey() {
        return this.itemKey;
    }

    public List<PricePoint> getPricePoints() {
        return new LinkedList<PricePoint>(this.pricePoints);
    }

    public double getLastPrice() {
        return this.lastPrice;
    }

    public double getAveragePrice() {
        return this.averagePrice;
    }

    public double getLowestPrice() {
        return this.lowestPrice == Double.MAX_VALUE ? 0.0 : this.lowestPrice;
    }

    public double getHighestPrice() {
        return this.highestPrice;
    }

    public int getTotalTrades() {
        return this.totalTrades;
    }

    public static class PricePoint {
        private final double price;
        private final int quantity;
        private final LocalDateTime time;

        public PricePoint(double price, int quantity, LocalDateTime time) {
            this.price = price;
            this.quantity = quantity;
            this.time = time;
        }

        public double getPrice() {
            return this.price;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public LocalDateTime getTime() {
            return this.time;
        }
    }
}

