/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.models;

import java.time.LocalDateTime;
import java.util.UUID;

public class Report {
    private final String id;
    private final String reporterId;
    private final String reporterName;
    private final String reportedId;
    private final String reportedName;
    private final ReportType reportType;
    private final String targetId;
    private final String reason;
    private String details;
    private final LocalDateTime reportTime;
    private ReportStatus status;
    private String resolvedBy;
    private LocalDateTime resolvedTime;
    private String resolution;

    public Report(String reporterId, String reporterName, String reportedId, String reportedName, ReportType reportType, String targetId, String reason) {
        this.id = UUID.randomUUID().toString();
        this.reporterId = reporterId;
        this.reporterName = reporterName;
        this.reportedId = reportedId;
        this.reportedName = reportedName;
        this.reportType = reportType;
        this.targetId = targetId;
        this.reason = reason;
        this.reportTime = LocalDateTime.now();
        this.status = ReportStatus.PENDING;
    }

    public Report(String id, String reporterId, String reporterName, String reportedId, String reportedName, ReportType reportType, String targetId, String reason, String details, LocalDateTime reportTime, ReportStatus status, String resolvedBy, LocalDateTime resolvedTime, String resolution) {
        this.id = id;
        this.reporterId = reporterId;
        this.reporterName = reporterName;
        this.reportedId = reportedId;
        this.reportedName = reportedName;
        this.reportType = reportType;
        this.targetId = targetId;
        this.reason = reason;
        this.details = details;
        this.reportTime = reportTime;
        this.status = status;
        this.resolvedBy = resolvedBy;
        this.resolvedTime = resolvedTime;
        this.resolution = resolution;
    }

    public String getId() {
        return this.id;
    }

    public String getReporterId() {
        return this.reporterId;
    }

    public String getReporterName() {
        return this.reporterName;
    }

    public String getReportedId() {
        return this.reportedId;
    }

    public String getReportedName() {
        return this.reportedName;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getReason() {
        return this.reason;
    }

    public String getDetails() {
        return this.details;
    }

    public LocalDateTime getReportTime() {
        return this.reportTime;
    }

    public ReportStatus getStatus() {
        return this.status;
    }

    public String getResolvedBy() {
        return this.resolvedBy;
    }

    public LocalDateTime getResolvedTime() {
        return this.resolvedTime;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setStatus(ReportStatus status) {
        this.status = status;
    }

    public void resolve(String resolvedBy, String resolution) {
        this.status = ReportStatus.RESOLVED;
        this.resolvedBy = resolvedBy;
        this.resolvedTime = LocalDateTime.now();
        this.resolution = resolution;
    }

    public void dismiss(String dismissedBy) {
        this.status = ReportStatus.DISMISSED;
        this.resolvedBy = dismissedBy;
        this.resolvedTime = LocalDateTime.now();
        this.resolution = "Report dismissed";
    }

    public static enum ReportType {
        AUCTION,
        SHOP,
        PLAYER;

    }

    public static enum ReportStatus {
        PENDING,
        REVIEWING,
        RESOLVED,
        DISMISSED;

    }
}

