/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.utils;

import MPP.marketPlacePlus.utils.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AntiScamUtils {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("\u00a7[0-9a-fk-or]");
    private static final Set<String> SUSPICIOUS_PATTERNS = new HashSet<String>(Arrays.asList("\u00a7k", "\u00a7l\u00a7o", "\u00a7m", "\u00a7n\u00a7o\u00a7r", "\u00a70\u00a70", "\u00a7f\u00a7f"));
    private static final Map<String, Long> ITEM_UUID_REGISTRY = new ConcurrentHashMap<String, Long>();
    private static final long UUID_EXPIRY_TIME = 86400000L;

    public static boolean isItemSuspicious(ItemStack item, Plugin plugin) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (AntiScamUtils.hasHiddenText(meta)) {
            AntiScamUtils.logSuspiciousItem(plugin, item, "Hidden text detected");
            return true;
        }
        if (AntiScamUtils.hasIllegalEnchantments(item)) {
            AntiScamUtils.logSuspiciousItem(plugin, item, "Illegal enchantments detected");
            return true;
        }
        if (AntiScamUtils.hasSuspiciousNBT(meta)) {
            AntiScamUtils.logSuspiciousItem(plugin, item, "Suspicious NBT data detected");
            return true;
        }
        if (AntiScamUtils.isMimickingValuableItem(item, meta)) {
            AntiScamUtils.logSuspiciousItem(plugin, item, "Attempting to mimic valuable item");
            return true;
        }
        if (plugin.getConfig().getBoolean("protection.duplicate-uuid-detection", true) && AntiScamUtils.hasDuplicateUUID(item, plugin)) {
            AntiScamUtils.logSuspiciousItem(plugin, item, "Duplicate UUID detected");
            return true;
        }
        return false;
    }

    private static boolean hasHiddenText(ItemMeta meta) {
        if (meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            if (AntiScamUtils.containsSuspiciousPatterns(displayName)) {
                return true;
            }
            if (AntiScamUtils.hasInvisibleCharacters(displayName)) {
                return true;
            }
        }
        if (meta.hasLore()) {
            for (String line : meta.getLore()) {
                if (AntiScamUtils.containsSuspiciousPatterns(line)) {
                    return true;
                }
                if (!AntiScamUtils.hasInvisibleCharacters(line)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsSuspiciousPatterns(String text) {
        for (String pattern : SUSPICIOUS_PATTERNS) {
            if (!text.contains(pattern)) continue;
            return true;
        }
        String stripped = COLOR_CODE_PATTERN.matcher(text).replaceAll("");
        return stripped.trim().isEmpty() && !text.isEmpty();
    }

    private static boolean hasInvisibleCharacters(String text) {
        for (char c : text.toCharArray()) {
            if (Character.isWhitespace(c) && c != ' ') {
                return true;
            }
            if (Character.isISOControl(c)) {
                return true;
            }
            if (c != '\u200b' && c != '\u200c' && c != '\u200d' && c != '\ufeff') continue;
            return true;
        }
        return false;
    }

    private static boolean hasIllegalEnchantments(ItemStack item) {
        Map enchants = item.getEnchantments();
        for (Map.Entry entry : enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (level > enchant.getMaxLevel() * 2) {
                return true;
            }
            if (!enchant.canEnchantItem(item)) {
                return true;
            }
            for (Enchantment other : enchants.keySet()) {
                if (enchant.equals(other) || !enchant.conflictsWith(other)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasSuspiciousNBT(ItemMeta meta) {
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Set keys = container.getKeys();
        if (keys.size() > 50) {
            return true;
        }
        for (NamespacedKey key : keys) {
            String value;
            String keyStr = key.toString().toLowerCase();
            if (keyStr.contains("exploit") || keyStr.contains("dupe") || keyStr.contains("hack") || keyStr.contains("cheat")) {
                return true;
            }
            if (!container.has(key, PersistentDataType.STRING) || (value = (String)container.get(key, PersistentDataType.STRING)) == null || value.length() <= 10000) continue;
            return true;
        }
        return false;
    }

    private static boolean isMimickingValuableItem(ItemStack item, ItemMeta meta) {
        if (!meta.hasDisplayName()) {
            return false;
        }
        String displayName = meta.getDisplayName().toLowerCase();
        String stripped = COLOR_CODE_PATTERN.matcher(displayName).replaceAll("");
        HashMap<String, Material> valuableItems = new HashMap<String, Material>();
        valuableItems.put("dragon egg", Material.DRAGON_EGG);
        valuableItems.put("nether star", Material.NETHER_STAR);
        valuableItems.put("beacon", Material.BEACON);
        valuableItems.put("elytra", Material.ELYTRA);
        valuableItems.put("totem", Material.TOTEM_OF_UNDYING);
        valuableItems.put("netherite", Material.NETHERITE_INGOT);
        for (Map.Entry entry : valuableItems.entrySet()) {
            if (!stripped.contains((CharSequence)entry.getKey()) || item.getType() == entry.getValue() || item.getType() != Material.PAPER && item.getType() != Material.DIRT && item.getType() != Material.STICK && !item.getType().name().contains("GLASS_PANE")) continue;
            return true;
        }
        return false;
    }

    public static ItemStack sanitizeItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return item;
        }
        ItemStack sanitized = item.clone();
        ItemMeta meta = sanitized.getItemMeta();
        if (meta == null) {
            return sanitized;
        }
        if (meta.hasDisplayName()) {
            String displayName = meta.getDisplayName();
            displayName = AntiScamUtils.removeInvisibleCharacters(displayName);
            meta.setDisplayName(displayName);
        }
        if (meta.hasLore()) {
            List lore = meta.getLore();
            ArrayList<String> sanitizedLore = new ArrayList<String>();
            for (String line : lore) {
                sanitizedLore.add(AntiScamUtils.removeInvisibleCharacters(line));
            }
            meta.setLore(sanitizedLore);
        }
        HashMap enchants = new HashMap(sanitized.getEnchantments());
        for (Map.Entry entry : enchants.entrySet()) {
            Enchantment enchant = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (level > enchant.getMaxLevel()) {
                sanitized.removeEnchantment(enchant);
                sanitized.addEnchantment(enchant, enchant.getMaxLevel());
            }
            if (enchant.canEnchantItem(sanitized)) continue;
            sanitized.removeEnchantment(enchant);
        }
        sanitized.setItemMeta(meta);
        return sanitized;
    }

    private static String removeInvisibleCharacters(String text) {
        StringBuilder result = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (Character.isISOControl(c) || c == '\u200b' || c == '\u200c' || c == '\u200d' || c == '\ufeff') continue;
            result.append(c);
        }
        return result.toString();
    }

    private static void logSuspiciousItem(Plugin plugin, ItemStack item, String reason) {
        plugin.getLogger().log(Level.WARNING, "Suspicious item detected: " + reason + " - Type: " + String.valueOf(item.getType()) + ", Name: " + (item.hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : "None"));
    }

    public static boolean verifyItemIntegrity(ItemStack original, ItemStack toCheck) {
        if (original == null || toCheck == null) {
            return false;
        }
        if (original.getType() != toCheck.getType()) {
            return false;
        }
        if (original.getAmount() != toCheck.getAmount()) {
            return false;
        }
        return ItemUtils.isSimilarItem(original, toCheck);
    }

    private static boolean hasDuplicateUUID(ItemStack item, Plugin plugin) {
        NamespacedKey uuidKey;
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (!container.has(uuidKey = new NamespacedKey(plugin, "item_uuid"), PersistentDataType.STRING)) {
            String newUUID = UUID.randomUUID().toString();
            container.set(uuidKey, PersistentDataType.STRING, (Object)newUUID);
            item.setItemMeta(meta);
            AntiScamUtils.registerItemUUID(newUUID);
            return false;
        }
        String itemUUID = (String)container.get(uuidKey, PersistentDataType.STRING);
        if (itemUUID == null || itemUUID.isEmpty()) {
            String newUUID = UUID.randomUUID().toString();
            container.set(uuidKey, PersistentDataType.STRING, (Object)newUUID);
            item.setItemMeta(meta);
            AntiScamUtils.registerItemUUID(newUUID);
            return false;
        }
        AntiScamUtils.cleanExpiredUUIDs();
        if (ITEM_UUID_REGISTRY.containsKey(itemUUID)) {
            return true;
        }
        AntiScamUtils.registerItemUUID(itemUUID);
        return false;
    }

    private static void registerItemUUID(String uuid) {
        ITEM_UUID_REGISTRY.put(uuid, System.currentTimeMillis());
    }

    private static void cleanExpiredUUIDs() {
        long currentTime = System.currentTimeMillis();
        ITEM_UUID_REGISTRY.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 86400000L);
    }

    public static void clearItemUUID(ItemStack item, Plugin plugin) {
        NamespacedKey uuidKey;
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(uuidKey = new NamespacedKey(plugin, "item_uuid"), PersistentDataType.STRING)) {
            String itemUUID = (String)container.get(uuidKey, PersistentDataType.STRING);
            if (itemUUID != null) {
                ITEM_UUID_REGISTRY.remove(itemUUID);
            }
            container.remove(uuidKey);
            item.setItemMeta(meta);
        }
    }

    public static void clearUUIDRegistry() {
        ITEM_UUID_REGISTRY.clear();
    }

    public static void scheduleUUIDCleanup(Plugin plugin) {
        plugin.getServer().getScheduler().runTaskTimerAsynchronously(plugin, () -> AntiScamUtils.cleanExpiredUUIDs(), 72000L, 72000L);
    }
}

