/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.io.BukkitObjectInputStream;

public class ItemUtils {
    public static String serializeItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.set("item", (Object)item);
        return Base64.getEncoder().encodeToString(config.saveToString().getBytes());
    }

    public static ItemStack deserializeItem(String data) {
        if (data == null) {
            return null;
        }
        try {
            String yamlString = new String(Base64.getDecoder().decode(data));
            YamlConfiguration config = new YamlConfiguration();
            config.loadFromString(yamlString);
            return config.getItemStack("item");
        }
        catch (Exception e) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
                ItemStack item = (ItemStack)dataInput.readObject();
                dataInput.close();
                return item;
            }
            catch (Exception ex) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static String getItemName(ItemStack item) {
        ItemMeta meta;
        if (item == null) {
            return "Unknown";
        }
        if (item.hasItemMeta() && (meta = item.getItemMeta()) != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        return ItemUtils.formatMaterialName(item.getType());
    }

    public static String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        StringBuilder formatted = new StringBuilder();
        for (String word : name.split(" ")) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
        }
        return formatted.toString();
    }

    public static String getItemKey(ItemStack item) {
        if (item == null) {
            return "unknown";
        }
        StringBuilder key = new StringBuilder(item.getType().name());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container;
            if (meta.hasDisplayName()) {
                key.append("_").append(meta.getDisplayName().replaceAll("[^a-zA-Z0-9]", ""));
            }
            if (meta.hasEnchants()) {
                for (Map.Entry ench : meta.getEnchants().entrySet()) {
                    key.append("_").append(((Enchantment)ench.getKey()).getKey().getKey()).append(ench.getValue());
                }
            }
            if (!(container = meta.getPersistentDataContainer()).getKeys().isEmpty()) {
                for (NamespacedKey nk : container.getKeys()) {
                    key.append("_").append(nk.getKey());
                }
            }
        }
        return key.toString().toLowerCase();
    }

    public static boolean hasInventorySpace(Player player, ItemStack item, int amount) {
        int space = 0;
        ItemStack checkItem = item.clone();
        checkItem.setAmount(1);
        int maxStack = checkItem.getMaxStackSize();
        for (ItemStack invItem : player.getInventory().getStorageContents()) {
            if (invItem == null || invItem.getType() == Material.AIR) {
                space += maxStack;
                continue;
            }
            if (!invItem.isSimilar(checkItem)) continue;
            space += Math.max(0, maxStack - invItem.getAmount());
        }
        return space >= amount;
    }

    public static boolean isSimilarItem(ItemStack item1, ItemStack item2) {
        if (item1 == null || item2 == null) {
            return false;
        }
        if (item1.getType() != item2.getType()) {
            return false;
        }
        ItemMeta meta1 = item1.getItemMeta();
        ItemMeta meta2 = item2.getItemMeta();
        if (meta1 == null && meta2 == null) {
            return true;
        }
        if (meta1 == null || meta2 == null) {
            return false;
        }
        if (!ItemUtils.equalDisplayName(meta1, meta2)) {
            return false;
        }
        if (!ItemUtils.equalLore(meta1, meta2)) {
            return false;
        }
        if (!ItemUtils.equalEnchants(meta1, meta2)) {
            return false;
        }
        return ItemUtils.equalPersistentData(meta1, meta2);
    }

    private static boolean equalDisplayName(ItemMeta meta1, ItemMeta meta2) {
        if (meta1.hasDisplayName() != meta2.hasDisplayName()) {
            return false;
        }
        if (meta1.hasDisplayName()) {
            return meta1.getDisplayName().equals(meta2.getDisplayName());
        }
        return true;
    }

    private static boolean equalLore(ItemMeta meta1, ItemMeta meta2) {
        if (meta1.hasLore() != meta2.hasLore()) {
            return false;
        }
        if (meta1.hasLore()) {
            return meta1.getLore().equals(meta2.getLore());
        }
        return true;
    }

    private static boolean equalEnchants(ItemMeta meta1, ItemMeta meta2) {
        return meta1.getEnchants().equals(meta2.getEnchants());
    }

    private static boolean equalPersistentData(ItemMeta meta1, ItemMeta meta2) {
        PersistentDataContainer c1 = meta1.getPersistentDataContainer();
        PersistentDataContainer c2 = meta2.getPersistentDataContainer();
        if (c1.getKeys().size() != c2.getKeys().size()) {
            return false;
        }
        for (NamespacedKey key : c1.getKeys()) {
            Object v2;
            Object v1;
            if (!(c2.has(key, PersistentDataType.STRING) || c2.has(key, PersistentDataType.INTEGER) || c2.has(key, PersistentDataType.DOUBLE) || c2.has(key, PersistentDataType.BYTE) || c2.has(key, PersistentDataType.LONG))) {
                return false;
            }
            if (c2.has(key, PersistentDataType.STRING)) {
                v1 = (String)c1.get(key, PersistentDataType.STRING);
                v2 = (String)c2.get(key, PersistentDataType.STRING);
                if (!(v1 == null ? v2 != null : !((String)v1).equals(v2))) continue;
                return false;
            }
            if (c2.has(key, PersistentDataType.INTEGER)) {
                v1 = (Integer)c1.get(key, PersistentDataType.INTEGER);
                v2 = (Integer)c2.get(key, PersistentDataType.INTEGER);
                if (!(v1 == null ? v2 != null : !((Integer)v1).equals(v2))) continue;
                return false;
            }
            if (c2.has(key, PersistentDataType.DOUBLE)) {
                v1 = (Double)c1.get(key, PersistentDataType.DOUBLE);
                v2 = (Double)c2.get(key, PersistentDataType.DOUBLE);
                if (!(v1 == null ? v2 != null : !((Double)v1).equals(v2))) continue;
                return false;
            }
            if (c2.has(key, PersistentDataType.BYTE)) {
                v1 = (Byte)c1.get(key, PersistentDataType.BYTE);
                v2 = (Byte)c2.get(key, PersistentDataType.BYTE);
                if (!(v1 == null ? v2 != null : !((Byte)v1).equals(v2))) continue;
                return false;
            }
            if (!c2.has(key, PersistentDataType.LONG)) continue;
            v1 = (Long)c1.get(key, PersistentDataType.LONG);
            v2 = (Long)c2.get(key, PersistentDataType.LONG);
            if (!(v1 == null ? v2 != null : !((Long)v1).equals(v2))) continue;
            return false;
        }
        return true;
    }

    public static String getCategory(ItemStack item) {
        Material type = item.getType();
        String typeName = type.name();
        if (typeName.equals("ENCHANTED_BOOK")) {
            return "ENCHANTED_BOOKS";
        }
        if (typeName.endsWith("_SWORD") || typeName.endsWith("_AXE") || typeName.endsWith("_PICKAXE") || typeName.endsWith("_SHOVEL") || typeName.endsWith("_HOE") || typeName.contains("BOW") || typeName.equals("TRIDENT") || typeName.equals("SHIELD") || typeName.equals("FISHING_ROD") || typeName.equals("FLINT_AND_STEEL") || typeName.equals("SHEARS")) {
            return "WEAPONS_TOOLS";
        }
        if (typeName.endsWith("_HELMET") || typeName.endsWith("_CHESTPLATE") || typeName.endsWith("_LEGGINGS") || typeName.endsWith("_BOOTS") || typeName.equals("ELYTRA") || typeName.equals("TURTLE_HELMET")) {
            return "ARMOR";
        }
        if (type.isEdible() || typeName.contains("POTION") || typeName.equals("GOLDEN_APPLE") || typeName.equals("ENCHANTED_GOLDEN_APPLE")) {
            return "CONSUMABLES";
        }
        if (typeName.contains("SPAWN_EGG") || typeName.contains("BUCKET") || typeName.equals("ENDER_PEARL") || typeName.equals("ENDER_EYE") || typeName.equals("EXPERIENCE_BOTTLE") || typeName.equals("TOTEM_OF_UNDYING")) {
            return "SPECIAL_ITEMS";
        }
        if (typeName.contains("DYE") || typeName.contains("WOOL") || typeName.contains("BANNER") || typeName.contains("CARPET") || typeName.contains("STAINED") || typeName.contains("GLAZED")) {
            return "DECORATIVE";
        }
        if (typeName.contains("REDSTONE") || typeName.equals("REPEATER") || typeName.equals("COMPARATOR") || typeName.contains("PISTON") || typeName.contains("HOPPER") || typeName.contains("RAIL")) {
            return "REDSTONE";
        }
        if (type.isBlock()) {
            return "BLOCKS";
        }
        return "MATERIALS";
    }

    public static String formatTimeRemaining(LocalDateTime expiryTime) {
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(expiryTime)) {
            return "\u00a7cExpired";
        }
        Duration duration = Duration.between(now, expiryTime);
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        if (days > 0L) {
            return String.format("\u00a7e%dd %dh", days, hours);
        }
        if (hours > 0L) {
            return String.format("\u00a7e%dh %dm", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("\u00a7e%dm", minutes);
        }
        return "\u00a7c<1m";
    }
}

