/*
 * Decompiled with CFR 0.152.
 */
package MPP.marketPlacePlus.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;

public class SearchHelper {
    private static final Map<String, Set<Material>> ITEM_ALIASES = new HashMap<String, Set<Material>>();
    private static final Map<String, Set<String>> SEARCH_SYNONYMS = new HashMap<String, Set<String>>();
    private static final Map<Material, Set<String>> MATERIAL_TAGS = new HashMap<Material, Set<String>>();

    private static void initializeAliases() {
        SearchHelper.addAlias("sword", Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD);
        SearchHelper.addAlias("pickaxe", Material.WOODEN_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.DIAMOND_PICKAXE, Material.NETHERITE_PICKAXE);
        SearchHelper.addAlias("axe", Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE);
        SearchHelper.addAlias("shovel", Material.WOODEN_SHOVEL, Material.STONE_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL);
        SearchHelper.addAlias("hoe", Material.WOODEN_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE);
        SearchHelper.addAlias("helmet", Material.LEATHER_HELMET, Material.CHAINMAIL_HELMET, Material.IRON_HELMET, Material.GOLDEN_HELMET, Material.DIAMOND_HELMET, Material.NETHERITE_HELMET, Material.TURTLE_HELMET);
        SearchHelper.addAlias("chestplate", Material.LEATHER_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.IRON_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.NETHERITE_CHESTPLATE, Material.ELYTRA);
        SearchHelper.addAlias("leggings", Material.LEATHER_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.IRON_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.NETHERITE_LEGGINGS);
        SearchHelper.addAlias("boots", Material.LEATHER_BOOTS, Material.CHAINMAIL_BOOTS, Material.IRON_BOOTS, Material.GOLDEN_BOOTS, Material.DIAMOND_BOOTS, Material.NETHERITE_BOOTS);
        SearchHelper.addAlias("armor", Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS, Material.TURTLE_HELMET, Material.ELYTRA);
        SearchHelper.addAlias("tools", Material.WOODEN_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.DIAMOND_PICKAXE, Material.NETHERITE_PICKAXE, Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE, Material.WOODEN_SHOVEL, Material.STONE_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL, Material.WOODEN_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE, Material.SHEARS, Material.FLINT_AND_STEEL, Material.FISHING_ROD);
        SearchHelper.addAlias("weapons", Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD, Material.BOW, Material.CROSSBOW, Material.TRIDENT, Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE);
        SearchHelper.addAlias("food", Material.APPLE, Material.GOLDEN_APPLE, Material.ENCHANTED_GOLDEN_APPLE, Material.BREAD, Material.COOKED_BEEF, Material.COOKED_CHICKEN, Material.COOKED_COD, Material.COOKED_MUTTON, Material.COOKED_PORKCHOP, Material.COOKED_RABBIT, Material.COOKED_SALMON, Material.COOKIE, Material.MELON_SLICE, Material.PUMPKIN_PIE, Material.RABBIT_STEW, Material.MUSHROOM_STEW, Material.BEETROOT_SOUP, Material.SWEET_BERRIES, Material.HONEY_BOTTLE, Material.GOLDEN_CARROT);
        SearchHelper.addAlias("wood", Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.DARK_OAK_LOG, Material.MANGROVE_LOG, Material.CHERRY_LOG, Material.OAK_PLANKS, Material.SPRUCE_PLANKS, Material.BIRCH_PLANKS, Material.JUNGLE_PLANKS, Material.ACACIA_PLANKS, Material.DARK_OAK_PLANKS, Material.MANGROVE_PLANKS, Material.CHERRY_PLANKS);
        SearchHelper.addAlias("ores", Material.COAL_ORE, Material.IRON_ORE, Material.GOLD_ORE, Material.DIAMOND_ORE, Material.EMERALD_ORE, Material.LAPIS_ORE, Material.REDSTONE_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.DEEPSLATE_COPPER_ORE, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE, Material.ANCIENT_DEBRIS);
        SearchHelper.addAlias("ingots", Material.IRON_INGOT, Material.GOLD_INGOT, Material.NETHERITE_INGOT, Material.COPPER_INGOT);
        SearchHelper.addAlias("gems", Material.DIAMOND, Material.EMERALD, Material.LAPIS_LAZULI, Material.AMETHYST_SHARD, Material.QUARTZ);
        SearchHelper.addAlias("blocks", Material.STONE, Material.COBBLESTONE, Material.DIRT, Material.GRASS_BLOCK, Material.SAND, Material.GRAVEL, Material.GLASS, Material.WHITE_WOOL, Material.BRICKS, Material.OBSIDIAN, Material.NETHERRACK, Material.END_STONE);
        SearchHelper.addAlias("redstone", Material.REDSTONE, Material.REDSTONE_TORCH, Material.REDSTONE_BLOCK, Material.REPEATER, Material.COMPARATOR, Material.PISTON, Material.STICKY_PISTON, Material.OBSERVER, Material.HOPPER, Material.DROPPER, Material.DISPENSER, Material.REDSTONE_LAMP, Material.TRIPWIRE_HOOK, Material.LEVER, Material.STONE_BUTTON, Material.OAK_BUTTON);
        SearchHelper.addAlias("potions", Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.GLASS_BOTTLE, Material.DRAGON_BREATH, Material.BLAZE_POWDER, Material.MAGMA_CREAM, Material.BREWING_STAND, Material.CAULDRON, Material.GLISTERING_MELON_SLICE, Material.GOLDEN_CARROT, Material.FERMENTED_SPIDER_EYE, Material.SPIDER_EYE, Material.SUGAR, Material.RABBIT_FOOT, Material.GHAST_TEAR, Material.PHANTOM_MEMBRANE);
        SearchHelper.addAlias("enchanted", Material.ENCHANTED_BOOK, Material.ENCHANTING_TABLE, Material.ENCHANTED_GOLDEN_APPLE);
        SearchHelper.addAlias("spawn_eggs", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().endsWith("_SPAWN_EGG")).toArray(Material[]::new));
        SearchHelper.addAlias("music", Material.MUSIC_DISC_13, Material.MUSIC_DISC_CAT, Material.MUSIC_DISC_BLOCKS, Material.MUSIC_DISC_CHIRP, Material.MUSIC_DISC_FAR, Material.MUSIC_DISC_MALL, Material.MUSIC_DISC_MELLOHI, Material.MUSIC_DISC_STAL, Material.MUSIC_DISC_STRAD, Material.MUSIC_DISC_WARD, Material.MUSIC_DISC_11, Material.MUSIC_DISC_WAIT, Material.MUSIC_DISC_PIGSTEP, Material.MUSIC_DISC_OTHERSIDE, Material.JUKEBOX);
        SearchHelper.addAlias("flowers", Material.DANDELION, Material.POPPY, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.RED_TULIP, Material.ORANGE_TULIP, Material.WHITE_TULIP, Material.PINK_TULIP, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.WITHER_ROSE, Material.SUNFLOWER, Material.LILAC, Material.ROSE_BUSH, Material.PEONY);
        SearchHelper.addAlias("dyes", Material.WHITE_DYE, Material.ORANGE_DYE, Material.MAGENTA_DYE, Material.LIGHT_BLUE_DYE, Material.YELLOW_DYE, Material.LIME_DYE, Material.PINK_DYE, Material.GRAY_DYE, Material.LIGHT_GRAY_DYE, Material.CYAN_DYE, Material.PURPLE_DYE, Material.BLUE_DYE, Material.BROWN_DYE, Material.GREEN_DYE, Material.RED_DYE, Material.BLACK_DYE);
        SearchHelper.addAlias("concrete", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().contains("CONCRETE") && !m.name().contains("POWDER")).toArray(Material[]::new));
        SearchHelper.addAlias("glass", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().contains("GLASS") || m.name().contains("_PANE")).toArray(Material[]::new));
        SearchHelper.addAlias("terracotta", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().contains("TERRACOTTA")).toArray(Material[]::new));
        SearchHelper.addAlias("wool", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().endsWith("_WOOL")).toArray(Material[]::new));
        SearchHelper.addAlias("bed", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().endsWith("_BED")).toArray(Material[]::new));
        SearchHelper.addAlias("banner", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().endsWith("_BANNER")).toArray(Material[]::new));
        SearchHelper.addAlias("shulker", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().contains("SHULKER")).toArray(Material[]::new));
        SearchHelper.addAlias("coral", (Material[])Arrays.stream(Material.values()).filter(m -> m.name().contains("CORAL")).toArray(Material[]::new));
    }

    private static void initializeSynonyms() {
        SearchHelper.addSynonym("diamond", "dia", "diam", "d");
        SearchHelper.addSynonym("netherite", "neth", "nether");
        SearchHelper.addSynonym("iron", "fe", "metal");
        SearchHelper.addSynonym("gold", "au", "golden");
        SearchHelper.addSynonym("emerald", "em", "emer");
        SearchHelper.addSynonym("enchanted", "ench", "e", "enchant");
        SearchHelper.addSynonym("potion", "pot", "brew");
        SearchHelper.addSynonym("sword", "blade", "weapon");
        SearchHelper.addSynonym("pickaxe", "pick", "paxe");
        SearchHelper.addSynonym("chestplate", "chest", "tunic", "vest");
        SearchHelper.addSynonym("leggings", "legs", "pants", "trousers");
        SearchHelper.addSynonym("helmet", "helm", "hat", "cap");
        SearchHelper.addSynonym("boots", "shoes", "feet");
        SearchHelper.addSynonym("sharpness", "sharp", "dmg");
        SearchHelper.addSynonym("protection", "prot", "p");
        SearchHelper.addSynonym("efficiency", "eff", "fast");
        SearchHelper.addSynonym("unbreaking", "unbr", "dura", "durability");
        SearchHelper.addSynonym("fortune", "fort", "luck");
        SearchHelper.addSynonym("silk_touch", "silk", "st");
        SearchHelper.addSynonym("looting", "loot");
        SearchHelper.addSynonym("infinity", "inf", "infinite");
        SearchHelper.addSynonym("mending", "mend", "repair");
        SearchHelper.addSynonym("power", "pow", "damage");
        SearchHelper.addSynonym("flame", "fire", "burn");
        SearchHelper.addSynonym("knockback", "kb", "knock");
        SearchHelper.addSynonym("thorns", "thorn", "spike");
        SearchHelper.addSynonym("depth_strider", "depth", "ds", "water_speed");
        SearchHelper.addSynonym("aqua_affinity", "aqua", "aa", "water_mine");
        SearchHelper.addSynonym("respiration", "resp", "breath", "water_breath");
        SearchHelper.addSynonym("feather_falling", "ff", "fall", "feather");
    }

    private static void initializeTags() {
        SearchHelper.addTags(Material.DIAMOND_SWORD, "weapon", "melee", "combat", "pvp", "valuable", "endgame");
        SearchHelper.addTags(Material.NETHERITE_SWORD, "weapon", "melee", "combat", "pvp", "valuable", "endgame", "best");
        SearchHelper.addTags(Material.DIAMOND_PICKAXE, "tool", "mining", "valuable", "endgame");
        SearchHelper.addTags(Material.NETHERITE_PICKAXE, "tool", "mining", "valuable", "endgame", "best");
        SearchHelper.addTags(Material.ELYTRA, "armor", "flying", "rare", "endgame", "valuable", "wings");
        SearchHelper.addTags(Material.ENCHANTED_GOLDEN_APPLE, "food", "pvp", "rare", "valuable", "notch", "god");
        SearchHelper.addTags(Material.TOTEM_OF_UNDYING, "rare", "valuable", "survival", "raid", "lifesaver");
        SearchHelper.addTags(Material.BEACON, "utility", "buff", "expensive", "endgame");
        SearchHelper.addTags(Material.DRAGON_EGG, "decoration", "rare", "trophy", "endgame", "unique");
        SearchHelper.addTags(Material.NETHER_STAR, "rare", "boss", "valuable", "beacon");
        SearchHelper.addTags(Material.WITHER_SKELETON_SKULL, "rare", "boss", "summon", "decoration");
        SearchHelper.addTags(Material.HEART_OF_THE_SEA, "rare", "ocean", "conduit", "valuable");
        SearchHelper.addTags(Material.TRIDENT, "weapon", "ranged", "melee", "rare", "ocean", "throwable");
        SearchHelper.addTags(Material.SHULKER_BOX, "storage", "utility", "endgame", "portable");
        SearchHelper.addTags(Material.ENDER_CHEST, "storage", "utility", "personal", "safe");
        SearchHelper.addTags(Material.ENCHANTED_BOOK, "enchantment", "upgrade", "valuable", "utility");
        SearchHelper.addTags(Material.ANVIL, "utility", "repair", "combine", "enchant");
        SearchHelper.addTags(Material.BREWING_STAND, "utility", "potion", "alchemy");
        SearchHelper.addTags(Material.ENCHANTING_TABLE, "utility", "enchant", "upgrade", "magic");
        SearchHelper.addTags(Material.NETHERITE_INGOT, "material", "rare", "valuable", "upgrade", "endgame");
        SearchHelper.addTags(Material.ANCIENT_DEBRIS, "ore", "rare", "nether", "netherite", "valuable");
    }

    private static void addAlias(String alias, Material ... materials) {
        ITEM_ALIASES.put(alias.toLowerCase(), new HashSet<Material>(Arrays.asList(materials)));
    }

    private static void addSynonym(String main, String ... synonyms) {
        HashSet<String> synSet = new HashSet<String>(Arrays.asList(synonyms));
        synSet.add(main);
        for (String syn : synSet) {
            SEARCH_SYNONYMS.put(syn.toLowerCase(), synSet);
        }
    }

    private static void addTags(Material material, String ... tags) {
        MATERIAL_TAGS.put(material, new HashSet<String>(Arrays.asList(tags)));
    }

    public static List<Material> getMaterialsFromAlias(String alias) {
        Set<Material> materials = ITEM_ALIASES.get(alias.toLowerCase());
        return materials != null ? new ArrayList<Material>(materials) : Collections.emptyList();
    }

    public static Set<String> expandSearchTerms(String term) {
        HashSet<String> expanded = new HashSet<String>();
        expanded.add(term.toLowerCase());
        Set<String> synonyms = SEARCH_SYNONYMS.get(term.toLowerCase());
        if (synonyms != null) {
            expanded.addAll(synonyms);
        }
        return expanded;
    }

    public static boolean matchesTags(Material material, String searchTerm) {
        Set<String> tags = MATERIAL_TAGS.get(material);
        if (tags == null) {
            return false;
        }
        String lowerSearch = searchTerm.toLowerCase();
        return tags.stream().anyMatch(tag -> tag.toLowerCase().contains(lowerSearch));
    }

    public static double calculateFuzzyScore(String text, String query) {
        if ((text = text.toLowerCase()).equals(query = query.toLowerCase())) {
            return 1.0;
        }
        if (text.contains(query)) {
            return 0.9;
        }
        return SearchHelper.levenshteinSimilarity(text, query);
    }

    private static double levenshteinSimilarity(String s1, String s2) {
        int maxLength = Math.max(s1.length(), s2.length());
        if (maxLength == 0) {
            return 1.0;
        }
        int distance = SearchHelper.levenshteinDistance(s1, s2);
        return 1.0 - (double)distance / (double)maxLength;
    }

    private static int levenshteinDistance(String s1, String s2) {
        int i;
        int[][] dp = new int[s1.length() + 1][s2.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= s2.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= s1.length(); ++i) {
            for (int j = 1; j <= s2.length(); ++j) {
                int cost = s1.charAt(i - 1) == s2.charAt(j - 1) ? 0 : 1;
                dp[i][j] = Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + cost);
            }
        }
        return dp[s1.length()][s2.length()];
    }

    public static List<String> suggestCorrections(String query) {
        ArrayList<String> suggestions = new ArrayList<String>();
        String lowerQuery = query.toLowerCase();
        for (String alias : ITEM_ALIASES.keySet()) {
            double score = SearchHelper.calculateFuzzyScore(alias, lowerQuery);
            if (!(score > 0.7)) continue;
            suggestions.add(alias);
        }
        for (Material material : Material.values()) {
            String name = material.name().toLowerCase().replace("_", " ");
            double score = SearchHelper.calculateFuzzyScore(name, lowerQuery);
            if (!(score > 0.7)) continue;
            suggestions.add(name);
        }
        return suggestions.stream().distinct().sorted((a, b) -> Double.compare(SearchHelper.calculateFuzzyScore(b, lowerQuery), SearchHelper.calculateFuzzyScore(a, lowerQuery))).limit(5L).collect(Collectors.toList());
    }

    public static Map<Enchantment, String> parseEnchantmentQuery(String query) {
        String[] parts;
        HashMap<Enchantment, String> enchants = new HashMap<Enchantment, String>();
        for (String part : parts = query.split("\\s+")) {
            block1: for (Enchantment enchant : Enchantment.values()) {
                String enchantName = enchant.getKey().getKey().toLowerCase();
                Set<String> expanded = SearchHelper.expandSearchTerms(part);
                for (String term : expanded) {
                    if (!enchantName.contains(term)) continue;
                    enchants.put(enchant, part);
                    continue block1;
                }
            }
        }
        return enchants;
    }

    static {
        SearchHelper.initializeAliases();
        SearchHelper.initializeSynonyms();
        SearchHelper.initializeTags();
    }

    public static class SmartMatcher {
        private final String query;
        private final Set<String> expandedTerms;
        private final double minScore;

        public SmartMatcher(String query, double minScore) {
            this.query = query.toLowerCase();
            this.expandedTerms = SearchHelper.expandSearchTerms(query);
            this.minScore = minScore;
        }

        public boolean matches(String text) {
            String lowerText = text.toLowerCase();
            for (String term : this.expandedTerms) {
                if (!lowerText.contains(term)) continue;
                return true;
            }
            return SearchHelper.calculateFuzzyScore(lowerText, this.query) >= this.minScore;
        }

        public double getScore(String text) {
            String lowerText = text.toLowerCase();
            double maxScore = 0.0;
            for (String term : this.expandedTerms) {
                if (!lowerText.contains(term)) continue;
                maxScore = Math.max(maxScore, 0.95);
            }
            maxScore = Math.max(maxScore, SearchHelper.calculateFuzzyScore(lowerText, this.query));
            return maxScore;
        }
    }
}

