/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman;

import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.api.gamerule.MendermanGamerules;
import lgbt.greenhouse.menderman.gamerule.MendermanGamerulesInternal;
import lgbt.greenhouse.menderman.item.MendermanDefaultComponents;
import lgbt.greenhouse.menderman.item.MendermanDefaultComponentsNeoForge;
import lgbt.greenhouse.menderman.network.SyncGamerulesClientboundPacket;
import lgbt.greenhouse.menderman.network.UpdateGameruleClientboundPacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="menderman")
public class MendermanNeoForge {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        MendermanGamerules.init();
    }

    @SubscribeEvent
    public static void registerContent(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.DATA_COMPONENT_TYPE)) {
            MendermanDataComponents.DEFERRED.registerContents();
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        MendermanDefaultComponents.createFallbackRepairRequirements(event.getServer().overworld());
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppingEvent event) {
        MendermanDefaultComponents.resetFallbackRepairRequirements();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MendermanGamerulesInternal.syncGamerulesToPlayer(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void modifyDefaultComponents(ModifyDefaultComponentsEvent event) {
        MendermanDefaultComponentsNeoForge.modifyItemRepairMaterials((arg_0, arg_1) -> ((ModifyDefaultComponentsEvent)event).modify(arg_0, arg_1));
        MendermanDefaultComponentsNeoForge.modifyRepairRequirements((arg_0, arg_1) -> ((ModifyDefaultComponentsEvent)event).modify(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        event.registrar("1.0.0").playToClient(SyncGamerulesClientboundPacket.TYPE, SyncGamerulesClientboundPacket.STREAM_CODEC).playToClient(UpdateGameruleClientboundPacket.TYPE, UpdateGameruleClientboundPacket.STREAM_CODEC);
    }
}

