/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.gamerule;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.stream.Collectors;
import lgbt.greenhouse.menderman.api.gamerule.MendermanGamerules;
import lgbt.greenhouse.menderman.network.SyncGamerulesClientboundPacket;
import lgbt.greenhouse.menderman.platform.MendermanPlatformHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MendermanGamerulesInternal {
    @NotNull
    private static final Object2ObjectArrayMap<String, Boolean> CLIENT_GAMERULE_STORAGE = new Object2ObjectArrayMap();

    public static void init() {
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.getId(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.getId(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.getId(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.getId(), (Object)false);
    }

    public static void setGameruleStorageValue(String id, boolean value) {
        CLIENT_GAMERULE_STORAGE.put((Object)id, (Object)value);
    }

    public static void resetGameruleStorage() {
        Map<String, Boolean> newMap = CLIENT_GAMERULE_STORAGE.keySet().stream().collect(Collectors.toMap(o -> o, o -> false, (aBoolean, aBoolean2) -> false));
        CLIENT_GAMERULE_STORAGE.clear();
        CLIENT_GAMERULE_STORAGE.putAll(newMap);
    }

    public static void syncGamerulesToPlayer(ServerPlayer player) {
        MendermanPlatformHelper.getInstance().sendPacketToPlayer(player, new SyncGamerulesClientboundPacket(MendermanGamerulesInternal.constructStorageMap(player.level().getGameRules())));
    }

    private static Object2ObjectArrayMap<String, Boolean> constructStorageMap(GameRules gameRules) {
        Object2ObjectArrayMap constructedMap = new Object2ObjectArrayMap();
        constructedMap.put((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.getId(), (Object)gameRules.getBoolean(MendermanGamerules.COMPOUNDING_REPAIR_COST));
        constructedMap.put((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.getId(), (Object)gameRules.getBoolean(MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL));
        constructedMap.put((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.getId(), (Object)gameRules.getBoolean(MendermanGamerules.RENAMING_COSTS_EXPERIENCE));
        constructedMap.put((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.getId(), (Object)gameRules.getBoolean(MendermanGamerules.REPAIRING_COSTS_EXPERIENCE));
        return constructedMap;
    }

    public static boolean compoundingRepairCost(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getGameRules().getBoolean(MendermanGamerules.COMPOUNDING_REPAIR_COST);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.getId(), (Object)false);
    }

    public static boolean canRenamingDamageAnvil(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getGameRules().getBoolean(MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.getId(), (Object)false);
    }

    public static boolean doesRenameCostExperience(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getGameRules().getBoolean(MendermanGamerules.RENAMING_COSTS_EXPERIENCE);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.getId(), (Object)false);
    }

    public static boolean doesRepairingCostExperience(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getGameRules().getBoolean(MendermanGamerules.REPAIRING_COSTS_EXPERIENCE);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.getId(), (Object)false);
    }
}

