/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.emi.recipe;

import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import java.util.Random;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MendermanEmiAnvilRecipe
extends EmiAnvilRecipe {
    private final EmiStack tool;
    private final EmiIngredient resource;
    private final int uniq = EmiUtil.RANDOM.nextInt();

    public MendermanEmiAnvilRecipe(EmiStack tool, EmiIngredient resource, ResourceLocation id) {
        super(tool, resource, id);
        this.tool = tool;
        this.resource = resource;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        widgets.addGeneratedSlot(r -> this.getTool((Random)r, false), this.uniq, 0, 0);
        widgets.addSlot(this.resource, 49, 0);
        widgets.addGeneratedSlot(r -> this.getTool((Random)r, true), this.uniq, 107, 0).recipeContext((EmiRecipe)this);
    }

    private EmiStack getTool(Random r, boolean repaired) {
        ItemStack stack = this.tool.getItemStack().copy();
        if (stack.getMaxDamage() <= 0) {
            return this.tool;
        }
        int d = r.nextInt(stack.getMaxDamage());
        if (repaired) {
            int ingredientIndex = (int)(System.currentTimeMillis() / 1000L) % this.resource.getEmiStacks().size();
            ItemStack currentResource = ((EmiStack)this.resource.getEmiStacks().get(ingredientIndex)).getItemStack();
            if ((d -= MendermanRepairHelper.getRepairRequirementsRepairAmount(stack, currentResource).orElseGet(() -> stack.getMaxDamage() / 4)) <= 0) {
                return this.tool;
            }
        }
        stack.setDamageValue(d);
        return EmiStack.of((ItemStack)stack);
    }
}

