/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Repairable;

public class MendermanJeiHelper {
    public static Stream<IJeiAnvilRecipe> getMendermanRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return MendermanRecipeViewerHelper.getRepairStacks().stream().flatMap(item -> MendermanJeiHelper.getRepairRecipes(vanillaRecipeFactory, item));
    }

    public static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory, MendermanRecipeViewerHelper.RepairEntry entry) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        if (!entry.repairable().has(DataComponents.REPAIRABLE)) {
            return Stream.empty();
        }
        ItemStack stack = entry.repairable();
        Repairable repairable = (Repairable)entry.repairable().get(DataComponents.REPAIRABLE);
        assert (repairable != null);
        if (!repairable.items().equals(MendermanRecipeViewerHelper.EXPECTED_REPAIRABLE_VALUES.get(entry))) {
            return Stream.empty();
        }
        List<ItemStack> repairMaterials = repairable.items().stream().filter(Holder::isBound).map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance()).toList();
        String uid = EnchantedBookSubtypeInterpreter.INSTANCE.getStringName(stack);
        String ingredientIdPath = ResourceLocationUtil.sanitizePath((String)uid);
        ItemStack damagedThreeQuarters = stack.copy();
        damagedThreeQuarters.setDamageValue(stack.getMaxDamage() * 3 / 4);
        ItemStack repaired = stack.copy();
        if (damagedThreeQuarters.has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            repaired.setDamageValue(MendermanRepairHelper.getRepairRequirementsCombineAmount(damagedThreeQuarters, damagedThreeQuarters));
        } else {
            repaired.setDamageValue(repaired.getMaxDamage() / 2);
        }
        List<ItemStack> damagedThreeQuartersSingletonList = List.of(damagedThreeQuarters);
        IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damagedThreeQuartersSingletonList, damagedThreeQuartersSingletonList, List.of(stack), ResourceLocation.fromNamespaceAndPath((String)"menderman", (String)("anvil.self_repair." + ingredientIdPath)));
        recipes.add(repairWithSame);
        if (!repairMaterials.isEmpty()) {
            ItemStack damagedFully = stack.copy();
            damagedFully.setDamageValue(damagedFully.getMaxDamage());
            IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, damagedThreeQuartersSingletonList, ResourceLocation.fromNamespaceAndPath((String)"menderman", (String)("anvil.materials_repair." + ingredientIdPath)));
            recipes.add(repairWithMaterial);
        }
        return recipes.stream();
    }
}

