/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.registry;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import lgbt.greenhouse.menderman.Menderman;
import lgbt.greenhouse.menderman.registry.MendermanDeferredValue;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class MendermanDeferredRegistry<T> {
    public final Registry<T> registry;
    protected Set<MendermanDeferredValue<?, ?>> toRegister = new ObjectOpenHashSet();

    public static <T> MendermanDeferredRegistry<T> create(Registry<T> registry) {
        return new MendermanDeferredRegistry<T>(registry);
    }

    protected MendermanDeferredRegistry(Registry<T> registry) {
        this.registry = registry;
    }

    public <V extends T> MendermanDeferredValue<T, V> register(String path, Supplier<V> supplier) {
        ResourceKey key = ResourceKey.create((ResourceKey)this.registry.key(), (ResourceLocation)Menderman.id(path));
        return this.register(key, supplier);
    }

    public <V extends T> MendermanDeferredValue<T, V> register(ResourceKey<T> key, Supplier<V> supplier) {
        MendermanDeferredValue<T, V> value = new MendermanDeferredValue<T, V>(key, supplier, this);
        this.toRegister.add(value);
        return value;
    }

    public void registerContents() {
        for (MendermanDeferredValue<?, ?> value : List.copyOf(this.toRegister)) {
            value.registerHolder();
        }
        if (!this.toRegister.isEmpty()) {
            throw new IllegalStateException("Failed to register content for registry '" + String.valueOf(this.registry.key().location()) + "'.");
        }
        this.toRegister = null;
    }
}

