/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.registry;

import java.util.function.Supplier;
import lgbt.greenhouse.menderman.registry.MendermanDeferredRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class MendermanDeferredValue<T, V extends T>
implements Supplier<V> {
    private final ResourceKey<T> key;
    private final Supplier<V> supplier;
    private final MendermanDeferredRegistry<T> registry;
    private Holder<T> holder;

    protected MendermanDeferredValue(ResourceKey<T> key, Supplier<V> value, MendermanDeferredRegistry<T> registry) {
        this.key = key;
        this.supplier = value;
        this.registry = registry;
    }

    @Override
    public V get() {
        if (this.holder == null) {
            this.registerHolder();
        }
        return (V)this.holder.value();
    }

    public ResourceKey<T> key() {
        return this.key;
    }

    public Holder<T> holder() {
        if (this.holder == null) {
            this.registerHolder();
        }
        return this.holder;
    }

    protected void registerHolder() {
        this.holder = Registry.registerForHolder(this.registry.registry, this.key, this.supplier.get());
        this.registry.toRegister.remove(this);
    }
}

