/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.api;

import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.api.component.RepairRequirements;
import net.minecraft.core.HolderSet;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class MendermanRepairHelper {
    public static int getRepairItemCount(ItemStack stack, ItemStack repairStack) {
        return Math.min(Mth.ceil((float)((float)stack.getDamageValue() / (float)stack.getMaxDamage() * (float)MendermanRepairHelper.getMaximumItemRepairMaterialCount(stack, repairStack))), repairStack.getCount());
    }

    public static OptionalInt getRepairRequirementsRepairAmount(ItemStack stack, ItemStack repairStack) {
        if (stack.has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            RepairRequirements requirements = (RepairRequirements)stack.get(MendermanDataComponents.REPAIR_REQUIREMENTS.get());
            assert (requirements != null);
            int maxCount = MendermanRepairHelper.getMaximumItemRepairMaterialCount(stack, repairStack);
            int itemCount = maxCount - MendermanRepairHelper.getRepairItemCount(stack, repairStack);
            if (itemCount == maxCount) {
                return OptionalInt.of(0);
            }
            return OptionalInt.of(stack.getMaxDamage() / (itemCount + 1));
        }
        return OptionalInt.empty();
    }

    public static int getMaximumItemRepairMaterialCount(ItemStack stack, ItemStack repairStack) {
        if (stack.has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            RepairRequirements requirements = (RepairRequirements)stack.get(MendermanDataComponents.REPAIR_REQUIREMENTS.get());
            assert (requirements != null);
            return requirements.items().entrySet().stream().map(entry -> {
                if (((HolderSet)entry.getKey()).contains(repairStack.getItemHolder())) {
                    return (Integer)entry.getValue();
                }
                return null;
            }).filter(Objects::nonNull).min(Comparator.comparingInt(value -> value)).orElseGet(() -> requirements.fallback().orElse(1));
        }
        int repairCount = 0;
        int repairAmount = Math.min(stack.getDamageValue(), stack.getMaxDamage() / 4);
        for (int n = stack.getMaxDamage(); n > 0; n -= repairAmount) {
            ++repairCount;
            repairAmount = Math.min(stack.getDamageValue(), stack.getMaxDamage() / 4);
        }
        return repairCount;
    }

    public static int getRepairRequirementsCombineAmount(ItemStack stack, ItemStack otherStack) {
        int minDamageValue = Math.min(stack.getDamageValue(), otherStack.getDamageValue());
        int maxDamageValue = Math.max(stack.getDamageValue(), otherStack.getDamageValue());
        int maximumMaterialRepair = MendermanRepairHelper.getMaximumItemRepairMaterialCount(stack, otherStack);
        int repairAmount = stack.getMaxDamage() / Math.max(Mth.positiveCeilDiv((int)maxDamageValue, (int)(stack.getMaxDamage() / maximumMaterialRepair)), 1);
        return Math.max(0, minDamageValue - repairAmount);
    }
}

