/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.api.gamerule;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.serialization.Codec;
import lgbt.greenhouse.menderman.gamerule.MendermanGamerulesInternal;
import lgbt.greenhouse.menderman.registry.MendermanDeferredRegistry;
import lgbt.greenhouse.menderman.registry.MendermanDeferredValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRuleType;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MendermanGamerules {
    public static final MendermanDeferredRegistry<GameRule<?>> DEFERRED = MendermanDeferredRegistry.create(BuiltInRegistries.GAME_RULE);
    public static final MendermanDeferredValue<GameRule<?>, GameRule<@NotNull Boolean>> COMPOUNDING_REPAIR_COST = MendermanGamerules.createBoolean("compounding_repair_cost");
    public static final MendermanDeferredValue<GameRule<?>, GameRule<@NotNull Boolean>> RENAMING_CAN_DAMAGE_ANVIL = MendermanGamerules.createBoolean("renaming_can_damage_anvil");
    public static final MendermanDeferredValue<GameRule<?>, GameRule<@NotNull Boolean>> RENAMING_COSTS_EXPERIENCE = MendermanGamerules.createBoolean("renaming_costs_experience");
    public static final MendermanDeferredValue<GameRule<?>, GameRule<@NotNull Boolean>> REPAIRING_COSTS_EXPERIENCE = MendermanGamerules.createBoolean("repairing_costs_experience");

    public static boolean compoundingRepairCost(@Nullable Level level) {
        return MendermanGamerulesInternal.compoundingRepairCost(level);
    }

    public static boolean canRenamingDamageAnvil(@Nullable Level level) {
        return MendermanGamerulesInternal.canRenamingDamageAnvil(level);
    }

    public static boolean doesRenameCostExperience(@Nullable Level level) {
        return MendermanGamerulesInternal.doesRenameCostExperience(level);
    }

    public static boolean doesRepairingCostExperience(@Nullable Level level) {
        return MendermanGamerulesInternal.doesRepairingCostExperience(level);
    }

    private static MendermanDeferredValue<GameRule<?>, GameRule<@NotNull Boolean>> createBoolean(@NotNull String path) {
        return DEFERRED.register(path, () -> new GameRule(GameRuleCategory.MISC, GameRuleType.BOOL, (ArgumentType)BoolArgumentType.bool(), GameRuleTypeVisitor::visitBoolean, (Codec)Codec.BOOL, bool -> bool != false ? 1 : 0, (Object)false, FeatureFlagSet.of()));
    }
}

