/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.gamerule;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.stream.Collectors;
import lgbt.greenhouse.menderman.api.gamerule.MendermanGamerules;
import lgbt.greenhouse.menderman.network.SyncGamerulesClientboundPacket;
import lgbt.greenhouse.menderman.platform.MendermanPlatformHelper;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MendermanGamerulesInternal {
    @NotNull
    private static final Object2ObjectArrayMap<Identifier, Boolean> CLIENT_GAMERULE_STORAGE = new Object2ObjectArrayMap();

    public static void init() {
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.key().identifier(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.key().identifier(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.key().identifier(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.key().identifier(), (Object)false);
    }

    public static void setGameruleStorageValue(Identifier id, boolean value) {
        CLIENT_GAMERULE_STORAGE.put((Object)id, (Object)value);
    }

    public static void resetGameruleStorage() {
        Map<Identifier, Boolean> newMap = CLIENT_GAMERULE_STORAGE.keySet().stream().collect(Collectors.toMap(o -> o, o -> false, (aBoolean, aBoolean2) -> false));
        CLIENT_GAMERULE_STORAGE.clear();
        CLIENT_GAMERULE_STORAGE.putAll(newMap);
    }

    public static void syncGamerulesToPlayer(ServerPlayer player) {
        MendermanPlatformHelper.getInstance().sendPacketToPlayer(player, new SyncGamerulesClientboundPacket(MendermanGamerulesInternal.constructStorageMap(player.level().getGameRules())));
    }

    private static Object2ObjectArrayMap<Identifier, Boolean> constructStorageMap(GameRules gameRules) {
        Object2ObjectArrayMap constructedMap = new Object2ObjectArrayMap();
        constructedMap.put((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.key().identifier(), (Object)((Boolean)gameRules.get(MendermanGamerules.COMPOUNDING_REPAIR_COST.get())));
        constructedMap.put((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.key().identifier(), (Object)((Boolean)gameRules.get(MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.get())));
        constructedMap.put((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.key().identifier(), (Object)((Boolean)gameRules.get(MendermanGamerules.RENAMING_COSTS_EXPERIENCE.get())));
        constructedMap.put((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.key().identifier(), (Object)((Boolean)gameRules.get(MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.get())));
        return constructedMap;
    }

    public static boolean compoundingRepairCost(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (Boolean)serverLevel.getGameRules().get(MendermanGamerules.COMPOUNDING_REPAIR_COST.get());
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.key().identifier(), (Object)false);
    }

    public static boolean canRenamingDamageAnvil(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (Boolean)serverLevel.getGameRules().get(MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.get());
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.key().identifier(), (Object)false);
    }

    public static boolean doesRenameCostExperience(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (Boolean)serverLevel.getGameRules().get(MendermanGamerules.RENAMING_COSTS_EXPERIENCE.get());
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.key().identifier(), (Object)false);
    }

    public static boolean doesRepairingCostExperience(@Nullable Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (Boolean)serverLevel.getGameRules().get(MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.get());
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.key().identifier(), (Object)false);
    }
}

