/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.api.component.Repairable;
import lgbt.greenhouse.menderman.platform.MendermanPlatformHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MendermanRecipeViewerHelper {
    private static final Set<String> RECIPE_VIEWERS_WITH_REPAIR_RECIPES = Set.of("emi", "jei", "roughlyenoughitems");
    public static final Map<Item, HolderSet<Item>> EXPECTED_REPAIRABLE_VALUES = new LinkedHashMap<Item, HolderSet<Item>>();

    public static boolean hasRecipeViewer() {
        return RECIPE_VIEWERS_WITH_REPAIR_RECIPES.stream().anyMatch(string -> MendermanPlatformHelper.getInstance().isModLoaded((String)string));
    }

    public static List<RepairEntry> getRepairStacks() {
        ArrayList<RepairEntry> repairEntries = new ArrayList<RepairEntry>();
        for (Item item : EXPECTED_REPAIRABLE_VALUES.keySet()) {
            if (!item.components().has(MendermanDataComponents.REPAIRABLE.get())) continue;
            ItemStack stack = item.getDefaultInstance();
            Repairable repairable = (Repairable)item.components().get(MendermanDataComponents.REPAIRABLE.get());
            assert (repairable != null);
            if (!repairable.items().equals(EXPECTED_REPAIRABLE_VALUES.get(item))) continue;
            List<ItemStack> repairMaterials = repairable.items().stream().filter(Holder::isBound).map(itemHolder -> ((Item)itemHolder.value()).getDefaultInstance()).toList();
            repairEntries.add(new RepairEntry(stack, repairMaterials));
        }
        return repairEntries;
    }

    public record RepairEntry(ItemStack repairable, List<ItemStack> materials) {
    }
}

