/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import lgbt.greenhouse.menderman.integration.emi.recipe.MendermanEmiAnvilRecipe;
import lgbt.greenhouse.menderman.integration.emi.recipe.MendermanEmiAnvilRepairItemRecipe;
import lgbt.greenhouse.menderman.integration.emi.recipe.MendermanEmiGrindstoneRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@EmiEntrypoint
public class MendermanEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.removeRecipes(emiRecipe -> {
            if (emiRecipe.getId() != null && emiRecipe.getId().getNamespace().equals("emi") && (emiRecipe.getId().getPath().startsWith("/anvil/repairing/material/") || emiRecipe.getId().getPath().startsWith("/anvil/repairing/tool/") || emiRecipe.getId().getPath().startsWith("/anvil/repairing/grindstone/"))) {
                ItemStack stack = ((EmiStack)((EmiIngredient)emiRecipe.getInputs().getFirst()).getEmiStacks().getFirst()).getItemStack();
                return MendermanRecipeViewerHelper.getRepairStacks().stream().anyMatch(entry -> entry.repairable().is(stack.getItem())) || stack.has(MendermanDataComponents.REPAIRABLE.get());
            }
            return false;
        });
        MendermanEmiPlugin.createMaterialRepairRecipes(registry);
    }

    private static void createMaterialRepairRecipes(EmiRegistry emiRegistry) {
        List<MendermanRecipeViewerHelper.RepairEntry> repairEntryMap = MendermanRecipeViewerHelper.getRepairStacks();
        Consumer<EmiRecipe> consumer = arg_0 -> ((EmiRegistry)emiRegistry).addRecipe(arg_0);
        for (MendermanRecipeViewerHelper.RepairEntry entry : repairEntryMap) {
            MendermanEmiPlugin.addRepairEntryAnvilRecipes(consumer, entry);
            MendermanEmiPlugin.addRepairEntryGrindstoneRecipe(consumer, entry);
        }
    }

    private static void addRepairEntryAnvilRecipes(Consumer<EmiRecipe> addRecipeConsumer, MendermanRecipeViewerHelper.RepairEntry entry) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry.repairable().getItem());
        if (!entry.materials().isEmpty()) {
            MendermanEmiAnvilRecipe repairWithMaterial = new MendermanEmiAnvilRecipe(EmiStack.of((ItemStack)entry.repairable()), EmiIngredient.of(entry.materials().stream().map(EmiStack::of).toList()), ResourceLocation.fromNamespaceAndPath((String)"menderman", (String)("/anvil/repairing/material/" + itemId.getNamespace() + "/" + itemId.getPath() + "/repairable_component")));
            addRecipeConsumer.accept((EmiRecipe)repairWithMaterial);
            addRecipeConsumer.accept((EmiRecipe)new MendermanEmiAnvilRepairItemRecipe(entry.repairable().getItem(), ResourceLocation.fromNamespaceAndPath((String)"menderman", (String)("/anvil/repairing/tool/" + itemId.getNamespace() + "/" + itemId.getPath()))));
        }
    }

    private static void addRepairEntryGrindstoneRecipe(Consumer<EmiRecipe> addRecipeConsumer, MendermanRecipeViewerHelper.RepairEntry entry) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry.repairable().getItem());
        if (!entry.materials().isEmpty()) {
            addRecipeConsumer.accept((EmiRecipe)new MendermanEmiGrindstoneRecipe(entry.repairable().getItem(), ResourceLocation.fromNamespaceAndPath((String)"menderman", (String)("/grindstone/repairing/" + itemId.getNamespace() + "/" + itemId.getPath()))));
        }
    }

    public static List<EmiRecipe> sortAnvilRecipes(List<EmiRecipe> list) {
        ArrayList<EmiRecipe> newList = new ArrayList<EmiRecipe>(list);
        for (int i = 0; i < list.size(); ++i) {
            EmiRecipe recipe = list.get(i);
            if (recipe.getId() == null || !(recipe instanceof MendermanEmiAnvilRecipe) && !(recipe instanceof MendermanEmiAnvilRepairItemRecipe)) continue;
            OptionalInt indexOfPrecursor = list.stream().filter(emiRecipe -> emiRecipe.getCategory().equals(recipe.getCategory()) && ((EmiIngredient)emiRecipe.getInputs().getFirst()).equals(recipe.getInputs().getFirst()) && recipe.getId() != null && emiRecipe.getId() != null && emiRecipe.getId().getNamespace().startsWith("emi") && (emiRecipe.getId().getPath().startsWith("/anvil/repairing/tool") || emiRecipe.getId().getPath().startsWith("/grindstone/repairing/"))).mapToInt(newList::indexOf).min();
            indexOfPrecursor.ifPresent(value -> {
                newList.remove(recipe);
                newList.add(value, recipe);
            });
        }
        return newList;
    }
}

