/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.emi.recipe;

import com.google.common.collect.Lists;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MendermanEmiAnvilRepairItemRecipe
extends EmiAnvilRepairItemRecipe {
    private final Item tool;

    public MendermanEmiAnvilRepairItemRecipe(Item tool, ResourceLocation id) {
        super(tool, id);
        this.tool = tool;
    }

    protected EmiStack getItem(Random random, int item) {
        ArrayList items = Lists.newArrayList();
        items.add(this.getTool(random));
        items.add(this.getTool(random));
        items.add(this.getMergeItems(items));
        return EmiStack.of((ItemStack)((ItemStack)items.get(item)));
    }

    private ItemStack getMergeItems(List<ItemStack> items) {
        ItemStack item = this.tool.getDefaultInstance();
        int maxDamage = item.getMaxDamage();
        if (items.getFirst().has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            item.setDamageValue(MendermanRepairHelper.getRepairRequirementsCombineAmount(items.getFirst(), items.getLast()));
        } else {
            item.setDamageValue(Math.max(0, items.getFirst().getDamageValue() - 21 * maxDamage / 20 + items.getLast().getDamageValue()));
        }
        return item;
    }

    private ItemStack getTool(Random r) {
        ItemStack stack = this.tool.getDefaultInstance();
        if (stack.getMaxDamage() <= 0) {
            return stack;
        }
        int d = r.nextInt(stack.getMaxDamage());
        stack.setDamageValue(d);
        return stack;
    }
}

