/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.rei;

import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.anvil.DefaultAnvilDisplay;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@REIPluginClient
public class MendermanReiClientPlugin
implements REIClientPlugin {
    private static List<Display> cachedAnvilDisplays = null;

    public void registerDisplays(DisplayRegistry registry) {
        cachedAnvilDisplays = null;
        registry.registerVisibilityPredicate((category, display) -> {
            if (category.getCategoryIdentifier().equals((Object)BuiltinPlugin.ANVIL) && display instanceof DefaultAnvilDisplay) {
                ItemStack stack;
                Object patt0$temp;
                DefaultAnvilDisplay anvilDisplay = (DefaultAnvilDisplay)display;
                if (anvilDisplay.getDisplayLocation().isPresent()) {
                    return EventResult.pass();
                }
                EntryStack inputEntryStack = (EntryStack)((EntryIngredient)anvilDisplay.getInputEntries().getFirst()).getFirst();
                EntryStack otherInputEntryStack = (EntryStack)((EntryIngredient)anvilDisplay.getInputEntries().getLast()).getFirst();
                EntryStack outputEntryStack = (EntryStack)((EntryIngredient)anvilDisplay.getOutputEntries().getFirst()).getFirst();
                if (inputEntryStack.getType() != VanillaEntryTypes.ITEM || outputEntryStack.getType() != VanillaEntryTypes.ITEM) {
                    return EventResult.pass();
                }
                ItemStack inputStack = (ItemStack)inputEntryStack.castValue();
                ItemStack outputStack = (ItemStack)outputEntryStack.castValue();
                ItemStack inputWithoutDamage = inputStack.copy();
                ItemStack outputWithoutDamage = outputStack.copy();
                inputWithoutDamage.setDamageValue(0);
                outputWithoutDamage.setDamageValue(0);
                if (ItemStack.isSameItemSameComponents((ItemStack)inputWithoutDamage, (ItemStack)outputWithoutDamage) && MendermanRecipeViewerHelper.getRepairStacks().stream().anyMatch(entry -> entry.repairable().is(inputStack.getItem())) || inputStack.has(MendermanDataComponents.REPAIRABLE.get()) && (!((patt0$temp = otherInputEntryStack.getValue()) instanceof ItemStack) || !(stack = (ItemStack)patt0$temp).is(Items.ENCHANTED_BOOK))) {
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
        MendermanReiClientPlugin.createMaterialRepairRecipes(registry);
    }

    private static void createMaterialRepairRecipes(DisplayRegistry registry) {
        List<MendermanRecipeViewerHelper.RepairEntry> repairEntryMap = MendermanRecipeViewerHelper.getRepairStacks();
        Consumer<Display> consumer = arg_0 -> ((DisplayRegistry)registry).add(arg_0);
        for (MendermanRecipeViewerHelper.RepairEntry entry : repairEntryMap) {
            MendermanReiClientPlugin.addRepairEntryAnvilRecipes(consumer, entry);
        }
    }

    private static void addRepairEntryAnvilRecipes(Consumer<Display> addRecipeConsumer, MendermanRecipeViewerHelper.RepairEntry entry) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)entry.repairable().getItem());
        if (!entry.materials().isEmpty()) {
            for (ItemStack material : entry.materials()) {
                ResourceLocation materialId = BuiltInRegistries.ITEM.getKey((Object)material.getItem());
                int maxRepairCount = MendermanRepairHelper.getMaximumItemRepairMaterialCount(entry.repairable(), material);
                for (int i = 1; i <= maxRepairCount; ++i) {
                    ItemStack repairable = entry.repairable().copy();
                    repairable.setDamageValue(i == 1 ? repairable.getMaxDamage() : repairable.getMaxDamage() - MendermanRepairHelper.getRepairRequirementsRepairAmount(repairable, material.copyWithCount(i - 1)).orElse(0));
                    ItemStack countedMaterial = material.copyWithCount(i);
                    ItemStack repaired = entry.repairable().copy();
                    repaired.setDamageValue(repairable.getMaxDamage() - MendermanRepairHelper.getRepairRequirementsRepairAmount(repairable, countedMaterial).orElse(repairable.getMaxDamage()));
                    addRecipeConsumer.accept((Display)new DefaultAnvilDisplay(List.of(EntryIngredients.of((ItemStack)repairable), EntryIngredients.of((ItemStack)countedMaterial)), List.of(EntryIngredients.of((ItemStack)repaired)), Optional.of(ResourceLocation.fromNamespaceAndPath((String)"menderman", (String)("anvil/repair/" + itemId.getNamespace() + "/" + itemId.getPath() + "/material/" + materialId.getNamespace() + "/" + materialId.getPath() + "/cost/" + i))), OptionalInt.of(i)));
                }
            }
        }
    }

    public static Map<CategoryIdentifier<?>, List<Display>> sortDisplayList(Map<CategoryIdentifier<?>, List<Display>> unmodified) {
        HashMap displays = new HashMap(unmodified);
        if (cachedAnvilDisplays == null) {
            cachedAnvilDisplays = MendermanReiClientPlugin.remapAnvilDisplays(unmodified.getOrDefault(BuiltinClientPlugin.ANVIL, Collections.emptyList()));
        }
        displays.put(BuiltinClientPlugin.ANVIL, cachedAnvilDisplays);
        return displays;
    }

    private static List<Display> remapAnvilDisplays(List<Display> list) {
        ArrayList<Display> newList = new ArrayList<Display>(list);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack otherStack;
            ItemStack stack;
            DefaultAnvilDisplay defaultAnvilDisplay;
            Object object;
            Display display = list.get(i);
            if (display.getDisplayLocation().isEmpty() || !(display instanceof DefaultAnvilDisplay) || !((object = ((EntryStack)((EntryIngredient)(defaultAnvilDisplay = (DefaultAnvilDisplay)display).getInputEntries().getFirst()).getFirst()).getValue()) instanceof ItemStack) || !(stack = (ItemStack)object).has(MendermanDataComponents.REPAIRABLE.get()) || !((object = ((EntryStack)((EntryIngredient)defaultAnvilDisplay.getInputEntries().getLast()).getFirst()).getValue()) instanceof ItemStack) || (otherStack = (ItemStack)object).is(Items.ENCHANTED_BOOK)) continue;
            OptionalInt indexOfPrecursor = list.stream().filter(existingDisplay -> {
                ItemStack secondStack;
                Object patt1$temp;
                ItemStack firstStack;
                Object patt0$temp;
                return existingDisplay.getDisplayLocation().isEmpty() && (patt0$temp = ((EntryStack)((EntryIngredient)existingDisplay.getInputEntries().getFirst()).getFirst()).getValue()) instanceof ItemStack && ItemStack.isSameItem((ItemStack)stack, (ItemStack)(firstStack = (ItemStack)patt0$temp)) && (patt1$temp = ((EntryStack)((EntryIngredient)existingDisplay.getInputEntries().getLast()).getFirst()).getValue()) instanceof ItemStack && !(secondStack = (ItemStack)patt1$temp).is(Items.ENCHANTED_BOOK);
            }).mapToInt(newList::indexOf).max();
            indexOfPrecursor.ifPresentOrElse(value -> {
                newList.remove(display);
                newList.add(value, display);
            }, () -> {
                OptionalInt indexBeforeEnchantments = list.stream().filter(existingDisplay -> {
                    ItemStack secondStack;
                    Object patt0$temp;
                    return existingDisplay.getDisplayLocation().isEmpty() && (patt0$temp = ((EntryStack)((EntryIngredient)existingDisplay.getInputEntries().getLast()).getFirst()).getValue()) instanceof ItemStack && (secondStack = (ItemStack)patt0$temp).is(Items.ENCHANTED_BOOK);
                }).mapToInt(newList::indexOf).min();
                indexBeforeEnchantments.ifPresent(value -> {
                    newList.remove(display);
                    newList.add(value, display);
                });
            });
        }
        return Collections.unmodifiableList(newList);
    }
}

