/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import lgbt.greenhouse.menderman.MendermanCompatibilityKeys;
import lgbt.greenhouse.menderman.MendermanTags;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.api.component.RepairRequirements;
import lgbt.greenhouse.menderman.api.component.Repairable;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import lgbt.greenhouse.menderman.mixin.Accessor_Item;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;

public class MendermanDefaultComponents {
    private static final List<Item> FALLBACK_REPAIRABLES = new ArrayList<Item>();
    private static final List<Item> FALLBACK_REPAIR_REQUIREMENTS = new ArrayList<Item>();

    public static Map<Item, Repairable> getDefaultRepairables() {
        LinkedHashMap<Item, Repairable> map = new LinkedHashMap<Item, Repairable>();
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.WOODEN_TOOL_MATERIALS, Items.WOODEN_SWORD, Items.WOODEN_PICKAXE, Items.WOODEN_AXE, Items.WOODEN_SHOVEL, Items.WOODEN_HOE);
        MendermanDefaultComponents.modifyRepairables(map, (TagKey<Item>)ItemTags.STONE_TOOL_MATERIALS, Items.STONE_SWORD, Items.STONE_PICKAXE, Items.STONE_AXE, Items.STONE_SHOVEL, Items.STONE_HOE);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.GOLD_TOOL_MATERIALS, Items.GOLDEN_SWORD, Items.GOLDEN_PICKAXE, Items.GOLDEN_AXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_HOE);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.IRON_TOOL_MATERIALS, Items.IRON_SWORD, Items.IRON_PICKAXE, Items.IRON_AXE, Items.IRON_SHOVEL, Items.IRON_HOE);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.DIAMOND_TOOL_MATERIALS, Items.DIAMOND_SWORD, Items.DIAMOND_PICKAXE, Items.DIAMOND_AXE, Items.DIAMOND_SHOVEL, Items.DIAMOND_HOE);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.NETHERITE_TOOL_MATERIALS, Items.NETHERITE_SWORD, Items.NETHERITE_PICKAXE, Items.NETHERITE_AXE, Items.NETHERITE_SHOVEL, Items.NETHERITE_HOE);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.REPAIRS_LEATHER_ARMOR, Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.REPAIRS_GOLD_ARMOR, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.REPAIRS_CHAIN_ARMOR, Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.REPAIRS_IRON_ARMOR, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.REPAIRS_DIAMOND_ARMOR, Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS);
        MendermanDefaultComponents.modifyRepairables(map, MendermanTags.ItemTags.REPAIRS_NETHERITE_ARMOR, Items.NETHERITE_HELMET, Items.NETHERITE_CHESTPLATE, Items.NETHERITE_LEGGINGS, Items.NETHERITE_BOOTS);
        MendermanDefaultComponents.modifyRepairable(map, Items.SHIELD, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.SHIELD_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.BOW, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.BOW_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.CROSSBOW, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.CROSSBOW_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.TRIDENT, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.TRIDENT_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.MACE, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.MACE_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.FISHING_ROD, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.FISHING_ROD_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.SHEARS, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.SHEARS_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.FLINT_AND_STEEL, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.FLINT_AND_STEEL_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.BRUSH, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.BRUSH_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.ELYTRA, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.ELYTRA_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.TURTLE_HELMET, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.TURTLE_HELMET_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.WOLF_ARMOR, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.WOLF_ARMOR_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.CARROT_ON_A_STICK, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.CARROT_ON_A_STICK_MATERIALS));
        MendermanDefaultComponents.modifyRepairable(map, Items.WARPED_FUNGUS_ON_A_STICK, MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.WARPED_FUNGUS_ON_A_STICK_MATERIALS));
        return map;
    }

    private static void modifyRepairables(Map<Item, Repairable> map, TagKey<Item> repairItemTag, Item ... items) {
        for (Item item : items) {
            MendermanDefaultComponents.modifyRepairable(map, item, MendermanDefaultComponents.getItemTag(repairItemTag));
        }
    }

    private static HolderSet<Item> getItemTag(TagKey<Item> tagKey) {
        return BuiltInRegistries.ITEM.getOrCreateTag(tagKey);
    }

    private static void modifyRepairable(Map<Item, Repairable> map, Item item, HolderSet<Item> repairItems) {
        map.put(item, new Repairable(repairItems));
        if (MendermanRecipeViewerHelper.hasRecipeViewer()) {
            MendermanRecipeViewerHelper.EXPECTED_REPAIRABLE_VALUES.put(item, repairItems);
        }
    }

    public static Map<Item, RepairRequirements> getDefaultRepairRequirements() {
        LinkedHashMap<Item, RepairRequirements> map = new LinkedHashMap<Item, RepairRequirements>();
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WOODEN_SWORD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WOODEN_PICKAXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WOODEN_AXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WOODEN_SHOVEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WOODEN_HOE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.STONE_SWORD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.STONE_PICKAXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.STONE_AXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.STONE_SHOVEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.STONE_HOE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.GOLDEN_SWORD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.GOLDEN_PICKAXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.GOLDEN_AXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.GOLDEN_SHOVEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.GOLDEN_HOE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.IRON_SWORD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.IRON_PICKAXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.IRON_AXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.IRON_SHOVEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.IRON_HOE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.DIAMOND_SWORD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.DIAMOND_PICKAXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.DIAMOND_AXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.DIAMOND_SHOVEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.DIAMOND_HOE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_SWORD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_PICKAXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_AXE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_SHOVEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_HOE, 1);
        MendermanDefaultComponents.armorRepairRequirement(map, Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS);
        MendermanDefaultComponents.armorRepairRequirement(map, Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS);
        MendermanDefaultComponents.armorRepairRequirement(map, Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS);
        MendermanDefaultComponents.armorRepairRequirement(map, Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.CHAINMAIL_HELMET, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.CHAINMAIL_CHESTPLATE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.CHAINMAIL_LEGGINGS, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.CHAINMAIL_BOOTS, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_HELMET, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_CHESTPLATE, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_LEGGINGS, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.NETHERITE_BOOTS, 1);
        map.put(Items.SHIELD, new RepairRequirements(Map.of(MendermanDefaultComponents.getItemTag(MendermanTags.ItemTags.IRON_TOOL_MATERIALS), 1), Optional.of(2)));
        MendermanDefaultComponents.constantRepairRequirement(map, Items.BOW, 2);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.CROSSBOW, 2);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.TRIDENT, 2);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.MACE, 2);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.FISHING_ROD, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.SHEARS, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.FLINT_AND_STEEL, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.BRUSH, 1);
        map.put(Items.ELYTRA, new RepairRequirements(Map.of(HolderSet.direct((Holder[])new Holder[]{Items.PHANTOM_MEMBRANE.builtInRegistryHolder()}), 1), Optional.of(3)));
        MendermanDefaultComponents.constantRepairRequirement(map, Items.TURTLE_HELMET, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WOLF_ARMOR, 2);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.CARROT_ON_A_STICK, 1);
        MendermanDefaultComponents.constantRepairRequirement(map, Items.WARPED_FUNGUS_ON_A_STICK, 1);
        return map;
    }

    private static void armorRepairRequirement(Map<Item, RepairRequirements> map, Item helmet, Item chestplate, Item leggings, Item boots) {
        MendermanDefaultComponents.constantRepairRequirement(map, helmet, 2);
        MendermanDefaultComponents.constantRepairRequirement(map, chestplate, 3);
        MendermanDefaultComponents.constantRepairRequirement(map, leggings, 3);
        MendermanDefaultComponents.constantRepairRequirement(map, boots, 2);
    }

    private static void constantRepairRequirement(Map<Item, RepairRequirements> map, Item item, int count) {
        map.put(item, new RepairRequirements(count));
    }

    public static void createFallbackRepairRequirements(ServerLevel serverLevel) {
        for (Item item : BuiltInRegistries.ITEM) {
            List<Object> existingRepairItems;
            ItemStack defaultInstance = item.getDefaultInstance();
            List<Object> list = existingRepairItems = item.components().has(MendermanDataComponents.REPAIRABLE.get()) ? Collections.emptyList() : MendermanDefaultComponents.getRepairItems(item);
            if (!item.components().has(MendermanDataComponents.REPAIRABLE.get()) && existingRepairItems.isEmpty() || defaultInstance.has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) continue;
            if (!existingRepairItems.isEmpty() && defaultInstance.is(MendermanCompatibilityKeys.FarmersDelight.KNIVES_TOOLS)) {
                if (existingRepairItems.contains(Items.FLINT)) {
                    MendermanDefaultComponents.fallbackRepairable(item, MendermanCompatibilityKeys.FarmersDelight.FLINT_TOOL_MATERIALS);
                } else if (existingRepairItems.contains(Items.GOLD_INGOT)) {
                    MendermanDefaultComponents.fallbackRepairable(item, MendermanTags.ItemTags.GOLD_TOOL_MATERIALS);
                } else if (existingRepairItems.contains(Items.IRON_INGOT)) {
                    MendermanDefaultComponents.fallbackRepairable(item, MendermanTags.ItemTags.IRON_TOOL_MATERIALS);
                } else if (existingRepairItems.contains(Items.DIAMOND)) {
                    MendermanDefaultComponents.fallbackRepairable(item, MendermanTags.ItemTags.DIAMOND_TOOL_MATERIALS);
                } else if (existingRepairItems.contains(Items.NETHERITE_INGOT)) {
                    MendermanDefaultComponents.fallbackRepairable(item, MendermanTags.ItemTags.NETHERITE_TOOL_MATERIALS);
                }
            }
            if (defaultInstance.is(ItemTags.SWORDS) || defaultInstance.is(ItemTags.PICKAXES) || defaultInstance.is(ItemTags.AXES) || defaultInstance.is(ItemTags.SHOVELS) || defaultInstance.is(ItemTags.HOES) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.BRUSH_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.IGNITER_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.SHEAR_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.FarmersDelight.KNIVES_TOOLS)) {
                MendermanDefaultComponents.fallbackRepairRequirement(item, 1);
                continue;
            }
            if (defaultInstance.is(ItemTags.HEAD_ARMOR) || defaultInstance.is(ItemTags.FOOT_ARMOR) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.BOW_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.CROSSBOW_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.FISHING_ROD_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.SPEAR_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.SHIELD_TOOLS) || defaultInstance.is(MendermanCompatibilityKeys.ConventionalTags.MACE_TOOLS)) {
                MendermanDefaultComponents.fallbackRepairRequirement(item, 2);
                continue;
            }
            if (defaultInstance.is(ItemTags.CHEST_ARMOR) || defaultInstance.is(ItemTags.LEG_ARMOR)) {
                MendermanDefaultComponents.fallbackRepairRequirement(item, 3);
                continue;
            }
            Optional<Integer> value = serverLevel.getRecipeManager().getRecipes().stream().map(recipeHolder -> {
                SmithingRecipe smithingRecipe;
                Recipe patt1$temp;
                CraftingRecipe craftingRecipe;
                Recipe patt0$temp = recipeHolder.value();
                if (patt0$temp instanceof CraftingRecipe && (craftingRecipe = (CraftingRecipe)patt0$temp).getResultItem((HolderLookup.Provider)serverLevel.registryAccess()).is(item)) {
                    if (craftingRecipe instanceof ShapedRecipe) {
                        ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
                        return Math.max(1, Mth.ceil((double)((double)shapedRecipe.getIngredients().stream().filter(ingredient -> Arrays.stream(ingredient.getItems()).anyMatch(stack -> stack.is(item))).toList().size() * 0.33)));
                    }
                    if (craftingRecipe instanceof ShapelessRecipe) {
                        ShapelessRecipe shapeless = (ShapelessRecipe)craftingRecipe;
                        return Math.max(1, Mth.ceil((double)((double)shapeless.getIngredients().stream().filter(ingredient -> Arrays.stream(ingredient.getItems()).anyMatch(stack -> stack.is(item))).toList().size() * 0.33)));
                    }
                }
                if ((patt1$temp = recipeHolder.value()) instanceof SmithingRecipe && (smithingRecipe = (SmithingRecipe)patt1$temp).getResultItem((HolderLookup.Provider)serverLevel.registryAccess()).is(item)) {
                    return 1;
                }
                return null;
            }).filter(Objects::nonNull).min(Comparator.comparingInt(intValue -> intValue));
            value.ifPresent(fullRepairRequirements -> MendermanDefaultComponents.fallbackRepairRequirement(item, fullRepairRequirements));
        }
    }

    private static List<Item> getRepairItems(Item item) {
        return BuiltInRegistries.ITEM.stream().filter(potential -> item.isValidRepairItem(item.getDefaultInstance(), potential.getDefaultInstance())).toList();
    }

    private static void fallbackRepairable(Item item, TagKey<Item> repairItems) {
        MendermanDefaultComponents.modifyComponents(item, builder -> builder.set(MendermanDataComponents.REPAIRABLE.get(), (Object)new Repairable((HolderSet<Item>)BuiltInRegistries.ITEM.getOrCreateTag(repairItems))));
        FALLBACK_REPAIRABLES.add(item);
    }

    private static void fallbackRepairRequirement(Item item, int count) {
        MendermanDefaultComponents.modifyComponents(item, builder -> builder.set(MendermanDataComponents.REPAIR_REQUIREMENTS.get(), (Object)new RepairRequirements(count)));
        FALLBACK_REPAIR_REQUIREMENTS.add(item);
    }

    public static void resetFallbackRepairRequirements() {
        for (Item item : FALLBACK_REPAIRABLES) {
            MendermanDefaultComponents.modifyComponents(item, builder -> builder.set(MendermanDataComponents.REPAIRABLE.get(), null));
        }
        FALLBACK_REPAIRABLES.clear();
        for (Item item : FALLBACK_REPAIR_REQUIREMENTS) {
            MendermanDefaultComponents.modifyComponents(item, builder -> builder.set(MendermanDataComponents.REPAIR_REQUIREMENTS.get(), null));
        }
        FALLBACK_REPAIR_REQUIREMENTS.clear();
    }

    private static void modifyComponents(Item item, Consumer<DataComponentMap.Builder> consumer) {
        DataComponentMap.Builder components = DataComponentMap.builder();
        components.addAll(item.components());
        consumer.accept(components);
        ((Accessor_Item)item).menderman$setComponents(components.build());
    }
}

