/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.OptionalInt;
import lgbt.greenhouse.menderman.Menderman;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.api.component.Repairable;
import lgbt.greenhouse.menderman.api.gamerule.MendermanGamerules;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class Mixin_AnvilMenu
extends ItemCombinerMenu {
    @Shadow
    private int repairItemCountCost;
    @Unique
    private boolean menderman$onlyRenaming = false;

    public Mixin_AnvilMenu(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access) {
        super(menuType, containerId, inventory, access);
    }

    @ModifyExpressionValue(method={"mayPickup"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/DataSlot;get()I", ordinal=1)})
    private int menderman$allowPickingUpForZeroCostActions(int original, @Local(argsOnly=true) boolean hasItem) {
        if (original == 0 && hasItem) {
            return Integer.MAX_VALUE;
        }
        return original;
    }

    @ModifyExpressionValue(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;isValidRepairItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    private boolean menderman$modifyRepairableResult(boolean original, @Local(ordinal=0) ItemStack stack, @Local(ordinal=2) ItemStack otherStack) {
        if (stack.has(MendermanDataComponents.REPAIRABLE.get())) {
            Repairable repairable = (Repairable)stack.get(MendermanDataComponents.REPAIRABLE.get());
            assert (repairable != null);
            return repairable.isValidRepairItem(otherStack);
        }
        return original;
    }

    @WrapOperation(method={"createResult"}, at={@At(value="INVOKE", target="Ljava/lang/Math;min(II)I")})
    private int menderman$modifyRepairAmount(int a, int b, Operation<Integer> original, @Local(ordinal=0) ItemStack stack, @Local(ordinal=2) ItemStack repairStack) {
        OptionalInt repairRequirementAmount = MendermanRepairHelper.getRepairRequirementsRepairAmount(stack, repairStack);
        if (repairRequirementAmount.isPresent()) {
            return repairRequirementAmount.getAsInt();
        }
        return (Integer)original.call(new Object[]{a, b});
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Ljava/lang/Math;min(II)I"), ordinal=0)
    private int menderman$modifyRepairExperienceCost(int original, @Local(ordinal=0) ItemStack stack, @Local(ordinal=2) ItemStack repairStack) {
        if (!MendermanGamerules.doesRepairingCostExperience(this.player.level())) {
            return 0;
        }
        return MendermanRepairHelper.getRepairItemCount(stack, repairStack);
    }

    @Inject(method={"createResult"}, at={@At(value="FIELD", target="Lnet/minecraft/world/inventory/AnvilMenu;repairItemCountCost:I", ordinal=1, shift=At.Shift.AFTER, opcode=181)})
    private void menderman$modifyRepairMaterialCost(CallbackInfo ci, @Local(ordinal=0) ItemStack stack, @Local(ordinal=1) ItemStack repairedStack, @Local(ordinal=2) ItemStack repairStack) {
        OptionalInt repairRequirementAmount = MendermanRepairHelper.getRepairRequirementsRepairAmount(stack, repairStack);
        if (repairRequirementAmount.isPresent()) {
            repairedStack.setDamageValue(repairedStack.getMaxDamage() - repairRequirementAmount.getAsInt());
        }
        this.repairItemCountCost = Math.min(this.repairItemCountCost, MendermanRepairHelper.getRepairItemCount(stack, repairStack));
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getDamageValue()I", ordinal=5), ordinal=6)
    private int menderman$modifytemCombiningRepairValue(int original, @Local(ordinal=0) ItemStack input, @Local(ordinal=2) ItemStack otherInput) {
        if (input.has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            return MendermanRepairHelper.getRepairRequirementsCombineAmount(input, otherInput);
        }
        return original;
    }

    @ModifyExpressionValue(method={"createResult"}, at={@At(value="INVOKE", target="Ljava/lang/Integer;intValue()I")})
    private int menderman$cancelIncreasedRepairCostStarting(int original) {
        if (!MendermanGamerules.compoundingRepairCost(this.player.level())) {
            return 0;
        }
        return original;
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1), ordinal=2)
    private int menderman$cancelIncreasedRepairCostBeforeRepairCost(int original) {
        if (!MendermanGamerules.compoundingRepairCost(this.player.level())) {
            return 0;
        }
        return original;
    }

    @WrapWithCondition(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1)})
    private boolean menderman$cancelSettingItemRepairCost(ItemStack instance, DataComponentType<?> componentType, Object value) {
        return MendermanGamerules.compoundingRepairCost(this.player.level());
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;setDamageValue(I)V"), ordinal=0)
    private int menderman$decreaseCombiningCost(int original, @Local(ordinal=0) ItemStack stack) {
        if (!MendermanGamerules.doesRepairingCostExperience(this.player.level())) {
            return original - 2;
        }
        if (stack.has(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            return original - 1;
        }
        return original;
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0), ordinal=0)
    private int menderman$cancelRenamingCost(int original, @Local(ordinal=1) int namingCost) {
        if (!MendermanGamerules.doesRenameCostExperience(this.player.level())) {
            this.menderman$onlyRenaming = original == namingCost;
            return original - 1;
        }
        return original;
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;remove(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;"), ordinal=0)
    private int menderman$cancelNameRemovalCost(int original, @Local(ordinal=1) int namingCost) {
        if (!MendermanGamerules.doesRenameCostExperience(this.player.level())) {
            this.menderman$onlyRenaming = original == namingCost;
            return original - 1;
        }
        return original;
    }

    @ModifyVariable(method={"createResult"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/inventory/DataSlot;set(I)V", ordinal=5), ordinal=0)
    private int menderman$cancelCostForChecksAfterRenaming(int original, @Local(ordinal=1) int namingCost) {
        if (this.menderman$onlyRenaming || this.repairItemCountCost > 0) {
            return this.menderman$onlyRenaming ? namingCost : this.repairItemCountCost;
        }
        return original;
    }

    @ModifyExpressionValue(method={"createResult"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack;EMPTY:Lnet/minecraft/world/item/ItemStack;", ordinal=4, opcode=178)})
    private ItemStack menderman$dontSetAnvilResultToEmpty(ItemStack original, @Local(ordinal=0) ItemStack stack, @Local(ordinal=1) ItemStack otherStack, @Local(ordinal=0) int cost) {
        if (cost == 0 && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)otherStack)) {
            return otherStack;
        }
        return original;
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void menderman$captureRenamingState(Player player, ItemStack stack, CallbackInfo ci) {
        Menderman.shouldDamageAnvil = MendermanGamerules.canRenamingDamageAnvil(player.level()) && this.menderman$onlyRenaming && this.repairItemCountCost == 0;
    }

    @WrapWithCondition(method={"onTake"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal=3)})
    private boolean menderman$dontItemsWhenRenaming(Container instance, int i, ItemStack stack) {
        return !this.menderman$onlyRenaming;
    }
}

