/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.api;

import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalInt;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.api.component.RepairRequirements;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_6885;

public class MendermanRepairHelper {
    public static int getRepairItemCount(class_1799 stack, class_1799 repairStack) {
        return Math.min(class_3532.method_15386((float)((float)stack.method_7919() / (float)stack.method_7936() * (float)MendermanRepairHelper.getMaximumItemRepairMaterialCount(stack, repairStack))), repairStack.method_7947());
    }

    public static OptionalInt getRepairRequirementsRepairAmount(class_1799 stack, class_1799 repairStack) {
        if (stack.method_57826(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            RepairRequirements requirements = (RepairRequirements)stack.method_58694(MendermanDataComponents.REPAIR_REQUIREMENTS.get());
            assert (requirements != null);
            int maxCount = MendermanRepairHelper.getMaximumItemRepairMaterialCount(stack, repairStack);
            int itemCount = maxCount - MendermanRepairHelper.getRepairItemCount(stack, repairStack);
            if (itemCount == maxCount) {
                return OptionalInt.of(0);
            }
            return OptionalInt.of(stack.method_7936() / (itemCount + 1));
        }
        return OptionalInt.empty();
    }

    public static int getMaximumItemRepairMaterialCount(class_1799 stack, class_1799 repairStack) {
        if (stack.method_57826(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            RepairRequirements requirements = (RepairRequirements)stack.method_58694(MendermanDataComponents.REPAIR_REQUIREMENTS.get());
            assert (requirements != null);
            return requirements.items().entrySet().stream().map(entry -> {
                if (((class_6885)entry.getKey()).method_40241(repairStack.method_41409())) {
                    return (Integer)entry.getValue();
                }
                return null;
            }).filter(Objects::nonNull).min(Comparator.comparingInt(value -> value)).orElseGet(() -> requirements.fallback().orElse(1));
        }
        int repairCount = 0;
        int repairAmount = Math.min(stack.method_7919(), stack.method_7936() / 4);
        for (int n = stack.method_7936(); n > 0; n -= repairAmount) {
            ++repairCount;
            repairAmount = Math.min(stack.method_7919(), stack.method_7936() / 4);
        }
        return repairCount;
    }

    public static int getRepairRequirementsCombineAmount(class_1799 stack, class_1799 otherStack) {
        int minDamageValue = Math.min(stack.method_7919(), otherStack.method_7919());
        int maxDamageValue = Math.max(stack.method_7919(), otherStack.method_7919());
        int maximumMaterialRepair = MendermanRepairHelper.getMaximumItemRepairMaterialCount(stack, otherStack);
        int repairAmount = stack.method_7936() / Math.max(class_3532.method_38788((int)maxDamageValue, (int)(stack.method_7936() / maximumMaterialRepair)), 1);
        return Math.max(0, minDamageValue - repairAmount);
    }
}

