/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.gamerule;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.stream.Collectors;
import lgbt.greenhouse.menderman.api.gamerule.MendermanGamerules;
import lgbt.greenhouse.menderman.network.SyncGamerulesClientboundPacket;
import lgbt.greenhouse.menderman.platform.MendermanPlatformHelper;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MendermanGamerulesInternal {
    @NotNull
    private static final Object2ObjectArrayMap<String, Boolean> CLIENT_GAMERULE_STORAGE = new Object2ObjectArrayMap();

    public static void init() {
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.method_20771(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.method_20771(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.method_20771(), (Object)false);
        CLIENT_GAMERULE_STORAGE.put((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.method_20771(), (Object)false);
    }

    public static void setGameruleStorageValue(String id, boolean value) {
        CLIENT_GAMERULE_STORAGE.put((Object)id, (Object)value);
    }

    public static void resetGameruleStorage() {
        Map<String, Boolean> newMap = CLIENT_GAMERULE_STORAGE.keySet().stream().collect(Collectors.toMap(o -> o, o -> false, (aBoolean, aBoolean2) -> false));
        CLIENT_GAMERULE_STORAGE.clear();
        CLIENT_GAMERULE_STORAGE.putAll(newMap);
    }

    public static void syncGamerulesToPlayer(class_3222 player) {
        MendermanPlatformHelper.getInstance().sendPacketToPlayer(player, new SyncGamerulesClientboundPacket(MendermanGamerulesInternal.constructStorageMap(player.method_51469().method_64395())));
    }

    private static Object2ObjectArrayMap<String, Boolean> constructStorageMap(class_1928 gameRules) {
        Object2ObjectArrayMap constructedMap = new Object2ObjectArrayMap();
        constructedMap.put((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.method_20771(), (Object)gameRules.method_8355(MendermanGamerules.COMPOUNDING_REPAIR_COST));
        constructedMap.put((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.method_20771(), (Object)gameRules.method_8355(MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL));
        constructedMap.put((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.method_20771(), (Object)gameRules.method_8355(MendermanGamerules.RENAMING_COSTS_EXPERIENCE));
        constructedMap.put((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.method_20771(), (Object)gameRules.method_8355(MendermanGamerules.REPAIRING_COSTS_EXPERIENCE));
        return constructedMap;
    }

    public static boolean compoundingRepairCost(@Nullable class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return serverLevel.method_64395().method_8355(MendermanGamerules.COMPOUNDING_REPAIR_COST);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.COMPOUNDING_REPAIR_COST.method_20771(), (Object)false);
    }

    public static boolean canRenamingDamageAnvil(@Nullable class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return serverLevel.method_64395().method_8355(MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.RENAMING_CAN_DAMAGE_ANVIL.method_20771(), (Object)false);
    }

    public static boolean doesRenameCostExperience(@Nullable class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return serverLevel.method_64395().method_8355(MendermanGamerules.RENAMING_COSTS_EXPERIENCE);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.RENAMING_COSTS_EXPERIENCE.method_20771(), (Object)false);
    }

    public static boolean doesRepairingCostExperience(@Nullable class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return serverLevel.method_64395().method_8355(MendermanGamerules.REPAIRING_COSTS_EXPERIENCE);
        }
        return (Boolean)CLIENT_GAMERULE_STORAGE.getOrDefault((Object)MendermanGamerules.REPAIRING_COSTS_EXPERIENCE.method_20771(), (Object)false);
    }
}

