/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import lgbt.greenhouse.menderman.integration.emi.recipe.MendermanEmiAnvilRecipe;
import lgbt.greenhouse.menderman.integration.emi.recipe.MendermanEmiAnvilRepairItemRecipe;
import lgbt.greenhouse.menderman.integration.emi.recipe.MendermanEmiGrindstoneRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@EmiEntrypoint
public class MendermanEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
    }

    private static void createMaterialRepairRecipes(EmiRegistry emiRegistry) {
        List<MendermanRecipeViewerHelper.RepairEntry> repairEntryMap = MendermanRecipeViewerHelper.getRepairStacks();
        Consumer<EmiRecipe> consumer = arg_0 -> ((EmiRegistry)emiRegistry).addRecipe(arg_0);
        for (MendermanRecipeViewerHelper.RepairEntry entry : repairEntryMap) {
            MendermanEmiPlugin.addRepairEntryAnvilRecipes(consumer, entry);
            MendermanEmiPlugin.addRepairEntryGrindstoneRecipe(consumer, entry);
        }
    }

    private static void addRepairEntryAnvilRecipes(Consumer<EmiRecipe> addRecipeConsumer, MendermanRecipeViewerHelper.RepairEntry entry) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.repairable().method_7909());
        if (!entry.materials().isEmpty()) {
            MendermanEmiAnvilRecipe repairWithMaterial = new MendermanEmiAnvilRecipe(EmiStack.of((class_1799)entry.repairable()), EmiIngredient.of(entry.materials().stream().map(EmiStack::of).toList()), class_2960.method_60655((String)"menderman", (String)("/anvil/repairing/material/" + itemId.method_12836() + "/" + itemId.method_12832() + "/repairable_component")));
            addRecipeConsumer.accept((EmiRecipe)repairWithMaterial);
            addRecipeConsumer.accept((EmiRecipe)new MendermanEmiAnvilRepairItemRecipe(entry.repairable().method_7909(), class_2960.method_60655((String)"menderman", (String)("/anvil/repairing/tool/" + itemId.method_12836() + "/" + itemId.method_12832()))));
        }
    }

    private static void addRepairEntryGrindstoneRecipe(Consumer<EmiRecipe> addRecipeConsumer, MendermanRecipeViewerHelper.RepairEntry entry) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)entry.repairable().method_7909());
        if (!entry.materials().isEmpty()) {
            addRecipeConsumer.accept((EmiRecipe)new MendermanEmiGrindstoneRecipe(entry.repairable().method_7909(), class_2960.method_60655((String)"menderman", (String)("/grindstone/repairing/" + itemId.method_12836() + "/" + itemId.method_12832()))));
        }
    }

    public static List<EmiRecipe> sortAnvilRecipes(List<EmiRecipe> list) {
        ArrayList<EmiRecipe> newList = new ArrayList<EmiRecipe>(list);
        for (int i = 0; i < list.size(); ++i) {
            EmiRecipe recipe = list.get(i);
            if (recipe.getId() == null || !(recipe instanceof MendermanEmiAnvilRecipe) && !(recipe instanceof MendermanEmiAnvilRepairItemRecipe)) continue;
            OptionalInt indexOfPrecursor = list.stream().filter(emiRecipe -> emiRecipe.getCategory().equals(recipe.getCategory()) && ((EmiIngredient)emiRecipe.getInputs().getFirst()).equals(recipe.getInputs().getFirst()) && recipe.getId() != null && emiRecipe.getId() != null && emiRecipe.getId().method_12836().startsWith("emi") && (emiRecipe.getId().method_12832().startsWith("/anvil/repairing/tool") || emiRecipe.getId().method_12832().startsWith("/grindstone/repairing/"))).mapToInt(newList::indexOf).min();
            indexOfPrecursor.ifPresent(value -> {
                newList.remove(recipe);
                newList.add(value, recipe);
            });
        }
        return newList;
    }
}

