/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.menderman.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lgbt.greenhouse.menderman.api.MendermanRepairHelper;
import lgbt.greenhouse.menderman.api.component.MendermanDataComponents;
import lgbt.greenhouse.menderman.integration.MendermanRecipeViewerHelper;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9890;

public class MendermanJeiHelper {
    public static Stream<IJeiAnvilRecipe> getMendermanRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return MendermanRecipeViewerHelper.getRepairStacks().stream().flatMap(item -> MendermanJeiHelper.getRepairRecipes(vanillaRecipeFactory, item));
    }

    public static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory, MendermanRecipeViewerHelper.RepairEntry entry) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        if (!entry.repairable().method_57826(class_9334.field_53696)) {
            return Stream.empty();
        }
        class_1799 stack = entry.repairable();
        class_9890 repairable = (class_9890)entry.repairable().method_58694(class_9334.field_53696);
        assert (repairable != null);
        if (!repairable.comp_2939().equals(MendermanRecipeViewerHelper.EXPECTED_REPAIRABLE_VALUES.get(entry))) {
            return Stream.empty();
        }
        List<class_1799> repairMaterials = repairable.comp_2939().method_40239().filter(class_6880::method_40227).map(itemHolder -> ((class_1792)itemHolder.comp_349()).method_7854()).toList();
        String uid = EnchantedBookSubtypeInterpreter.INSTANCE.getStringName(stack);
        String ingredientIdPath = ResourceLocationUtil.sanitizePath((String)uid);
        class_1799 damagedThreeQuarters = stack.method_7972();
        damagedThreeQuarters.method_7974(stack.method_7936() * 3 / 4);
        class_1799 repaired = stack.method_7972();
        if (damagedThreeQuarters.method_57826(MendermanDataComponents.REPAIR_REQUIREMENTS.get())) {
            repaired.method_7974(MendermanRepairHelper.getRepairRequirementsCombineAmount(damagedThreeQuarters, damagedThreeQuarters));
        } else {
            repaired.method_7974(repaired.method_7936() / 2);
        }
        List<class_1799> damagedThreeQuartersSingletonList = List.of(damagedThreeQuarters);
        IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(damagedThreeQuartersSingletonList, damagedThreeQuartersSingletonList, List.of(stack), class_2960.method_60655((String)"menderman", (String)("anvil.self_repair." + ingredientIdPath)));
        recipes.add(repairWithSame);
        if (!repairMaterials.isEmpty()) {
            class_1799 damagedFully = stack.method_7972();
            damagedFully.method_7974(damagedFully.method_7936());
            IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, damagedThreeQuartersSingletonList, class_2960.method_60655((String)"menderman", (String)("anvil.materials_repair." + ingredientIdPath)));
            recipes.add(repairWithMaterial);
        }
        return recipes.stream();
    }
}

